/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import io.confluent.csid.utils.StringUtils;
import io.confluent.parallelconsumer.RecordContext;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class ParallelConsumerOptions<K, V> {
    private final Consumer<K, V> consumer;
    private final Producer<K, V> producer;
    private final String managedExecutorService;
    private final String managedThreadFactory;
    private final MeterRegistry meterRegistry;
    private final Iterable<Tag> metricsTags;
    public static final int KAFKA_DEFAULT_AUTO_COMMIT_INTERVAL_MS = 5000;
    public static final Duration DEFAULT_COMMIT_INTERVAL = Duration.ofMillis(5000L);
    public static final Duration DEFAULT_COMMIT_INTERVAL_FOR_TRANSACTIONS = Duration.ofMillis(100L);
    private boolean allowEagerProcessingDuringTransactionCommit;
    private Duration commitLockAcquisitionTimeout;
    private Duration produceLockAcquisitionTimeout;
    private Duration commitInterval;
    private final ProcessingOrder ordering;
    private final CommitMode commitMode;
    private final int maxConcurrency;
    public static final int DEFAULT_MAX_CONCURRENCY = 16;
    public static final Duration DEFAULT_STATIC_RETRY_DELAY = Duration.ofSeconds(1L);
    private final InvalidOffsetMetadataHandlingPolicy invalidOffsetMetadataPolicy;
    @Deprecated
    private final Duration defaultMessageRetryDelay;
    private final Function<RecordContext<K, V>, Duration> retryDelayProvider;
    private final Duration sendTimeout;
    private final Duration offsetCommitTimeout;
    private final Integer batchSize;
    private final Duration thresholdForTimeSpendInQueueWarning;
    private final int maxFailureHistory;
    public final Duration shutdownTimeout;
    public final Duration drainTimeout;

    @Deprecated
    public void setCommitInterval(Duration commitInterval) {
        this.commitInterval = commitInterval;
    }

    public boolean isUsingBatching() {
        return this.getBatchSize() > 1;
    }

    public int getTargetAmountOfRecordsInFlight() {
        return this.getMaxConcurrency() * this.getBatchSize();
    }

    public void validate() {
        Objects.requireNonNull(this.consumer, "A consumer must be supplied");
        this.transactionsValidation();
    }

    private void transactionsValidation() {
        boolean commitInternalHasNotBeenSet;
        boolean bl = commitInternalHasNotBeenSet = this.getCommitInterval() == DEFAULT_COMMIT_INTERVAL;
        if (this.isUsingTransactionCommitMode()) {
            if (this.producer == null) {
                throw new IllegalArgumentException(StringUtils.msg("Cannot set {} to Transaction Producer mode ({}) without supplying a Producer instance", new Object[]{"commitMode", this.commitMode}));
            }
            if (commitInternalHasNotBeenSet) {
                this.commitInterval = DEFAULT_COMMIT_INTERVAL_FOR_TRANSACTIONS;
            }
        }
        if (!this.isUsingTransactionCommitMode() && this.isAllowEagerProcessingDuringTransactionCommit()) {
            throw new IllegalArgumentException(StringUtils.msg("Cannot set {} (eager record processing) when not using transactional commit mode ({}={}).", new Object[]{"allowEagerProcessingDuringTransactionCommit", "commitMode", this.commitMode}));
        }
    }

    @Deprecated
    public boolean isUsingTransactionalProducer() {
        return this.isUsingTransactionCommitMode();
    }

    public boolean isUsingTransactionCommitMode() {
        return this.commitMode.equals((Object)CommitMode.PERIODIC_TRANSACTIONAL_PRODUCER);
    }

    public boolean isProducerSupplied() {
        return this.getProducer() != null;
    }

    private static <K, V> String $default$managedExecutorService() {
        return "java:comp/DefaultManagedExecutorService";
    }

    private static <K, V> String $default$managedThreadFactory() {
        return "java:comp/DefaultManagedThreadFactory";
    }

    private static <K, V> MeterRegistry $default$meterRegistry() {
        return new CompositeMeterRegistry();
    }

    private static <K, V> Iterable<Tag> $default$metricsTags() {
        return Tags.empty();
    }

    private static <K, V> boolean $default$allowEagerProcessingDuringTransactionCommit() {
        return false;
    }

    private static <K, V> Duration $default$commitLockAcquisitionTimeout() {
        return Duration.ofMinutes(5L);
    }

    private static <K, V> Duration $default$produceLockAcquisitionTimeout() {
        return Duration.ofMinutes(1L);
    }

    private static <K, V> Duration $default$commitInterval() {
        return DEFAULT_COMMIT_INTERVAL;
    }

    private static <K, V> ProcessingOrder $default$ordering() {
        return ProcessingOrder.KEY;
    }

    private static <K, V> CommitMode $default$commitMode() {
        return CommitMode.PERIODIC_CONSUMER_ASYNCHRONOUS;
    }

    private static <K, V> int $default$maxConcurrency() {
        return 16;
    }

    private static <K, V> InvalidOffsetMetadataHandlingPolicy $default$invalidOffsetMetadataPolicy() {
        return InvalidOffsetMetadataHandlingPolicy.FAIL;
    }

    private static <K, V> Duration $default$defaultMessageRetryDelay() {
        return DEFAULT_STATIC_RETRY_DELAY;
    }

    private static <K, V> Duration $default$sendTimeout() {
        return Duration.ofSeconds(10L);
    }

    private static <K, V> Duration $default$offsetCommitTimeout() {
        return Duration.ofSeconds(10L);
    }

    private static <K, V> Integer $default$batchSize() {
        return 1;
    }

    private static <K, V> Duration $default$thresholdForTimeSpendInQueueWarning() {
        return Duration.ofSeconds(10L);
    }

    private static <K, V> int $default$maxFailureHistory() {
        return 10;
    }

    private static <K, V> Duration $default$shutdownTimeout() {
        return Duration.ofSeconds(10L);
    }

    private static <K, V> Duration $default$drainTimeout() {
        return Duration.ofSeconds(30L);
    }

    ParallelConsumerOptions(Consumer<K, V> consumer, Producer<K, V> producer, String managedExecutorService, String managedThreadFactory, MeterRegistry meterRegistry, Iterable<Tag> metricsTags, boolean allowEagerProcessingDuringTransactionCommit, Duration commitLockAcquisitionTimeout, Duration produceLockAcquisitionTimeout, Duration commitInterval, ProcessingOrder ordering, CommitMode commitMode, int maxConcurrency, InvalidOffsetMetadataHandlingPolicy invalidOffsetMetadataPolicy, Duration defaultMessageRetryDelay, Function<RecordContext<K, V>, Duration> retryDelayProvider, Duration sendTimeout, Duration offsetCommitTimeout, Integer batchSize, Duration thresholdForTimeSpendInQueueWarning, int maxFailureHistory, Duration shutdownTimeout, Duration drainTimeout) {
        this.consumer = consumer;
        this.producer = producer;
        this.managedExecutorService = managedExecutorService;
        this.managedThreadFactory = managedThreadFactory;
        this.meterRegistry = meterRegistry;
        this.metricsTags = metricsTags;
        this.allowEagerProcessingDuringTransactionCommit = allowEagerProcessingDuringTransactionCommit;
        this.commitLockAcquisitionTimeout = commitLockAcquisitionTimeout;
        this.produceLockAcquisitionTimeout = produceLockAcquisitionTimeout;
        this.commitInterval = commitInterval;
        this.ordering = ordering;
        this.commitMode = commitMode;
        this.maxConcurrency = maxConcurrency;
        this.invalidOffsetMetadataPolicy = invalidOffsetMetadataPolicy;
        this.defaultMessageRetryDelay = defaultMessageRetryDelay;
        this.retryDelayProvider = retryDelayProvider;
        this.sendTimeout = sendTimeout;
        this.offsetCommitTimeout = offsetCommitTimeout;
        this.batchSize = batchSize;
        this.thresholdForTimeSpendInQueueWarning = thresholdForTimeSpendInQueueWarning;
        this.maxFailureHistory = maxFailureHistory;
        this.shutdownTimeout = shutdownTimeout;
        this.drainTimeout = drainTimeout;
    }

    public static <K, V> ParallelConsumerOptionsBuilder<K, V> builder() {
        return new ParallelConsumerOptionsBuilder();
    }

    public ParallelConsumerOptionsBuilder<K, V> toBuilder() {
        return new ParallelConsumerOptionsBuilder<K, V>().consumer(this.consumer).producer(this.producer).managedExecutorService(this.managedExecutorService).managedThreadFactory(this.managedThreadFactory).meterRegistry(this.meterRegistry).metricsTags(this.metricsTags).allowEagerProcessingDuringTransactionCommit(this.allowEagerProcessingDuringTransactionCommit).commitLockAcquisitionTimeout(this.commitLockAcquisitionTimeout).produceLockAcquisitionTimeout(this.produceLockAcquisitionTimeout).commitInterval(this.commitInterval).ordering(this.ordering).commitMode(this.commitMode).maxConcurrency(this.maxConcurrency).invalidOffsetMetadataPolicy(this.invalidOffsetMetadataPolicy).defaultMessageRetryDelay(this.defaultMessageRetryDelay).retryDelayProvider(this.retryDelayProvider).sendTimeout(this.sendTimeout).offsetCommitTimeout(this.offsetCommitTimeout).batchSize(this.batchSize).thresholdForTimeSpendInQueueWarning(this.thresholdForTimeSpendInQueueWarning).maxFailureHistory(this.maxFailureHistory).shutdownTimeout(this.shutdownTimeout).drainTimeout(this.drainTimeout);
    }

    public Consumer<K, V> getConsumer() {
        return this.consumer;
    }

    public Producer<K, V> getProducer() {
        return this.producer;
    }

    public String getManagedExecutorService() {
        return this.managedExecutorService;
    }

    public String getManagedThreadFactory() {
        return this.managedThreadFactory;
    }

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public Iterable<Tag> getMetricsTags() {
        return this.metricsTags;
    }

    public boolean isAllowEagerProcessingDuringTransactionCommit() {
        return this.allowEagerProcessingDuringTransactionCommit;
    }

    public Duration getCommitLockAcquisitionTimeout() {
        return this.commitLockAcquisitionTimeout;
    }

    public Duration getProduceLockAcquisitionTimeout() {
        return this.produceLockAcquisitionTimeout;
    }

    public Duration getCommitInterval() {
        return this.commitInterval;
    }

    public ProcessingOrder getOrdering() {
        return this.ordering;
    }

    public CommitMode getCommitMode() {
        return this.commitMode;
    }

    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public InvalidOffsetMetadataHandlingPolicy getInvalidOffsetMetadataPolicy() {
        return this.invalidOffsetMetadataPolicy;
    }

    @Deprecated
    public Duration getDefaultMessageRetryDelay() {
        return this.defaultMessageRetryDelay;
    }

    public Function<RecordContext<K, V>, Duration> getRetryDelayProvider() {
        return this.retryDelayProvider;
    }

    public Duration getSendTimeout() {
        return this.sendTimeout;
    }

    public Duration getOffsetCommitTimeout() {
        return this.offsetCommitTimeout;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public Duration getThresholdForTimeSpendInQueueWarning() {
        return this.thresholdForTimeSpendInQueueWarning;
    }

    public int getMaxFailureHistory() {
        return this.maxFailureHistory;
    }

    public Duration getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public Duration getDrainTimeout() {
        return this.drainTimeout;
    }

    public String toString() {
        return "ParallelConsumerOptions(consumer=" + this.getConsumer() + ", producer=" + this.getProducer() + ", managedExecutorService=" + this.getManagedExecutorService() + ", managedThreadFactory=" + this.getManagedThreadFactory() + ", meterRegistry=" + this.getMeterRegistry() + ", metricsTags=" + this.getMetricsTags() + ", allowEagerProcessingDuringTransactionCommit=" + this.isAllowEagerProcessingDuringTransactionCommit() + ", commitLockAcquisitionTimeout=" + this.getCommitLockAcquisitionTimeout() + ", produceLockAcquisitionTimeout=" + this.getProduceLockAcquisitionTimeout() + ", commitInterval=" + this.getCommitInterval() + ", ordering=" + (Object)((Object)this.getOrdering()) + ", commitMode=" + (Object)((Object)this.getCommitMode()) + ", maxConcurrency=" + this.getMaxConcurrency() + ", invalidOffsetMetadataPolicy=" + (Object)((Object)this.getInvalidOffsetMetadataPolicy()) + ", defaultMessageRetryDelay=" + this.getDefaultMessageRetryDelay() + ", retryDelayProvider=" + this.getRetryDelayProvider() + ", sendTimeout=" + this.getSendTimeout() + ", offsetCommitTimeout=" + this.getOffsetCommitTimeout() + ", batchSize=" + this.getBatchSize() + ", thresholdForTimeSpendInQueueWarning=" + this.getThresholdForTimeSpendInQueueWarning() + ", maxFailureHistory=" + this.getMaxFailureHistory() + ", shutdownTimeout=" + this.getShutdownTimeout() + ", drainTimeout=" + this.getDrainTimeout() + ")";
    }

    public static enum InvalidOffsetMetadataHandlingPolicy {
        FAIL,
        IGNORE;

    }

    public static enum CommitMode {
        PERIODIC_TRANSACTIONAL_PRODUCER,
        PERIODIC_CONSUMER_SYNC,
        PERIODIC_CONSUMER_ASYNCHRONOUS;

    }

    public static enum ProcessingOrder {
        UNORDERED,
        PARTITION,
        KEY;

    }

    public static final class Fields {
        public static final String consumer = "consumer";
        public static final String producer = "producer";
        public static final String managedExecutorService = "managedExecutorService";
        public static final String managedThreadFactory = "managedThreadFactory";
        public static final String meterRegistry = "meterRegistry";
        public static final String metricsTags = "metricsTags";
        public static final String allowEagerProcessingDuringTransactionCommit = "allowEagerProcessingDuringTransactionCommit";
        public static final String commitLockAcquisitionTimeout = "commitLockAcquisitionTimeout";
        public static final String produceLockAcquisitionTimeout = "produceLockAcquisitionTimeout";
        public static final String commitInterval = "commitInterval";
        public static final String ordering = "ordering";
        public static final String commitMode = "commitMode";
        public static final String maxConcurrency = "maxConcurrency";
        public static final String invalidOffsetMetadataPolicy = "invalidOffsetMetadataPolicy";
        public static final String defaultMessageRetryDelay = "defaultMessageRetryDelay";
        public static final String retryDelayProvider = "retryDelayProvider";
        public static final String sendTimeout = "sendTimeout";
        public static final String offsetCommitTimeout = "offsetCommitTimeout";
        public static final String batchSize = "batchSize";
        public static final String thresholdForTimeSpendInQueueWarning = "thresholdForTimeSpendInQueueWarning";
        public static final String maxFailureHistory = "maxFailureHistory";
        public static final String shutdownTimeout = "shutdownTimeout";
        public static final String drainTimeout = "drainTimeout";
    }

    public static class ParallelConsumerOptionsBuilder<K, V> {
        private Consumer<K, V> consumer;
        private Producer<K, V> producer;
        private boolean managedExecutorService$set;
        private String managedExecutorService$value;
        private boolean managedThreadFactory$set;
        private String managedThreadFactory$value;
        private boolean meterRegistry$set;
        private MeterRegistry meterRegistry$value;
        private boolean metricsTags$set;
        private Iterable<Tag> metricsTags$value;
        private boolean allowEagerProcessingDuringTransactionCommit$set;
        private boolean allowEagerProcessingDuringTransactionCommit$value;
        private boolean commitLockAcquisitionTimeout$set;
        private Duration commitLockAcquisitionTimeout$value;
        private boolean produceLockAcquisitionTimeout$set;
        private Duration produceLockAcquisitionTimeout$value;
        private boolean commitInterval$set;
        private Duration commitInterval$value;
        private boolean ordering$set;
        private ProcessingOrder ordering$value;
        private boolean commitMode$set;
        private CommitMode commitMode$value;
        private boolean maxConcurrency$set;
        private int maxConcurrency$value;
        private boolean invalidOffsetMetadataPolicy$set;
        private InvalidOffsetMetadataHandlingPolicy invalidOffsetMetadataPolicy$value;
        private boolean defaultMessageRetryDelay$set;
        private Duration defaultMessageRetryDelay$value;
        private Function<RecordContext<K, V>, Duration> retryDelayProvider;
        private boolean sendTimeout$set;
        private Duration sendTimeout$value;
        private boolean offsetCommitTimeout$set;
        private Duration offsetCommitTimeout$value;
        private boolean batchSize$set;
        private Integer batchSize$value;
        private boolean thresholdForTimeSpendInQueueWarning$set;
        private Duration thresholdForTimeSpendInQueueWarning$value;
        private boolean maxFailureHistory$set;
        private int maxFailureHistory$value;
        private boolean shutdownTimeout$set;
        private Duration shutdownTimeout$value;
        private boolean drainTimeout$set;
        private Duration drainTimeout$value;

        ParallelConsumerOptionsBuilder() {
        }

        public ParallelConsumerOptionsBuilder<K, V> consumer(Consumer<K, V> consumer) {
            this.consumer = consumer;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> producer(Producer<K, V> producer) {
            this.producer = producer;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> managedExecutorService(String managedExecutorService) {
            this.managedExecutorService$value = managedExecutorService;
            this.managedExecutorService$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> managedThreadFactory(String managedThreadFactory) {
            this.managedThreadFactory$value = managedThreadFactory;
            this.managedThreadFactory$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> meterRegistry(MeterRegistry meterRegistry) {
            this.meterRegistry$value = meterRegistry;
            this.meterRegistry$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> metricsTags(Iterable<Tag> metricsTags) {
            this.metricsTags$value = metricsTags;
            this.metricsTags$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> allowEagerProcessingDuringTransactionCommit(boolean allowEagerProcessingDuringTransactionCommit) {
            this.allowEagerProcessingDuringTransactionCommit$value = allowEagerProcessingDuringTransactionCommit;
            this.allowEagerProcessingDuringTransactionCommit$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> commitLockAcquisitionTimeout(Duration commitLockAcquisitionTimeout) {
            this.commitLockAcquisitionTimeout$value = commitLockAcquisitionTimeout;
            this.commitLockAcquisitionTimeout$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> produceLockAcquisitionTimeout(Duration produceLockAcquisitionTimeout) {
            this.produceLockAcquisitionTimeout$value = produceLockAcquisitionTimeout;
            this.produceLockAcquisitionTimeout$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> commitInterval(Duration commitInterval) {
            this.commitInterval$value = commitInterval;
            this.commitInterval$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> ordering(ProcessingOrder ordering) {
            this.ordering$value = ordering;
            this.ordering$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> commitMode(CommitMode commitMode) {
            this.commitMode$value = commitMode;
            this.commitMode$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> maxConcurrency(int maxConcurrency) {
            this.maxConcurrency$value = maxConcurrency;
            this.maxConcurrency$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> invalidOffsetMetadataPolicy(InvalidOffsetMetadataHandlingPolicy invalidOffsetMetadataPolicy) {
            this.invalidOffsetMetadataPolicy$value = invalidOffsetMetadataPolicy;
            this.invalidOffsetMetadataPolicy$set = true;
            return this;
        }

        @Deprecated
        public ParallelConsumerOptionsBuilder<K, V> defaultMessageRetryDelay(Duration defaultMessageRetryDelay) {
            this.defaultMessageRetryDelay$value = defaultMessageRetryDelay;
            this.defaultMessageRetryDelay$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> retryDelayProvider(Function<RecordContext<K, V>, Duration> retryDelayProvider) {
            this.retryDelayProvider = retryDelayProvider;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> sendTimeout(Duration sendTimeout) {
            this.sendTimeout$value = sendTimeout;
            this.sendTimeout$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> offsetCommitTimeout(Duration offsetCommitTimeout) {
            this.offsetCommitTimeout$value = offsetCommitTimeout;
            this.offsetCommitTimeout$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> batchSize(Integer batchSize) {
            this.batchSize$value = batchSize;
            this.batchSize$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> thresholdForTimeSpendInQueueWarning(Duration thresholdForTimeSpendInQueueWarning) {
            this.thresholdForTimeSpendInQueueWarning$value = thresholdForTimeSpendInQueueWarning;
            this.thresholdForTimeSpendInQueueWarning$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> maxFailureHistory(int maxFailureHistory) {
            this.maxFailureHistory$value = maxFailureHistory;
            this.maxFailureHistory$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> shutdownTimeout(Duration shutdownTimeout) {
            this.shutdownTimeout$value = shutdownTimeout;
            this.shutdownTimeout$set = true;
            return this;
        }

        public ParallelConsumerOptionsBuilder<K, V> drainTimeout(Duration drainTimeout) {
            this.drainTimeout$value = drainTimeout;
            this.drainTimeout$set = true;
            return this;
        }

        public ParallelConsumerOptions<K, V> build() {
            String managedExecutorService$value = this.managedExecutorService$value;
            if (!this.managedExecutorService$set) {
                managedExecutorService$value = ParallelConsumerOptions.$default$managedExecutorService();
            }
            String managedThreadFactory$value = this.managedThreadFactory$value;
            if (!this.managedThreadFactory$set) {
                managedThreadFactory$value = ParallelConsumerOptions.$default$managedThreadFactory();
            }
            MeterRegistry meterRegistry$value = this.meterRegistry$value;
            if (!this.meterRegistry$set) {
                meterRegistry$value = ParallelConsumerOptions.$default$meterRegistry();
            }
            Iterable metricsTags$value = this.metricsTags$value;
            if (!this.metricsTags$set) {
                metricsTags$value = ParallelConsumerOptions.$default$metricsTags();
            }
            boolean allowEagerProcessingDuringTransactionCommit$value = this.allowEagerProcessingDuringTransactionCommit$value;
            if (!this.allowEagerProcessingDuringTransactionCommit$set) {
                allowEagerProcessingDuringTransactionCommit$value = ParallelConsumerOptions.$default$allowEagerProcessingDuringTransactionCommit();
            }
            Duration commitLockAcquisitionTimeout$value = this.commitLockAcquisitionTimeout$value;
            if (!this.commitLockAcquisitionTimeout$set) {
                commitLockAcquisitionTimeout$value = ParallelConsumerOptions.$default$commitLockAcquisitionTimeout();
            }
            Duration produceLockAcquisitionTimeout$value = this.produceLockAcquisitionTimeout$value;
            if (!this.produceLockAcquisitionTimeout$set) {
                produceLockAcquisitionTimeout$value = ParallelConsumerOptions.$default$produceLockAcquisitionTimeout();
            }
            Duration commitInterval$value = this.commitInterval$value;
            if (!this.commitInterval$set) {
                commitInterval$value = ParallelConsumerOptions.$default$commitInterval();
            }
            ProcessingOrder ordering$value = this.ordering$value;
            if (!this.ordering$set) {
                ordering$value = ParallelConsumerOptions.$default$ordering();
            }
            CommitMode commitMode$value = this.commitMode$value;
            if (!this.commitMode$set) {
                commitMode$value = ParallelConsumerOptions.$default$commitMode();
            }
            int maxConcurrency$value = this.maxConcurrency$value;
            if (!this.maxConcurrency$set) {
                maxConcurrency$value = ParallelConsumerOptions.$default$maxConcurrency();
            }
            InvalidOffsetMetadataHandlingPolicy invalidOffsetMetadataPolicy$value = this.invalidOffsetMetadataPolicy$value;
            if (!this.invalidOffsetMetadataPolicy$set) {
                invalidOffsetMetadataPolicy$value = ParallelConsumerOptions.$default$invalidOffsetMetadataPolicy();
            }
            Duration defaultMessageRetryDelay$value = this.defaultMessageRetryDelay$value;
            if (!this.defaultMessageRetryDelay$set) {
                defaultMessageRetryDelay$value = ParallelConsumerOptions.$default$defaultMessageRetryDelay();
            }
            Duration sendTimeout$value = this.sendTimeout$value;
            if (!this.sendTimeout$set) {
                sendTimeout$value = ParallelConsumerOptions.$default$sendTimeout();
            }
            Duration offsetCommitTimeout$value = this.offsetCommitTimeout$value;
            if (!this.offsetCommitTimeout$set) {
                offsetCommitTimeout$value = ParallelConsumerOptions.$default$offsetCommitTimeout();
            }
            Integer batchSize$value = this.batchSize$value;
            if (!this.batchSize$set) {
                batchSize$value = ParallelConsumerOptions.$default$batchSize();
            }
            Duration thresholdForTimeSpendInQueueWarning$value = this.thresholdForTimeSpendInQueueWarning$value;
            if (!this.thresholdForTimeSpendInQueueWarning$set) {
                thresholdForTimeSpendInQueueWarning$value = ParallelConsumerOptions.$default$thresholdForTimeSpendInQueueWarning();
            }
            int maxFailureHistory$value = this.maxFailureHistory$value;
            if (!this.maxFailureHistory$set) {
                maxFailureHistory$value = ParallelConsumerOptions.$default$maxFailureHistory();
            }
            Duration shutdownTimeout$value = this.shutdownTimeout$value;
            if (!this.shutdownTimeout$set) {
                shutdownTimeout$value = ParallelConsumerOptions.$default$shutdownTimeout();
            }
            Duration drainTimeout$value = this.drainTimeout$value;
            if (!this.drainTimeout$set) {
                drainTimeout$value = ParallelConsumerOptions.$default$drainTimeout();
            }
            return new ParallelConsumerOptions<K, V>(this.consumer, this.producer, managedExecutorService$value, managedThreadFactory$value, meterRegistry$value, metricsTags$value, allowEagerProcessingDuringTransactionCommit$value, commitLockAcquisitionTimeout$value, produceLockAcquisitionTimeout$value, commitInterval$value, ordering$value, commitMode$value, maxConcurrency$value, invalidOffsetMetadataPolicy$value, defaultMessageRetryDelay$value, this.retryDelayProvider, sendTimeout$value, offsetCommitTimeout$value, batchSize$value, thresholdForTimeSpendInQueueWarning$value, maxFailureHistory$value, shutdownTimeout$value, drainTimeout$value);
        }

        public String toString() {
            return "ParallelConsumerOptions.ParallelConsumerOptionsBuilder(consumer=" + this.consumer + ", producer=" + this.producer + ", managedExecutorService$value=" + this.managedExecutorService$value + ", managedThreadFactory$value=" + this.managedThreadFactory$value + ", meterRegistry$value=" + this.meterRegistry$value + ", metricsTags$value=" + this.metricsTags$value + ", allowEagerProcessingDuringTransactionCommit$value=" + this.allowEagerProcessingDuringTransactionCommit$value + ", commitLockAcquisitionTimeout$value=" + this.commitLockAcquisitionTimeout$value + ", produceLockAcquisitionTimeout$value=" + this.produceLockAcquisitionTimeout$value + ", commitInterval$value=" + this.commitInterval$value + ", ordering$value=" + (Object)((Object)this.ordering$value) + ", commitMode$value=" + (Object)((Object)this.commitMode$value) + ", maxConcurrency$value=" + this.maxConcurrency$value + ", invalidOffsetMetadataPolicy$value=" + (Object)((Object)this.invalidOffsetMetadataPolicy$value) + ", defaultMessageRetryDelay$value=" + this.defaultMessageRetryDelay$value + ", retryDelayProvider=" + this.retryDelayProvider + ", sendTimeout$value=" + this.sendTimeout$value + ", offsetCommitTimeout$value=" + this.offsetCommitTimeout$value + ", batchSize$value=" + this.batchSize$value + ", thresholdForTimeSpendInQueueWarning$value=" + this.thresholdForTimeSpendInQueueWarning$value + ", maxFailureHistory$value=" + this.maxFailureHistory$value + ", shutdownTimeout$value=" + this.shutdownTimeout$value + ", drainTimeout$value=" + this.drainTimeout$value + ")";
        }
    }
}

