/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.state;

import io.confluent.csid.utils.KafkaUtils;
import io.confluent.parallelconsumer.internal.EpochAndRecordsMap;
import io.confluent.parallelconsumer.offsets.OffsetMapCodecManager;
import io.confluent.parallelconsumer.state.PartitionState;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.NonNull;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemovedPartitionState<K, V>
extends PartitionState<K, V> {
    private static final Logger log = LoggerFactory.getLogger(RemovedPartitionState.class);
    private static final SortedSet<Long> READ_ONLY_EMPTY_SET = new TreeSet<Long>();
    private static final PartitionState singleton = new RemovedPartitionState();
    public static final String NO_OP = "no-op";
    public static final int NO_EPOCH = -1;

    public RemovedPartitionState() {
        super(-1L, null, null, OffsetMapCodecManager.HighestOffsetAndIncompletes.of());
    }

    public static PartitionState getSingleton() {
        return singleton;
    }

    @Override
    public boolean isRemoved() {
        return true;
    }

    @Override
    public TopicPartition getTp() {
        return null;
    }

    @Override
    public void maybeRegisterNewPollBatchAsWork(@NonNull EpochAndRecordsMap.RecordsAndEpoch recordsAndEpoch) {
        if (recordsAndEpoch == null) {
            throw new NullPointerException("recordsAndEpoch is marked non-null but is null");
        }
        log.warn("Dropping polled record batch for partition no longer assigned. WC: {}", (Object)recordsAndEpoch);
    }

    @Override
    boolean isAllowedMoreRecords() {
        log.debug(NO_OP);
        return true;
    }

    @Override
    public SortedSet<Long> getIncompleteOffsetsBelowHighestSucceeded() {
        log.debug(NO_OP);
        return READ_ONLY_EMPTY_SET;
    }

    @Override
    public long getOffsetHighestSeen() {
        log.debug(NO_OP);
        return -1L;
    }

    @Override
    public long getOffsetHighestSucceeded() {
        log.debug(NO_OP);
        return -1L;
    }

    @Override
    public boolean isRecordPreviouslyCompleted(ConsumerRecord<K, V> rec) {
        log.debug("Ignoring previously completed request for partition no longer assigned. Partition: {}", (Object)KafkaUtils.toTopicPartition(rec));
        return false;
    }

    @Override
    public boolean hasIncompleteOffsets() {
        return false;
    }

    @Override
    public int getNumberOfIncompleteOffsets() {
        return 0;
    }

    @Override
    public void onSuccess(long offset) {
        log.debug("Dropping completed work container for partition no longer assigned. WC: {}, partition: {}", (Object)offset, (Object)this.getTp());
    }

    @Override
    public boolean isPartitionRemovedOrNeverAssigned() {
        return true;
    }
}

