/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.state;

import io.confluent.parallelconsumer.ParallelConsumerOptions;
import io.confluent.parallelconsumer.state.WorkContainer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;

public class ShardKey {
    public static ShardKey of(WorkContainer<?, ?> wc, ParallelConsumerOptions.ProcessingOrder ordering) {
        return ShardKey.of(wc.getCr(), ordering);
    }

    public static ShardKey of(ConsumerRecord<?, ?> rec, ParallelConsumerOptions.ProcessingOrder ordering) {
        ShardKey shardKey;
        switch (ordering) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case KEY: {
                shardKey = ShardKey.ofKey(rec);
                break;
            }
            case PARTITION: 
            case UNORDERED: {
                shardKey = ShardKey.ofTopicPartition(rec);
            }
        }
        return shardKey;
    }

    public static KeyOrderedKey ofKey(ConsumerRecord<?, ?> rec) {
        return new KeyOrderedKey(rec);
    }

    public static ShardKey ofTopicPartition(ConsumerRecord<?, ?> rec) {
        return new TopicPartitionKey(new TopicPartition(rec.topic(), rec.partition()));
    }

    public String toString() {
        return "ShardKey()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardKey)) {
            return false;
        }
        ShardKey other = (ShardKey)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShardKey;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public static final class KeyOrderedKey
    extends ShardKey {
        private final TopicPartition topicName;
        private final Object key;

        public KeyOrderedKey(ConsumerRecord<?, ?> rec) {
            this(new TopicPartition(rec.topic(), rec.partition()), rec.key());
        }

        public TopicPartition getTopicName() {
            return this.topicName;
        }

        public Object getKey() {
            return this.key;
        }

        @Override
        public String toString() {
            return "ShardKey.KeyOrderedKey(topicName=" + this.getTopicName() + ", key=" + this.getKey() + ")";
        }

        public KeyOrderedKey(TopicPartition topicName, Object key) {
            this.topicName = topicName;
            this.key = key;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyOrderedKey)) {
                return false;
            }
            KeyOrderedKey other = (KeyOrderedKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TopicPartition this$topicName = this.getTopicName();
            TopicPartition other$topicName = other.getTopicName();
            if (this$topicName == null ? other$topicName != null : !this$topicName.equals(other$topicName)) {
                return false;
            }
            Object this$key = this.getKey();
            Object other$key = other.getKey();
            return !(this$key == null ? other$key != null : !this$key.equals(other$key));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof KeyOrderedKey;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            TopicPartition $topicName = this.getTopicName();
            result = result * 59 + ($topicName == null ? 43 : $topicName.hashCode());
            Object $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            return result;
        }
    }

    public static final class TopicPartitionKey
    extends ShardKey {
        private final TopicPartition topicPartition;

        public TopicPartitionKey(TopicPartition topicPartition) {
            this.topicPartition = topicPartition;
        }

        public TopicPartition getTopicPartition() {
            return this.topicPartition;
        }

        @Override
        public String toString() {
            return "ShardKey.TopicPartitionKey(topicPartition=" + this.getTopicPartition() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TopicPartitionKey)) {
                return false;
            }
            TopicPartitionKey other = (TopicPartitionKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TopicPartition this$topicPartition = this.getTopicPartition();
            TopicPartition other$topicPartition = other.getTopicPartition();
            return !(this$topicPartition == null ? other$topicPartition != null : !this$topicPartition.equals(other$topicPartition));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof TopicPartitionKey;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            TopicPartition $topicPartition = this.getTopicPartition();
            result = result * 59 + ($topicPartition == null ? 43 : $topicPartition.hashCode());
            return result;
        }
    }
}

