/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.internal;

import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicLoadFactor {
    private static final Logger log = LoggerFactory.getLogger(DynamicLoadFactor.class);
    private static final int DEFAULT_INITIAL_LOADING_FACTOR = 2;
    private final long startTimeMs = System.currentTimeMillis();
    private final Duration coolDown = Duration.ofSeconds(2L);
    private final Duration warmUp = Duration.ofSeconds(2L);
    private final int stepUpFactorBy = 1;
    private final int maxFactor = 100;
    private int currentFactor = 2;
    private long lastSteppedFactor = this.currentFactor;
    private Instant lastStepTime = Instant.MIN;

    public boolean maybeStepUp() {
        if (this.couldStep()) {
            return this.doStep();
        }
        return false;
    }

    private synchronized boolean doStep() {
        if (this.isMaxReached()) {
            return false;
        }
        ++this.currentFactor;
        long delta = (long)this.currentFactor - this.lastSteppedFactor;
        log.debug("Stepped up load factor by {} from {} to {}", new Object[]{delta, this.lastSteppedFactor, this.currentFactor});
        this.lastSteppedFactor = this.currentFactor;
        this.lastStepTime = Instant.now();
        return true;
    }

    boolean couldStep() {
        boolean warmUpPeriodOver = this.isWarmUpPeriodOver();
        boolean noCoolDown = this.isNotCoolingDown();
        return warmUpPeriodOver && noCoolDown;
    }

    private boolean isNotCoolingDown() {
        Instant now = Instant.now();
        Duration elapsed = Duration.between(this.lastStepTime, now);
        boolean coolDownElapsed = elapsed.compareTo(this.coolDown) > 0;
        return coolDownElapsed;
    }

    public boolean isWarmUpPeriodOver() {
        long now = System.currentTimeMillis();
        long elapsed = now - this.startTimeMs;
        return elapsed > this.warmUp.toMillis();
    }

    public boolean isMaxReached() {
        return this.currentFactor >= 100;
    }

    public int getMaxFactor() {
        return this.maxFactor;
    }

    public int getCurrentFactor() {
        return this.currentFactor;
    }
}

