/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.utils;

import io.confluent.csid.utils.BackportUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopingResumingIterator<KEY, VALUE>
implements Iterator<Map.Entry<KEY, VALUE>>,
Iterable<Map.Entry<KEY, VALUE>> {
    private static final Logger log = LoggerFactory.getLogger(LoopingResumingIterator.class);
    private Iterator<Map.Entry<KEY, VALUE>> iterator;
    private final Optional<KEY> iterationStartingPoint;
    private final Map<KEY, VALUE> map;
    private boolean hasLoopedAroundBackToBeginning = false;
    private Optional<Integer> startingPointIndex = Optional.empty();
    private int indexOfNextElementToRetrieve = 0;

    public static <KKEY, VVALUE> LoopingResumingIterator<KKEY, VVALUE> build(KKEY startingKey, Map<KKEY, VVALUE> map) {
        return new LoopingResumingIterator<KKEY, VVALUE>(Optional.ofNullable(startingKey), map);
    }

    public LoopingResumingIterator(Optional<KEY> startingKey, Map<KEY, VALUE> map) {
        this.iterationStartingPoint = startingKey;
        this.map = map;
        Set<Map.Entry<KEY, VALUE>> entries = map.entrySet();
        this.iterator = entries.iterator();
    }

    public LoopingResumingIterator(Map<KEY, VALUE> map) {
        this(Optional.empty(), map);
    }

    @Override
    public boolean hasNext() {
        boolean atEndOfFirstIteration;
        if (BackportUtils.isEmpty(this.iterationStartingPoint)) {
            return this.iterator.hasNext();
        }
        if (this.hasLoopedAroundBackToBeginning) {
            boolean endOfIterationReached = this.startingPointIndex.orElse(-1) == this.indexOfNextElementToRetrieve;
            return !endOfIterationReached;
        }
        boolean bl = atEndOfFirstIteration = !this.iterator.hasNext();
        if (atEndOfFirstIteration) {
            boolean startingPointIsntZero;
            boolean bl2 = startingPointIsntZero = this.isStartingPointIndexFound() && this.startingPointIndex.get() != 0;
            if (startingPointIsntZero) {
                this.hasLoopedAroundBackToBeginning = true;
                this.resetIterator();
                return this.iterator.hasNext();
            }
            return false;
        }
        return true;
    }

    @Override
    public Map.Entry<KEY, VALUE> next() {
        if (this.iterationStartingPoint.isPresent()) {
            return this.findStartingPointAndNextValue(this.iterationStartingPoint.get());
        }
        return this.getNext();
    }

    private Map.Entry<KEY, VALUE> findStartingPointAndNextValue(Object startingPointObject) {
        if (this.isStartingPointIndexFound()) {
            return this.getNextAndMaybeLoop(startingPointObject);
        }
        return this.attemptToFindStart(startingPointObject);
    }

    private boolean isStartingPointIndexFound() {
        return this.startingPointIndex.isPresent();
    }

    private Map.Entry<KEY, VALUE> attemptToFindStart(Object startingPointObject) {
        Optional<Map.Entry<KEY, VALUE>> startingPoint = this.findStartingPointMaybe(startingPointObject);
        if (startingPoint.isPresent()) {
            return startingPoint.get();
        }
        this.startingPointIndex = Optional.of(0);
        this.resetIterator();
        return this.getNext();
    }

    private Optional<Map.Entry<KEY, VALUE>> findStartingPointMaybe(Object startingPointObject) {
        while (this.iterator.hasNext()) {
            Map.Entry<KEY, VALUE> next = this.getNext();
            if (next.getKey() != startingPointObject) continue;
            int value = this.indexOfNextElementToRetrieve - 1;
            if (value < 0) {
                value = this.map.size() - 1;
            }
            this.startingPointIndex = Optional.of(value);
            return Optional.of(next);
        }
        return Optional.empty();
    }

    private Map.Entry<KEY, VALUE> getNextAndMaybeLoop(Object startingPointObject) {
        Map.Entry<KEY, VALUE> toReturn;
        if (this.hasLoopedAroundBackToBeginning) {
            toReturn = this.getNext();
            if (toReturn.getKey() == startingPointObject) {
                throw new NoSuchElementException("#hasNext() returned true, but there are no more entries that haven't been iterated.");
            }
        } else if (this.iterator.hasNext()) {
            toReturn = this.getNext();
        } else {
            this.hasLoopedAroundBackToBeginning = true;
            this.resetIterator();
            toReturn = this.getNext();
        }
        return toReturn;
    }

    private void resetIterator() {
        this.indexOfNextElementToRetrieve = 0;
        this.iterator = this.map.entrySet().iterator();
    }

    private Map.Entry<KEY, VALUE> getNext() {
        this.indexOfNextElementToRetrieve = this.indexOfNextElementToRetrieve == this.map.size() - 1 ? 0 : ++this.indexOfNextElementToRetrieve;
        return this.iterator.next();
    }

    @Override
    public Iterator<Map.Entry<KEY, VALUE>> iterator() {
        return this;
    }

    public Optional<KEY> getIterationStartingPoint() {
        return this.iterationStartingPoint;
    }
}

