/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.offsets;

import io.confluent.csid.utils.Range;
import io.confluent.parallelconsumer.internal.InternalRuntimeError;
import io.confluent.parallelconsumer.offsets.OffsetEncoding;
import io.confluent.parallelconsumer.offsets.OffsetMapCodecManager;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetBitSet {
    private static final Logger log = LoggerFactory.getLogger(OffsetBitSet.class);

    static String deserialiseBitSetWrap(ByteBuffer wrap, OffsetEncoding.Version version) {
        int n;
        wrap.rewind();
        switch (version) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case v1: {
                n = wrap.getShort();
                break;
            }
            case v2: {
                n = wrap.getInt();
            }
        }
        int originalBitsetSize = n;
        ByteBuffer slice = wrap.slice();
        return OffsetBitSet.deserialiseBitSet(originalBitsetSize, slice);
    }

    static String deserialiseBitSet(int originalBitsetSize, ByteBuffer s) {
        BitSet bitSet = BitSet.valueOf(s);
        StringBuilder result = new StringBuilder(bitSet.size());
        for (Integer offset : Range.range(originalBitsetSize)) {
            if (bitSet.get(offset)) {
                result.append('x');
                continue;
            }
            result.append('o');
        }
        return result.toString();
    }

    static OffsetMapCodecManager.HighestOffsetAndIncompletes deserialiseBitSetWrapToIncompletes(OffsetEncoding encoding, long baseOffset, ByteBuffer wrap) {
        int n;
        wrap.rewind();
        switch (encoding) {
            case BitSet: {
                n = wrap.getShort();
                break;
            }
            case BitSetV2: {
                n = wrap.getInt();
                break;
            }
            default: {
                throw new InternalRuntimeError("Invalid state");
            }
        }
        int originalBitsetSize = n;
        ByteBuffer slice = wrap.slice();
        Set<Long> incompletes = OffsetBitSet.deserialiseBitSetToIncompletes(baseOffset, originalBitsetSize, slice);
        long highestSeenOffset = baseOffset + (long)originalBitsetSize - 1L;
        return OffsetMapCodecManager.HighestOffsetAndIncompletes.of(highestSeenOffset, incompletes);
    }

    static Set<Long> deserialiseBitSetToIncompletes(long baseOffset, int originalBitsetSize, ByteBuffer inputBuffer) {
        BitSet bitSet = BitSet.valueOf(inputBuffer);
        int numberOfIncompletes = originalBitsetSize - bitSet.cardinality();
        HashSet<Long> incompletes = new HashSet<Long>(numberOfIncompletes);
        for (Integer relativeOffset : Range.range(originalBitsetSize)) {
            long offset = baseOffset + (long)relativeOffset.intValue();
            if (bitSet.get(relativeOffset)) {
                log.trace("Ignoring completed offset {}", (Object)relativeOffset);
                continue;
            }
            incompletes.add(offset);
        }
        return incompletes;
    }
}

