/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.offsets;

import io.confluent.csid.utils.Range;
import io.confluent.csid.utils.StringUtils;
import io.confluent.parallelconsumer.offsets.EncodingNotSupportedException;
import io.confluent.parallelconsumer.offsets.OffsetEncoder;
import io.confluent.parallelconsumer.offsets.OffsetEncoding;
import io.confluent.parallelconsumer.offsets.OffsetSimultaneousEncoder;
import io.confluent.parallelconsumer.offsets.RunlengthV1EncodingNotSupported;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

class RunLengthEncoder
extends OffsetEncoder {
    private int currentRunLengthCount = 0;
    private boolean previousRunLengthState = false;
    private final List<Integer> runLengthEncodingIntegers;
    private Optional<byte[]> encodedBytes = Optional.empty();
    private final OffsetEncoding.Version version;
    private static final OffsetEncoding.Version DEFAULT_VERSION = OffsetEncoding.Version.v2;
    int previousRangeIndex = -1;

    public RunLengthEncoder(OffsetSimultaneousEncoder offsetSimultaneousEncoder, OffsetEncoding.Version newVersion) {
        super(offsetSimultaneousEncoder);
        this.runLengthEncodingIntegers = new ArrayList<Integer>();
        this.version = newVersion;
    }

    @Override
    protected OffsetEncoding getEncodingType() {
        OffsetEncoding offsetEncoding;
        switch (this.version) {
            case v1: {
                offsetEncoding = OffsetEncoding.RunLength;
                break;
            }
            case v2: {
                offsetEncoding = OffsetEncoding.RunLengthV2;
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        return offsetEncoding;
    }

    @Override
    protected OffsetEncoding getEncodingTypeCompressed() {
        OffsetEncoding offsetEncoding;
        switch (this.version) {
            case v1: {
                offsetEncoding = OffsetEncoding.RunLengthCompressed;
                break;
            }
            case v2: {
                offsetEncoding = OffsetEncoding.RunLengthV2Compressed;
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        return offsetEncoding;
    }

    @Override
    public void encodeIncompleteOffset(int rangeIndex) {
        this.encodeRunLength(false, rangeIndex);
    }

    @Override
    public void encodeCompletedOffset(int rangeIndex) {
        this.encodeRunLength(true, rangeIndex);
    }

    @Override
    public byte[] serialise() throws EncodingNotSupportedException {
        int n;
        this.addTail();
        switch (this.version) {
            case v1: {
                n = 2;
                break;
            }
            case v2: {
                n = 4;
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        int entryWidth = n;
        ByteBuffer runLengthEncodedByteBuffer = ByteBuffer.allocate(this.runLengthEncodingIntegers.size() * entryWidth);
        for (Integer runLength : this.runLengthEncodingIntegers) {
            switch (this.version) {
                case v1: {
                    short shortCastRunlength = runLength.shortValue();
                    if (runLength != shortCastRunlength) {
                        throw new RunlengthV1EncodingNotSupported(StringUtils.msg("Runlength too long for Short ({} cast to {})", runLength, shortCastRunlength));
                    }
                    runLengthEncodedByteBuffer.putShort(shortCastRunlength);
                    break;
                }
                case v2: {
                    runLengthEncodedByteBuffer.putInt(runLength);
                }
            }
        }
        byte[] array = runLengthEncodedByteBuffer.array();
        this.encodedBytes = Optional.of(array);
        return array;
    }

    void addTail() {
        this.runLengthEncodingIntegers.add(this.currentRunLengthCount);
    }

    @Override
    public int getEncodedSize() {
        return this.encodedBytes.get().length;
    }

    @Override
    protected byte[] getEncodedBytes() {
        return this.encodedBytes.get();
    }

    private void encodeRunLength(boolean currentIsComplete, int rangeIndex) {
        boolean currentOffsetMatchesOurRunLengthState;
        boolean bl = currentOffsetMatchesOurRunLengthState = this.previousRunLengthState == currentIsComplete;
        if (currentOffsetMatchesOurRunLengthState) {
            int delta = rangeIndex - this.previousRangeIndex;
            this.currentRunLengthCount += delta;
        } else {
            this.previousRunLengthState = currentIsComplete;
            this.runLengthEncodingIntegers.add(this.currentRunLengthCount);
            this.currentRunLengthCount = 1;
        }
        this.previousRangeIndex = rangeIndex;
    }

    public List<Long> calculateSucceededActualOffsets(long originalBaseOffset) {
        ArrayList<Long> successfulOffsets = new ArrayList<Long>();
        boolean succeeded = false;
        long offsetPosition = originalBaseOffset;
        for (int run : this.runLengthEncodingIntegers) {
            if (succeeded) {
                for (Integer integer : Range.range(run)) {
                    long newGoodOffset = offsetPosition + (long)integer.intValue();
                    successfulOffsets.add(newGoodOffset);
                }
            }
            offsetPosition += (long)run;
            succeeded = !succeeded;
        }
        return successfulOffsets;
    }

    public List<Integer> getRunLengthEncodingIntegers() {
        return this.runLengthEncodingIntegers;
    }
}

