/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.internal;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.kafka.clients.consumer.ConsumerRecords;

public class CountingCRLinkedList<K, V>
extends LinkedList<ConsumerRecords<K, V>>
implements Queue<ConsumerRecords<K, V>> {
    private int nestedCount = 0;

    @Override
    public void add(int index, ConsumerRecords<K, V> element) {
        this.nestedCount += element.count();
        super.add(index, element);
    }

    @Override
    public boolean add(ConsumerRecords<K, V> element) {
        this.nestedCount += element.count();
        return super.add(element);
    }

    @Override
    public ConsumerRecords<K, V> poll() {
        ConsumerRecords poll = (ConsumerRecords)super.poll();
        if (poll != null) {
            int numberOfNestedMessages = poll.count();
            this.nestedCount -= numberOfNestedMessages;
        }
        return poll;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CountingCRLinkedList)) {
            return false;
        }
        CountingCRLinkedList other = (CountingCRLinkedList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getNestedCount() == other.getNestedCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CountingCRLinkedList;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getNestedCount();
        return result;
    }

    public int getNestedCount() {
        return this.nestedCount;
    }
}

