/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.stream.IntStream;

public class Range
implements Iterable<Integer> {
    private long limit;

    public Range(long limit) {
        this.limit = limit;
    }

    public static Range range(long max) {
        return new Range(max);
    }

    @Override
    public Iterator<Integer> iterator() {
        final long max = this.limit;
        return new Iterator<Integer>(){
            private int current = 0;

            @Override
            public boolean hasNext() {
                return (long)this.current < max;
            }

            @Override
            public Integer next() {
                if (this.hasNext()) {
                    return this.current++;
                }
                throw new NoSuchElementException("Range reached the end");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove values from a Range");
            }
        };
    }

    public List<Integer> list() {
        ArrayList<Integer> integers = new ArrayList<Integer>();
        this.forEach(integers::add);
        return integers;
    }

    public IntStream toStream() {
        return IntStream.range(0, (int)this.limit);
    }

    static IntStream rangeStream(int i) {
        return IntStream.range(0, i);
    }

    static void range(int max, Consumer<Integer> consumer) {
        IntStream.range(0, max).forEach(consumer::accept);
    }
}

