/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import java.time.Duration;

public class RateLimiter {
    private Duration rate = Duration.ofSeconds(1L);
    private long lastFireMs = 0L;

    public RateLimiter() {
    }

    public RateLimiter(int seconds) {
        this.rate = Duration.ofSeconds(seconds);
    }

    public void performIfNotLimited(Runnable action) {
        if (this.isOkToCallAction()) {
            this.lastFireMs = System.currentTimeMillis();
            action.run();
        }
    }

    public boolean couldPerform() {
        return this.isOkToCallAction();
    }

    private boolean isOkToCallAction() {
        long elapsed = this.getElapsedMs();
        return this.lastFireMs == 0L || elapsed > this.rate.toMillis();
    }

    private long getElapsedMs() {
        long now = System.currentTimeMillis();
        long elapsed = now - this.lastFireMs;
        return elapsed;
    }

    public Duration getElapsedDuration() {
        return Duration.ofMillis(this.getElapsedMs());
    }

    public Duration getRate() {
        return this.rate;
    }
}

