/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import io.confluent.parallelconsumer.EncodedOffsetPair;
import io.confluent.parallelconsumer.EncodingNotSupportedException;
import io.confluent.parallelconsumer.OffsetEncoding;
import io.confluent.parallelconsumer.OffsetSimpleSerialisation;
import io.confluent.parallelconsumer.OffsetSimultaneousEncoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class OffsetEncoder {
    private static final Logger log = LoggerFactory.getLogger(OffsetEncoder.class);
    private final OffsetSimultaneousEncoder offsetSimultaneousEncoder;

    public OffsetEncoder(OffsetSimultaneousEncoder offsetSimultaneousEncoder) {
        this.offsetSimultaneousEncoder = offsetSimultaneousEncoder;
    }

    protected abstract OffsetEncoding getEncodingType();

    protected abstract OffsetEncoding getEncodingTypeCompressed();

    abstract void encodeIncompleteOffset(int var1);

    abstract void encodeCompletedOffset(int var1);

    abstract byte[] serialise() throws EncodingNotSupportedException;

    abstract int getEncodedSize();

    boolean quiteSmall() {
        return this.getEncodedSize() < 200;
    }

    byte[] compress() throws IOException {
        return OffsetSimpleSerialisation.compressZstd(this.getEncodedBytes());
    }

    void register() throws EncodingNotSupportedException {
        byte[] bytes = this.serialise();
        OffsetEncoding encodingType = this.getEncodingType();
        this.register(encodingType, bytes);
    }

    private void register(OffsetEncoding type, byte[] bytes) {
        log.debug("Registering {}, with site {}", (Object)type, (Object)bytes.length);
        this.offsetSimultaneousEncoder.sortedEncodings.add(new EncodedOffsetPair(type, ByteBuffer.wrap(bytes)));
        this.offsetSimultaneousEncoder.encodingMap.put(type, bytes);
    }

    void registerCompressed() {
        byte[] compressed = this.compress();
        OffsetEncoding encodingType = this.getEncodingTypeCompressed();
        this.register(encodingType, compressed);
    }

    protected abstract byte[] getEncodedBytes();
}

