/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicLoadFactor {
    private static final Logger log = LoggerFactory.getLogger(DynamicLoadFactor.class);
    private static final int DEFAULT_INITIAL_LOADING_FACTOR = 2;
    private final long startTimeMs = System.currentTimeMillis();
    private final Duration coolDown = Duration.ofSeconds(1L);
    private final Duration warmUp = Duration.ofSeconds(0L);
    private final int stepUpFactorBy = 2;
    private final int maxFactor = 100;
    private int currentFactor = 2;
    private long lastSteppedFactor = this.currentFactor;

    public boolean maybeStepUp() {
        long nowMs = System.currentTimeMillis();
        if (this.couldStep()) {
            return this.doStep(nowMs, this.lastSteppedFactor);
        }
        return false;
    }

    private synchronized boolean doStep(long nowMs, long myLastStep) {
        if (this.currentFactor < 100) {
            if (myLastStep == this.lastSteppedFactor) {
                this.currentFactor += 2;
                long delta = (long)this.currentFactor - myLastStep;
                log.debug("Stepped up load factor by {} from {} to {}", new Object[]{delta, myLastStep, this.currentFactor});
                this.lastSteppedFactor = this.currentFactor;
                return true;
            }
            return false;
        }
        return false;
    }

    boolean couldStep() {
        return this.isWarmUpPeriodOver() && this.isNoCoolDown();
    }

    private boolean isNoCoolDown() {
        if (this.lastSteppedFactor == 0L) {
            return true;
        }
        long now = System.currentTimeMillis();
        long elapsed = now - this.lastSteppedFactor;
        return elapsed > this.coolDown.toMillis();
    }

    boolean isWarmUpPeriodOver() {
        long now = System.currentTimeMillis();
        long elapsed = now - this.startTimeMs;
        return elapsed > this.warmUp.toMillis();
    }

    public boolean isMaxReached() {
        return this.currentFactor >= 100;
    }

    public int getMaxFactor() {
        return this.maxFactor;
    }

    public int getCurrentFactor() {
        return this.currentFactor;
    }
}

