/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import io.confluent.csid.utils.StringUtils;
import io.confluent.parallelconsumer.EncodingNotSupportedException;
import io.confluent.parallelconsumer.OffsetEncoder;
import io.confluent.parallelconsumer.OffsetEncoding;
import io.confluent.parallelconsumer.OffsetSimultaneousEncoder;
import io.confluent.parallelconsumer.RunlengthV1EncodingNotSupported;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

class RunLengthEncoder
extends OffsetEncoder {
    private final AtomicInteger currentRunLengthCount;
    private final AtomicBoolean previousRunLengthState;
    private final List<Integer> runLengthEncodingIntegers;
    private Optional<byte[]> encodedBytes = Optional.empty();

    public RunLengthEncoder(OffsetSimultaneousEncoder offsetSimultaneousEncoder) {
        super(offsetSimultaneousEncoder);
        this.currentRunLengthCount = new AtomicInteger();
        this.previousRunLengthState = new AtomicBoolean(false);
        this.runLengthEncodingIntegers = new ArrayList<Integer>();
    }

    @Override
    protected OffsetEncoding getEncodingType() {
        return OffsetEncoding.RunLength;
    }

    @Override
    protected OffsetEncoding getEncodingTypeCompressed() {
        return OffsetEncoding.RunLengthCompressed;
    }

    @Override
    public void encodeIncompleteOffset(int rangeIndex) {
        this.encodeRunLength(false);
    }

    @Override
    public void encodeCompletedOffset(int rangeIndex) {
        this.encodeRunLength(true);
    }

    @Override
    public byte[] serialise() throws EncodingNotSupportedException {
        this.runLengthEncodingIntegers.add(this.currentRunLengthCount.get());
        ByteBuffer runLengthEncodedByteBuffer = ByteBuffer.allocate(this.runLengthEncodingIntegers.size() * 2);
        for (Integer runlength : this.runLengthEncodingIntegers) {
            short shortCastRunlength = runlength.shortValue();
            if (runlength != shortCastRunlength) {
                throw new RunlengthV1EncodingNotSupported(StringUtils.msg("Runlength too long for Short ({} cast to {})", runlength, shortCastRunlength));
            }
            runLengthEncodedByteBuffer.putShort(shortCastRunlength);
        }
        byte[] array = runLengthEncodedByteBuffer.array();
        this.encodedBytes = Optional.of(array);
        return array;
    }

    @Override
    public int getEncodedSize() {
        return this.encodedBytes.get().length;
    }

    @Override
    protected byte[] getEncodedBytes() {
        return this.encodedBytes.get();
    }

    private void encodeRunLength(boolean currentIsComplete) {
        boolean currentOffsetMatchesOurRunLengthState;
        boolean bl = currentOffsetMatchesOurRunLengthState = this.previousRunLengthState.get() == currentIsComplete;
        if (currentOffsetMatchesOurRunLengthState) {
            this.currentRunLengthCount.getAndIncrement();
        } else {
            this.previousRunLengthState.set(currentIsComplete);
            this.runLengthEncodingIntegers.add(this.currentRunLengthCount.get());
            this.currentRunLengthCount.set(1);
        }
    }
}

