/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import io.confluent.csid.utils.Range;
import io.confluent.parallelconsumer.BitSetEncodingNotSupportedException;
import io.confluent.parallelconsumer.BitsetEncoder;
import io.confluent.parallelconsumer.ByteBufferEncoder;
import io.confluent.parallelconsumer.EncodedOffsetPair;
import io.confluent.parallelconsumer.EncodingNotSupportedException;
import io.confluent.parallelconsumer.OffsetEncoder;
import io.confluent.parallelconsumer.OffsetEncoding;
import io.confluent.parallelconsumer.RunLengthEncoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OffsetSimultaneousEncoder {
    private static final Logger log = LoggerFactory.getLogger(OffsetSimultaneousEncoder.class);
    public static final int LARGE_INPUT_MAP_SIZE_THRESHOLD = 200;
    private final Set<Long> incompleteOffsets;
    private final long lowWaterMark;
    private final long nextExpectedOffset;
    private final int length;
    Map<OffsetEncoding, byte[]> encodingMap = new EnumMap<OffsetEncoding, byte[]>(OffsetEncoding.class);
    TreeSet<EncodedOffsetPair> sortedEncodings = new TreeSet();
    static boolean compressionForced = false;
    private final Set<OffsetEncoder> encoders = new HashSet<OffsetEncoder>();

    public OffsetSimultaneousEncoder(long lowWaterMark, Long nextExpectedOffset, Set<Long> incompleteOffsets) {
        this.lowWaterMark = lowWaterMark;
        this.nextExpectedOffset = nextExpectedOffset;
        this.incompleteOffsets = incompleteOffsets;
        this.length = (int)(this.nextExpectedOffset - this.lowWaterMark);
        this.initEncoders();
    }

    private void initEncoders() {
        if (this.length > 200) {
            log.debug("~Large input map size: {} (start: {} end: {})", new Object[]{this.length, this.lowWaterMark, this.nextExpectedOffset});
        }
        try {
            BitsetEncoder bitsetEncoder = new BitsetEncoder(this.length, this);
            this.encoders.add(bitsetEncoder);
        }
        catch (BitSetEncodingNotSupportedException a) {
            log.warn("Cannot use {} encoder", (Object)BitsetEncoder.class.getSimpleName(), (Object)a);
        }
        this.encoders.add(new RunLengthEncoder(this));
    }

    void addByteBufferEncoder() {
        this.encoders.add(new ByteBufferEncoder(this.length, this));
    }

    public OffsetSimultaneousEncoder invoke() {
        log.debug("Starting encode of incompletes, base offset is: {}, end offset is: {}", (Object)this.lowWaterMark, (Object)this.nextExpectedOffset);
        log.trace("Incompletes are: {}", this.incompleteOffsets);
        log.debug("Encode loop offset start,end: [{},{}] length: {}", new Object[]{this.lowWaterMark, this.nextExpectedOffset, this.length});
        Range.range(this.length).forEach(rangeIndex -> {
            long offset = this.lowWaterMark + (long)rangeIndex.intValue();
            ArrayList removeToBeRemoved = new ArrayList();
            if (this.incompleteOffsets.contains(offset)) {
                log.trace("Found an incomplete offset {}", (Object)offset);
                this.encoders.forEach(x -> x.encodeIncompleteOffset((int)rangeIndex));
            } else {
                this.encoders.forEach(x -> x.encodeCompletedOffset((int)rangeIndex));
            }
            this.encoders.removeAll(removeToBeRemoved);
        });
        this.registerEncodings(this.encoders);
        log.debug("In order: {}", this.sortedEncodings);
        return this;
    }

    private void registerEncodings(Set<? extends OffsetEncoder> encoders) {
        ArrayList<OffsetEncoder> toRemove = new ArrayList<OffsetEncoder>();
        for (OffsetEncoder offsetEncoder : encoders) {
            try {
                offsetEncoder.register();
            }
            catch (EncodingNotSupportedException e) {
                log.warn("Removing {} encoder, not supported", (Object)offsetEncoder.getEncodingType().name(), (Object)e);
                toRemove.add(offsetEncoder);
            }
        }
        encoders.removeAll(toRemove);
        boolean noEncodingsAreSmallEnough = encoders.stream().noneMatch(OffsetEncoder::quiteSmall);
        if (noEncodingsAreSmallEnough || compressionForced) {
            encoders.forEach(OffsetEncoder::registerCompressed);
        }
    }

    public byte[] packSmallest() throws EncodingNotSupportedException {
        if (this.sortedEncodings.isEmpty()) {
            throw new EncodingNotSupportedException("No encodings could be used");
        }
        EncodedOffsetPair best = this.sortedEncodings.first();
        log.debug("Compression chosen is: {}", (Object)best.encoding.name());
        return this.packEncoding(best);
    }

    byte[] packEncoding(EncodedOffsetPair best) {
        boolean magicByteSize = true;
        ByteBuffer result = ByteBuffer.allocate(1 + best.data.capacity());
        result.put(best.encoding.magicByte);
        result.put(best.data);
        return result.array();
    }

    public Set<Long> getIncompleteOffsets() {
        return this.incompleteOffsets;
    }

    public Map<OffsetEncoding, byte[]> getEncodingMap() {
        return this.encodingMap;
    }

    public TreeSet<EncodedOffsetPair> getSortedEncodings() {
        return this.sortedEncodings;
    }
}

