/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import io.confluent.csid.utils.StringUtils;
import io.confluent.parallelconsumer.BitSetEncodingNotSupportedException;
import io.confluent.parallelconsumer.OffsetEncoder;
import io.confluent.parallelconsumer.OffsetEncoding;
import io.confluent.parallelconsumer.OffsetSimultaneousEncoder;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Optional;

class BitsetEncoder
extends OffsetEncoder {
    public static final Short MAX_LENGTH_ENCODABLE = Short.MAX_VALUE;
    private final ByteBuffer wrappedBitsetBytesBuffer;
    private final BitSet bitSet;
    private Optional<byte[]> encodedBytes = Optional.empty();

    public BitsetEncoder(int length, OffsetSimultaneousEncoder offsetSimultaneousEncoder) throws BitSetEncodingNotSupportedException {
        super(offsetSimultaneousEncoder);
        if (length > MAX_LENGTH_ENCODABLE) {
            throw new BitSetEncodingNotSupportedException(StringUtils.msg("Bitset too long to encode, as length overflows Short.MAX_VALUE. Length: {}. (max: {})", length, (short)Short.MAX_VALUE));
        }
        this.wrappedBitsetBytesBuffer = ByteBuffer.allocate(2 + (length / 8 + 1));
        this.wrappedBitsetBytesBuffer.putShort((short)length);
        this.bitSet = new BitSet(length);
    }

    @Override
    protected OffsetEncoding getEncodingType() {
        return OffsetEncoding.BitSet;
    }

    @Override
    protected OffsetEncoding getEncodingTypeCompressed() {
        return OffsetEncoding.BitSetCompressed;
    }

    @Override
    public void encodeIncompleteOffset(int index) {
    }

    @Override
    public void encodeCompletedOffset(int index) {
        this.bitSet.set(index);
    }

    @Override
    public byte[] serialise() {
        byte[] bitSetArray = this.bitSet.toByteArray();
        this.wrappedBitsetBytesBuffer.put(bitSetArray);
        byte[] array = this.wrappedBitsetBytesBuffer.array();
        this.encodedBytes = Optional.of(array);
        return array;
    }

    @Override
    public int getEncodedSize() {
        return this.encodedBytes.get().length;
    }

    @Override
    protected byte[] getEncodedBytes() {
        return this.encodedBytes.get();
    }
}

