/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import io.confluent.csid.utils.Range;
import io.confluent.parallelconsumer.ParallelConsumer;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetBitSet {
    private static final Logger log = LoggerFactory.getLogger(OffsetBitSet.class);

    static String deserialiseBitSetWrap(ByteBuffer wrap) {
        wrap.rewind();
        short originalBitsetSize = wrap.getShort();
        ByteBuffer slice = wrap.slice();
        return OffsetBitSet.deserialiseBitSet(originalBitsetSize, slice);
    }

    static String deserialiseBitSet(int originalBitsetSize, ByteBuffer s) {
        BitSet bitSet = BitSet.valueOf(s);
        StringBuilder result = new StringBuilder(bitSet.size());
        for (Integer offset : Range.range(originalBitsetSize)) {
            if (bitSet.get(offset)) {
                result.append('x');
                continue;
            }
            result.append('o');
        }
        return result.toString();
    }

    static ParallelConsumer.Tuple<Long, Set<Long>> deserialiseBitSetWrapToIncompletes(long baseOffset, ByteBuffer wrap) {
        wrap.rewind();
        short originalBitsetSize = wrap.getShort();
        ByteBuffer slice = wrap.slice();
        Set<Long> incompletes = OffsetBitSet.deserialiseBitSetToIncompletes(baseOffset, originalBitsetSize, slice);
        long highwaterMark = baseOffset + (long)originalBitsetSize;
        return ParallelConsumer.Tuple.pairOf(highwaterMark, incompletes);
    }

    static Set<Long> deserialiseBitSetToIncompletes(long baseOffset, int originalBitsetSize, ByteBuffer inputBuffer) {
        BitSet bitSet = BitSet.valueOf(inputBuffer);
        HashSet<Long> incompletes = new HashSet<Long>(1);
        for (Integer relativeOffset : Range.range(originalBitsetSize)) {
            long offset = baseOffset + (long)relativeOffset.intValue();
            if (bitSet.get(relativeOffset)) {
                log.trace("Ignoring completed offset");
                continue;
            }
            incompletes.add(offset);
        }
        return incompletes;
    }
}

