/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import io.confluent.parallelconsumer.ParallelConsumer;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OffsetRunLength {
    private static final Logger log = LoggerFactory.getLogger(OffsetRunLength.class);

    static List<Integer> runLengthEncode(String in) {
        AtomicInteger length = new AtomicInteger();
        AtomicBoolean previous = new AtomicBoolean(false);
        ArrayList<Integer> encoding = new ArrayList<Integer>();
        in.chars().forEachOrdered(bit -> {
            boolean bl;
            switch (bit) {
                case 111: {
                    bl = false;
                    break;
                }
                case 120: {
                    bl = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(bit + " in " + in);
                }
            }
            boolean current = bl;
            if (previous.get() == current) {
                length.getAndIncrement();
            } else {
                previous.set(current);
                encoding.add(length.get());
                length.set(1);
            }
        });
        encoding.add(length.get());
        return encoding;
    }

    static String runLengthDecodeToString(List<Integer> in) {
        StringBuilder sb = new StringBuilder(in.size());
        boolean current = false;
        for (Integer i : in) {
            for (int x = 0; x < i; ++x) {
                if (current) {
                    sb.append('x');
                    continue;
                }
                sb.append('o');
            }
            current = !current;
        }
        return sb.toString();
    }

    static ParallelConsumer.Tuple<Long, Set<Long>> runLengthDecodeToIncompletes(long baseOffset, ByteBuffer in) {
        in.rewind();
        ShortBuffer shortBuffer = in.asShortBuffer();
        HashSet<Long> incompletes = new HashSet<Long>(1);
        long highestWatermarkSeen = 0L;
        if (log.isTraceEnabled()) {
            ArrayList<Short> shorts = new ArrayList<Short>();
            while (shortBuffer.hasRemaining()) {
                shorts.add(shortBuffer.get());
            }
            log.debug("Unrolled shorts: {}", shorts);
            shortBuffer.rewind();
        }
        boolean currentRunlengthIsComplete = false;
        long currentOffset = baseOffset;
        while (shortBuffer.hasRemaining()) {
            int runLength = shortBuffer.get();
            highestWatermarkSeen = currentOffset + (long)runLength;
            if (currentRunlengthIsComplete) {
                log.trace("Ignoring {} completed offset", (Object)((short)runLength));
                currentOffset += (long)runLength;
            } else {
                log.trace("Adding {} incomplete offset", (Object)((short)runLength));
                for (int relativeOffset = 0; relativeOffset < runLength; ++relativeOffset) {
                    incompletes.add(currentOffset);
                    ++currentOffset;
                }
            }
            currentRunlengthIsComplete = !currentRunlengthIsComplete;
        }
        return ParallelConsumer.Tuple.pairOf(highestWatermarkSeen, incompletes);
    }

    static List<Integer> runLengthDeserialise(ByteBuffer in) {
        in.rewind();
        ShortBuffer shortBuffer = in.asShortBuffer();
        ArrayList<Integer> results = new ArrayList<Integer>(shortBuffer.capacity());
        while (shortBuffer.hasRemaining()) {
            results.add(Integer.valueOf(shortBuffer.get()));
        }
        return results;
    }

    private OffsetRunLength() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

