/*
 * Decompiled with CFR 0.152.
 */
package coil3.gif;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Movie;
import android.graphics.Paint;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import coil3.decode.DecodeUtils;
import coil3.gif.AnimatedTransformation;
import coil3.gif.PixelOpacity;
import coil3.size.Scale;
import coil3.util.BitmapsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 J2\u00020\u00012\u00020\u0002:\u0001JB%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0018H\u0016J\b\u00102\u001a\u00020!H\u0002J\u0010\u00103\u001a\u0002002\u0006\u00101\u001a\u00020\u0018H\u0002J\u000e\u00104\u001a\u0002002\u0006\u0010%\u001a\u00020&J\u0006\u00105\u001a\u00020&J\u0010\u00106\u001a\u0002002\b\u0010(\u001a\u0004\u0018\u00010)J\b\u00107\u001a\u0004\u0018\u00010)J\u0010\u00108\u001a\u0002002\u0006\u00109\u001a\u00020&H\u0016J\b\u0010:\u001a\u00020&H\u0017J\u0012\u0010;\u001a\u0002002\b\u0010<\u001a\u0004\u0018\u00010=H\u0016J\u0010\u0010>\u001a\u0002002\u0006\u0010?\u001a\u00020\u0015H\u0002J\b\u0010@\u001a\u00020&H\u0016J\b\u0010A\u001a\u00020&H\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010B\u001a\u000200H\u0016J\b\u0010C\u001a\u000200H\u0016J\u0010\u0010D\u001a\u0002002\u0006\u0010E\u001a\u00020\u0013H\u0016J\u0010\u0010F\u001a\u00020!2\u0006\u0010E\u001a\u00020\u0013H\u0016J\b\u0010G\u001a\u000200H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010?\u001a\u00020\u0015*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010I\u00a8\u0006K"}, d2={"Lcoil3/gif/MovieDrawable;", "Landroid/graphics/drawable/Drawable;", "Landroidx/vectordrawable/graphics/drawable/Animatable2Compat;", "movie", "Landroid/graphics/Movie;", "config", "Landroid/graphics/Bitmap$Config;", "scale", "Lcoil3/size/Scale;", "<init>", "(Landroid/graphics/Movie;Landroid/graphics/Bitmap$Config;Lcoil3/size/Scale;)V", "getConfig", "()Landroid/graphics/Bitmap$Config;", "getScale", "()Lcoil3/size/Scale;", "paint", "Landroid/graphics/Paint;", "callbacks", "", "Landroidx/vectordrawable/graphics/drawable/Animatable2Compat$AnimationCallback;", "currentBounds", "Landroid/graphics/Rect;", "tempCanvasBounds", "softwareCanvas", "Landroid/graphics/Canvas;", "softwareBitmap", "Landroid/graphics/Bitmap;", "softwareScale", "", "hardwareScale", "hardwareDx", "hardwareDy", "isRunning", "", "startTimeMillis", "", "frameTimeMillis", "repeatCount", "", "loopIteration", "animatedTransformation", "Lcoil3/gif/AnimatedTransformation;", "animatedTransformationPicture", "Landroid/graphics/Picture;", "pixelOpacity", "Lcoil3/gif/PixelOpacity;", "isSoftwareScalingEnabled", "draw", "", "canvas", "updateFrameTime", "drawFrame", "setRepeatCount", "getRepeatCount", "setAnimatedTransformation", "getAnimatedTransformation", "setAlpha", "alpha", "getOpacity", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "updateBounds", "bounds", "getIntrinsicWidth", "getIntrinsicHeight", "start", "stop", "registerAnimationCallback", "callback", "unregisterAnimationCallback", "clearAnimationCallbacks", "getBounds", "(Landroid/graphics/Canvas;)Landroid/graphics/Rect;", "Companion", "coil-gif_release"})
@SourceDebugExtension(value={"SMAP\nMovieDrawable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MovieDrawable.kt\ncoil3/gif/MovieDrawable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Canvas.kt\nandroidx/core/graphics/CanvasKt\n+ 4 Bitmap.kt\nandroidx/core/graphics/BitmapKt\n*L\n1#1,289:1\n1#2:290\n30#3,7:291\n30#3,7:298\n30#3,7:305\n95#4:312\n*S KotlinDebug\n*F\n+ 1 MovieDrawable.kt\ncoil3/gif/MovieDrawable\n*L\n75#1:291,7\n127#1:298,7\n134#1:305,7\n226#1:312\n*E\n"})
public final class MovieDrawable
extends Drawable
implements Animatable2Compat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Movie movie;
    @NotNull
    private final Bitmap.Config config;
    @NotNull
    private final Scale scale;
    @NotNull
    private final Paint paint;
    @NotNull
    private final List<Animatable2Compat.AnimationCallback> callbacks;
    @NotNull
    private final Rect currentBounds;
    @NotNull
    private final Rect tempCanvasBounds;
    @Nullable
    private Canvas softwareCanvas;
    @Nullable
    private Bitmap softwareBitmap;
    private float softwareScale;
    private float hardwareScale;
    private float hardwareDx;
    private float hardwareDy;
    private boolean isRunning;
    private long startTimeMillis;
    private long frameTimeMillis;
    private int repeatCount;
    private int loopIteration;
    @Nullable
    private AnimatedTransformation animatedTransformation;
    @Nullable
    private Picture animatedTransformationPicture;
    @NotNull
    private PixelOpacity pixelOpacity;
    private boolean isSoftwareScalingEnabled;
    public static final int REPEAT_INFINITE = -1;

    @JvmOverloads
    public MovieDrawable(@NotNull Movie movie, @NotNull Bitmap.Config config, @NotNull Scale scale) {
        this.movie = movie;
        this.config = config;
        this.scale = scale;
        this.paint = new Paint(3);
        this.callbacks = new ArrayList();
        this.currentBounds = new Rect();
        this.tempCanvasBounds = new Rect();
        this.softwareScale = 1.0f;
        this.hardwareScale = 1.0f;
        this.repeatCount = -1;
        this.pixelOpacity = PixelOpacity.UNCHANGED;
        if (!(!BitmapsKt.isHardware((Bitmap.Config)this.config))) {
            boolean bl = false;
            String string = "Bitmap config must not be hardware.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ MovieDrawable(Movie movie, Bitmap.Config config, Scale scale, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            config = Bitmap.Config.ARGB_8888;
        }
        if ((n & 4) != 0) {
            scale = Scale.FIT;
        }
        this(movie, config, scale);
    }

    @NotNull
    public final Bitmap.Config getConfig() {
        return this.config;
    }

    @NotNull
    public final Scale getScale() {
        return this.scale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(@NotNull Canvas canvas) {
        boolean invalidate = this.updateFrameTime();
        if (this.isSoftwareScalingEnabled) {
            this.updateBounds(this.getBounds(canvas));
            Canvas $this$withSave$iv = canvas;
            boolean $i$f$withSave = false;
            int checkpoint$iv = $this$withSave$iv.save();
            try {
                Canvas $this$draw_u24lambda_u241 = $this$withSave$iv;
                boolean bl = false;
                float scale = 1.0f / this.softwareScale;
                $this$draw_u24lambda_u241.scale(scale, scale);
                this.drawFrame(canvas);
            }
            finally {
                $this$withSave$iv.restoreToCount(checkpoint$iv);
            }
        } else {
            this.updateBounds(this.getBounds());
            this.drawFrame(canvas);
        }
        if (this.isRunning && invalidate) {
            this.invalidateSelf();
        } else {
            this.stop();
        }
    }

    private final boolean updateFrameTime() {
        boolean invalidate = false;
        int time = 0;
        int duration = this.movie.duration();
        if (duration == 0) {
            invalidate = false;
            time = 0;
        } else {
            if (this.isRunning) {
                this.frameTimeMillis = SystemClock.uptimeMillis();
            }
            int elapsedTime = (int)(this.frameTimeMillis - this.startTimeMillis);
            this.loopIteration = elapsedTime / duration;
            invalidate = this.repeatCount == -1 || this.loopIteration <= this.repeatCount;
            time = invalidate ? elapsedTime - this.loopIteration * duration : duration;
        }
        this.movie.setTime(time);
        return invalidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void drawFrame(Canvas canvas) {
        Canvas softwareCanvas = this.softwareCanvas;
        Bitmap softwareBitmap = this.softwareBitmap;
        if (softwareCanvas == null || softwareBitmap == null) {
            return;
        }
        softwareCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        Canvas $this$withSave$iv = softwareCanvas;
        boolean $i$f$withSave = false;
        int checkpoint$iv = $this$withSave$iv.save();
        try {
            Canvas $this$drawFrame_u24lambda_u242 = $this$withSave$iv;
            boolean bl = false;
            $this$drawFrame_u24lambda_u242.scale(this.softwareScale, this.softwareScale);
            this.movie.draw($this$drawFrame_u24lambda_u242, 0.0f, 0.0f, this.paint);
            Picture picture = this.animatedTransformationPicture;
            if (picture != null) {
                picture.draw($this$drawFrame_u24lambda_u242);
            }
        }
        finally {
            $this$withSave$iv.restoreToCount(checkpoint$iv);
        }
        $this$withSave$iv = canvas;
        $i$f$withSave = false;
        checkpoint$iv = $this$withSave$iv.save();
        try {
            Canvas $this$drawFrame_u24lambda_u243 = $this$withSave$iv;
            boolean bl = false;
            $this$drawFrame_u24lambda_u243.translate(this.hardwareDx, this.hardwareDy);
            $this$drawFrame_u24lambda_u243.scale(this.hardwareScale, this.hardwareScale);
            $this$drawFrame_u24lambda_u243.drawBitmap(softwareBitmap, 0.0f, 0.0f, this.paint);
        }
        finally {
            $this$withSave$iv.restoreToCount(checkpoint$iv);
        }
    }

    public final void setRepeatCount(int repeatCount) {
        if (!(repeatCount >= -1)) {
            boolean bl = false;
            String string = "Invalid repeatCount: " + repeatCount;
            throw new IllegalArgumentException(string.toString());
        }
        this.repeatCount = repeatCount;
    }

    public final int getRepeatCount() {
        return this.repeatCount;
    }

    public final void setAnimatedTransformation(@Nullable AnimatedTransformation animatedTransformation) {
        this.animatedTransformation = animatedTransformation;
        if (animatedTransformation != null && this.movie.width() > 0 && this.movie.height() > 0) {
            Picture picture = new Picture();
            Canvas canvas = picture.beginRecording(this.movie.width(), this.movie.height());
            this.pixelOpacity = animatedTransformation.transform(canvas);
            picture.endRecording();
            this.animatedTransformationPicture = picture;
            this.isSoftwareScalingEnabled = true;
        } else {
            this.animatedTransformationPicture = null;
            this.pixelOpacity = PixelOpacity.UNCHANGED;
            this.isSoftwareScalingEnabled = false;
        }
        this.invalidateSelf();
    }

    @Nullable
    public final AnimatedTransformation getAnimatedTransformation() {
        return this.animatedTransformation;
    }

    public void setAlpha(int alpha) {
        if (!(0 <= alpha ? alpha < 256 : false)) {
            boolean bl = false;
            String string = "Invalid alpha: " + alpha;
            throw new IllegalArgumentException(string.toString());
        }
        this.paint.setAlpha(alpha);
    }

    @Deprecated(message="Deprecated in Java")
    public int getOpacity() {
        return this.paint.getAlpha() == 255 && (this.pixelOpacity == PixelOpacity.OPAQUE || this.pixelOpacity == PixelOpacity.UNCHANGED && this.movie.isOpaque()) ? -1 : -3;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
    }

    private final void updateBounds(Rect bounds) {
        double $this$updateBounds_u24lambda_u246;
        if (Intrinsics.areEqual((Object)this.currentBounds, (Object)bounds)) {
            return;
        }
        this.currentBounds.set(bounds);
        int boundsWidth = bounds.width();
        int boundsHeight = bounds.height();
        int movieWidth = this.movie.width();
        int movieHeight = this.movie.height();
        if (movieWidth <= 0 || movieHeight <= 0) {
            return;
        }
        double d = DecodeUtils.computeSizeMultiplier((int)movieWidth, (int)movieHeight, (int)boundsWidth, (int)boundsHeight, (Scale)this.scale);
        MovieDrawable movieDrawable = this;
        boolean bl = false;
        void var12_11 = this.isSoftwareScalingEnabled ? $this$updateBounds_u24lambda_u246 : RangesKt.coerceAtMost((double)$this$updateBounds_u24lambda_u246, (double)1.0);
        movieDrawable.softwareScale = (float)var12_11;
        int bitmapWidth = (int)(this.softwareScale * (float)movieWidth);
        int bitmapHeight = (int)(this.softwareScale * (float)movieHeight);
        Bitmap.Config config$iv = this.config;
        boolean $i$f$createBitmap = false;
        Bitmap bitmap = Bitmap.createBitmap((int)bitmapWidth, (int)bitmapHeight, (Bitmap.Config)config$iv);
        Bitmap bitmap2 = this.softwareBitmap;
        if (bitmap2 != null) {
            bitmap2.recycle();
        }
        this.softwareBitmap = bitmap;
        this.softwareCanvas = new Canvas(bitmap);
        if (this.isSoftwareScalingEnabled) {
            this.hardwareScale = 1.0f;
            this.hardwareDx = 0.0f;
            this.hardwareDy = 0.0f;
        } else {
            this.hardwareScale = (float)DecodeUtils.computeSizeMultiplier((int)bitmapWidth, (int)bitmapHeight, (int)boundsWidth, (int)boundsHeight, (Scale)this.scale);
            this.hardwareDx = (float)bounds.left + ((float)boundsWidth - this.hardwareScale * (float)bitmapWidth) / (float)2;
            this.hardwareDy = (float)bounds.top + ((float)boundsHeight - this.hardwareScale * (float)bitmapHeight) / (float)2;
        }
    }

    public int getIntrinsicWidth() {
        return this.movie.width();
    }

    public int getIntrinsicHeight() {
        return this.movie.height();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.loopIteration = 0;
        this.startTimeMillis = SystemClock.uptimeMillis();
        int n = ((Collection)this.callbacks).size();
        for (int index = 0; index < n; ++index) {
            this.callbacks.get(index).onAnimationStart((Drawable)this);
        }
        this.invalidateSelf();
    }

    public void stop() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        int n = ((Collection)this.callbacks).size();
        for (int index = 0; index < n; ++index) {
            this.callbacks.get(index).onAnimationEnd((Drawable)this);
        }
    }

    public void registerAnimationCallback(@NotNull Animatable2Compat.AnimationCallback callback) {
        this.callbacks.add(callback);
    }

    public boolean unregisterAnimationCallback(@NotNull Animatable2Compat.AnimationCallback callback) {
        return this.callbacks.remove(callback);
    }

    public void clearAnimationCallbacks() {
        this.callbacks.clear();
    }

    private final Rect getBounds(Canvas $this$bounds) {
        Rect rect;
        Rect $this$_get_bounds__u24lambda_u247 = rect = this.tempCanvasBounds;
        boolean bl = false;
        $this$_get_bounds__u24lambda_u247.set(0, 0, $this$bounds.getWidth(), $this$bounds.getHeight());
        return rect;
    }

    @JvmOverloads
    public MovieDrawable(@NotNull Movie movie, @NotNull Bitmap.Config config) {
        this(movie, config, null, 4, null);
    }

    @JvmOverloads
    public MovieDrawable(@NotNull Movie movie) {
        this(movie, null, null, 6, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcoil3/gif/MovieDrawable$Companion;", "", "<init>", "()V", "REPEAT_INFINITE", "", "coil-gif_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

