[coil-video](../../index.md) / [coil.decode](../index.md) / [VideoFrameDecoder](./index.md)

# VideoFrameDecoder

`class VideoFrameDecoder : `[`Decoder`](https://coil-kt.github.io/coil/api/coil-base/coil.decode/-decoder/index.html)

A [Decoder](https://coil-kt.github.io/coil/api/coil-base/coil.decode/-decoder/index.html) that uses [MediaMetadataRetriever](https://developer.android.com/reference/android/media/MediaMetadataRetriever.html) to fetch and decode a frame from a video.

NOTE: [VideoFrameDecoder](https://coil-kt.github.io/coil/api/coil-base/coil.decode/-video-frame-decoder/index.html) creates a temporary copy of the video on the file system. This may cause the decode
process to fail if the video being decoded is very large and/or the device is very low on disk space.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | A [Decoder](https://coil-kt.github.io/coil/api/coil-base/coil.decode/-decoder/index.html) that uses [MediaMetadataRetriever](https://developer.android.com/reference/android/media/MediaMetadataRetriever.html) to fetch and decode a frame from a video.`VideoFrameDecoder(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`)` |

### Functions

| Name | Summary |
|---|---|
| [decode](decode.md) | `suspend fun decode(pool: `[`BitmapPool`](https://coil-kt.github.io/coil/api/coil-base/coil.bitmap/-bitmap-pool/index.html)`, source: `[`BufferedSource`](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.html)`, size: `[`Size`](https://coil-kt.github.io/coil/api/coil-base/coil.size/-size/index.html)`, options: `[`Options`](https://coil-kt.github.io/coil/api/coil-base/coil.decode/-options/index.html)`): `[`DecodeResult`](https://coil-kt.github.io/coil/api/coil-base/coil.decode/-decode-result/index.html) |
| [handles](handles.md) | `fun handles(source: `[`BufferedSource`](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.html)`, mimeType: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |

### Companion Object Properties

| Name | Summary |
|---|---|
| [VIDEO_FRAME_MICROS_KEY](-v-i-d-e-o_-f-r-a-m-e_-m-i-c-r-o-s_-k-e-y.md) | `const val VIDEO_FRAME_MICROS_KEY: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [VIDEO_FRAME_OPTION_KEY](-v-i-d-e-o_-f-r-a-m-e_-o-p-t-i-o-n_-k-e-y.md) | `const val VIDEO_FRAME_OPTION_KEY: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
