[coil-singleton](../../index.md) / [coil](../index.md) / [android.widget.ImageView](index.md) / [loadAny](./load-any.md)

# loadAny

`inline fun `[`ImageView`](https://developer.android.com/reference/android/widget/ImageView.html)`.loadAny(data: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?, imageLoader: `[`ImageLoader`](https://coil-kt.github.io/coil/api/coil-base/coil/-image-loader/index.html)` = context.imageLoader, builder: `[`Builder`](https://coil-kt.github.io/coil/api/coil-base/coil.request/-image-request/-builder/index.html)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}): `[`Disposable`](https://coil-kt.github.io/coil/api/coil-base/coil.request/-disposable/index.html)

Load the image referenced by [data](https://coil-kt.github.io/coil/api/coil-base/coil/load-any/data.html) and set it on this [ImageView](https://developer.android.com/reference/android/widget/ImageView.html).

[ImageView.loadAny](https://coil-kt.github.io/coil/api/coil-base/coil/load-any.html) is the type-unsafe version of [ImageView.load](https://coil-kt.github.io/coil/api/coil-base/coil/load.html).

Example:

```
imageView.load("https://www.example.com/image.jpg") {
    crossfade(true)
    transformations(CircleCropTransformation())
}
```

### Parameters

`data` - The data to load.

`imageLoader` - The [ImageLoader](https://coil-kt.github.io/coil/api/coil-base/coil/-image-loader/index.html) that will be used to enqueue the [ImageRequest](https://coil-kt.github.io/coil/api/coil-base/coil.request/-image-request/index.html).

`builder` - An optional lambda to configure the request before it is enqueued.