[coil-base](../../../index.md) / [coil](../../index.md) / [ImageLoader](../index.md) / [Builder](index.md) / [launchInterceptorChainOnMainThread](./launch-interceptor-chain-on-main-thread.md)

# launchInterceptorChainOnMainThread

`fun launchInterceptorChainOnMainThread(enable: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): Builder`

Enables launching the [Interceptor](../../../coil.intercept/-interceptor/index.md) chain on the main thread.

If true, the [Interceptor](../../../coil.intercept/-interceptor/index.md) chain will be launched from [MainCoroutineDispatcher.immediate](https://kotlin.github.io/kotlinx.coroutines/kotlinx-coroutines-core/kotlinx.coroutines/-main-coroutine-dispatcher/immediate.html). This allows
the [ImageLoader](../index.md) to check its memory cache and return a cached value synchronously if the request is
started from the main thread. However, [Mapper.map](../../../coil.map/-mapper/map.md) and [Fetcher.key](../../../coil.fetch/-fetcher/key.md) operations will be executed on the
main thread as well, which has a performance cost.

If false, the [Interceptor](../../../coil.intercept/-interceptor/index.md) chain will be launched from the request's [ImageRequest.dispatcher](../../../coil.request/-image-request/dispatcher.md).
This will result in better UI performance, but values from the memory cache will not be resolved
synchronously.

The actual fetch + decode process always occurs on [ImageRequest.dispatcher](../../../coil.request/-image-request/dispatcher.md) and is unaffected by this flag.

It's worth noting that [Interceptor](../../../coil.intercept/-interceptor/index.md)s can also control which [CoroutineDispatcher](https://kotlin.github.io/kotlinx.coroutines/kotlinx-coroutines-core/kotlinx.coroutines/-coroutine-dispatcher/index.html) the
memory cache is checked on by calling [Interceptor.Chain.proceed](../../../coil.intercept/-interceptor/-chain/proceed.md) inside a [withContext](https://kotlin.github.io/kotlinx.coroutines/kotlinx-coroutines-core/kotlinx.coroutines/with-context.html) block.
Therefore if you set [launchInterceptorChainOnMainThread](./launch-interceptor-chain-on-main-thread.md) to true, you can control which [ImageRequest](../../../coil.request/-image-request/index.md)s
check the memory cache synchronously at runtime.

Default: true

