[coil-base](../../index.md) / [coil.util](../index.md) / [DebugLogger](./index.md)

# DebugLogger

`class DebugLogger : `[`Logger`](../-logger/index.md)

A [Logger](../-logger/index.md) implementation that writes to Android's [Log](https://developer.android.com/reference/android/util/Log.html).

NOTE: You **should not** enable this in release builds. Adding this to your [ImageLoader](../../coil/-image-loader/index.md) reduces performance.
Additionally, this will log URLs which can contain [PII](https://en.wikipedia.org/wiki/Personal_data).

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | A [Logger](../-logger/index.md) implementation that writes to Android's [Log](https://developer.android.com/reference/android/util/Log.html).`DebugLogger(level: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = Log.DEBUG)` |

### Properties

| Name | Summary |
|---|---|
| [level](level.md) | The minimum level for this logger to log.`var level: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |

### Functions

| Name | Summary |
|---|---|
| [log](log.md) | Write [message](../-logger/log.md#coil.util.Logger$log(kotlin.String, kotlin.Int, kotlin.String, kotlin.Throwable)/message) and/or [throwable](../-logger/log.md#coil.util.Logger$log(kotlin.String, kotlin.Int, kotlin.String, kotlin.Throwable)/throwable) to a logging destination.`fun log(tag: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, priority: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, message: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, throwable: `[`Throwable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
