[coil-base](../../index.md) / [coil.target](../index.md) / [ViewTarget](./index.md)

# ViewTarget

`interface ViewTarget<T : `[`View`](https://developer.android.com/reference/android/view/View.html)`> : `[`Target`](../-target/index.md)

A [Target](../-target/index.md) with an associated [View](https://developer.android.com/reference/android/view/View.html). Prefer this to [Target](../-target/index.md) if the given drawables will only be used by [view](view.md).

Optionally, [ViewTarget](./index.md)s can implement [LifecycleObserver](https://developer.android.com/reference/androidx/lifecycle/LifecycleObserver.html). They are automatically registered when the request
starts and unregistered when the request completes.

### Properties

| Name | Summary |
|---|---|
| [view](view.md) | The [View](https://developer.android.com/reference/android/view/View.html) used by this [Target](../-target/index.md). This field should be immutable.`abstract val view: T` |

### Inheritors

| Name | Summary |
|---|---|
| [PoolableViewTarget](../-poolable-view-target/index.md) | A [ViewTarget](./index.md) that supports [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html) pooling.`interface PoolableViewTarget<T : `[`View`](https://developer.android.com/reference/android/view/View.html)`> : `[`ViewTarget`](./index.md)`<T>` |
