[coil-base](../../index.md) / [coil.size](../index.md) / [SizeResolver](./index.md)

# SizeResolver

`interface SizeResolver`

An interface for measuring the target size for an image request.

**See Also**

[ImageRequest.Builder.size](../../coil.request/-image-request/-builder/size.md)

### Functions

| Name | Summary |
|---|---|
| [size](size.md) | Return the [Size](../-size.md) that the image should be loaded at.`abstract suspend fun size(): `[`Size`](../-size.md) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [invoke](invoke.md) | Create a [SizeResolver](./index.md) with a fixed [size](invoke.md#coil.size.SizeResolver.Companion$invoke(coil.size.Size)/size).`operator fun invoke(size: `[`Size`](../-size.md)`): `[`SizeResolver`](./index.md) |

### Inheritors

| Name | Summary |
|---|---|
| [DisplaySizeResolver](../-display-size-resolver/index.md) | A [SizeResolver](./index.md) that measures the size of the display.`class DisplaySizeResolver : `[`SizeResolver`](./index.md) |
| [ViewSizeResolver](../-view-size-resolver/index.md) | A [SizeResolver](./index.md) that measures the size of a [View](https://developer.android.com/reference/android/view/View.html).`interface ViewSizeResolver<T : `[`View`](https://developer.android.com/reference/android/view/View.html)`> : `[`SizeResolver`](./index.md) |
