[coil-base](../../index.md) / [coil.size](../index.md) / [Scale](./index.md)

# Scale

`enum class Scale`

Represents a scaling policy.

Conceptually, you can think of this as [ImageView.ScaleType](https://developer.android.com/reference/android/widget/ImageView/ScaleType.html) without any knowledge of an image's gravity in the view.

**See Also**

[ImageRequest.Builder.scale](../../coil.request/-image-request/-builder/scale.md)

### Enum Values

| Name | Summary |
|---|---|
| [FILL](-f-i-l-l.md) | Fill the image in the view such that both dimensions (width and height) of the image will be **equal to or larger than** the corresponding dimension of the view. |
| [FIT](-f-i-t.md) | Fit the image to the view so that both dimensions (width and height) of the image will be **equal to or less than** the corresponding dimension of the view. |
