[coil-base](../index.md) / [coil.request](./index.md)

## Package coil.request

### Types

| Name | Summary |
|---|---|
| [CachePolicy](-cache-policy/index.md) | Represents the read/write policy for a cache source.`enum class CachePolicy` |
| [DefaultRequestOptions](-default-request-options/index.md) | A set of default options that are used to fill in unset [ImageRequest](-image-request/index.md) values.`class DefaultRequestOptions` |
| [DefinedRequestOptions](-defined-request-options/index.md) | Tracks which values have been set (instead of computed automatically using a default) when building an [ImageRequest](-image-request/index.md).`class DefinedRequestOptions` |
| [Disposable](-disposable/index.md) | Represents the work of an executed [ImageRequest](-image-request/index.md).`interface Disposable` |
| [ErrorResult](-error-result/index.md) | Indicates that an error occurred while executing the request.`data class ErrorResult : `[`ImageResult`](-image-result/index.md) |
| [ImageRequest](-image-request/index.md) | An immutable value object that represents a request for an image.`class ImageRequest` |
| [ImageResult](-image-result/index.md) | Represents the result of an image request.`sealed class ImageResult` |
| [NullRequestData](-null-request-data/index.md) | The value for [ImageRequest.data](-image-request/data.md) if the request's data was not set or was set to null.`object NullRequestData` |
| [Parameters](-parameters/index.md) | A map of generic values that can be used to pass custom data to [Fetcher](../coil.fetch/-fetcher/index.md)s and [Decoder](../coil.decode/-decoder/index.md)s.`class Parameters : `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<`[`Pair`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, Entry>>` |
| [SuccessResult](-success-result/index.md) | Indicates that the request completed successfully.`data class SuccessResult : `[`ImageResult`](-image-result/index.md) |

### Exceptions

| Name | Summary |
|---|---|
| [NullRequestDataException](-null-request-data-exception/index.md) | Exception thrown when an [ImageRequest](-image-request/index.md) with empty/null data is executed by an [ImageLoader](../coil/-image-loader/index.md).`class NullRequestDataException : `[`RuntimeException`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-runtime-exception/index.html) |

### Functions

| Name | Summary |
|---|---|
| [count](count.md) | Returns the number of parameters in this object.`fun `[`Parameters`](-parameters/index.md)`.count(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [get](get.md) | Returns the value associated with [key](get.md#coil.request$get(coil.request.Parameters, kotlin.String)/key) or null if [key](get.md#coil.request$get(coil.request.Parameters, kotlin.String)/key) has no mapping.`operator fun `[`Parameters`](-parameters/index.md)`.get(key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?` |
| [isNotEmpty](is-not-empty.md) | Return true when the set contains elements.`fun `[`Parameters`](-parameters/index.md)`.isNotEmpty(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
