[coil-base](../../index.md) / [coil.request](../index.md) / [ImageResult](./index.md)

# ImageResult

`sealed class ImageResult`

Represents the result of an image request.

**See Also**

[ImageLoader.execute](../../coil/-image-loader/execute.md)

### Types

| Name | Summary |
|---|---|
| [Metadata](-metadata/index.md) | Supplemental information about a successful image request.`data class Metadata` |

### Properties

| Name | Summary |
|---|---|
| [drawable](drawable.md) | `abstract val drawable: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?` |
| [request](request.md) | `abstract val request: `[`ImageRequest`](../-image-request/index.md) |

### Inheritors

| Name | Summary |
|---|---|
| [ErrorResult](../-error-result/index.md) | Indicates that an error occurred while executing the request.`data class ErrorResult : `[`ImageResult`](./index.md) |
| [SuccessResult](../-success-result/index.md) | Indicates that the request completed successfully.`data class SuccessResult : `[`ImageResult`](./index.md) |
