[coil-base](../../../index.md) / [coil.request](../../index.md) / [ImageResult](../index.md) / [Metadata](./index.md)

# Metadata

`data class Metadata`

Supplemental information about a successful image request.

### Parameters

`memoryCacheKey` - The cache key for the image in the memory cache.
It is null if the image was not written to the memory cache.

`isSampled` - True if the image is sampled (i.e. loaded into memory at less than its original size).

`dataSource` - The data source that the image was loaded from.

`isPlaceholderMemoryCacheKeyPresent` - True if the request's [ImageRequest.placeholderMemoryCacheKey](../../-image-request/placeholder-memory-cache-key.md) was
present in the memory cache and was set as the placeholder.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | Supplemental information about a successful image request.`Metadata(memoryCacheKey: Key?, isSampled: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`, dataSource: `[`DataSource`](../../../coil.decode/-data-source/index.md)`, isPlaceholderMemoryCacheKeyPresent: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`)` |

### Properties

| Name | Summary |
|---|---|
| [dataSource](data-source.md) | The data source that the image was loaded from.`val dataSource: `[`DataSource`](../../../coil.decode/-data-source/index.md) |
| [isPlaceholderMemoryCacheKeyPresent](is-placeholder-memory-cache-key-present.md) | True if the request's [ImageRequest.placeholderMemoryCacheKey](../../-image-request/placeholder-memory-cache-key.md) was present in the memory cache and was set as the placeholder.`val isPlaceholderMemoryCacheKeyPresent: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [isSampled](is-sampled.md) | True if the image is sampled (i.e. loaded into memory at less than its original size).`val isSampled: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [memoryCacheKey](memory-cache-key.md) | The cache key for the image in the memory cache. It is null if the image was not written to the memory cache.`val memoryCacheKey: Key?` |
