[coil-base](../../index.md) / [coil.fetch](../index.md) / [SourceResult](./index.md)

# SourceResult

`data class SourceResult : `[`FetchResult`](../-fetch-result.md)

A raw [BufferedSource](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.html) result, which will be consumed by the relevant [Decoder](../../coil.decode/-decoder/index.md).

### Parameters

`source` - An unconsumed [BufferedSource](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.html) that will be decoded by a [Decoder](../../coil.decode/-decoder/index.md).

`mimeType` - An optional MIME type for the [source](source.md).

`dataSource` - Where [source](source.md) was loaded from.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | A raw [BufferedSource](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.html) result, which will be consumed by the relevant [Decoder](../../coil.decode/-decoder/index.md).`SourceResult(source: `[`BufferedSource`](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.html)`, mimeType: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, dataSource: `[`DataSource`](../../coil.decode/-data-source/index.md)`)` |

### Properties

| Name | Summary |
|---|---|
| [dataSource](data-source.md) | Where [source](source.md) was loaded from.`val dataSource: `[`DataSource`](../../coil.decode/-data-source/index.md) |
| [mimeType](mime-type.md) | An optional MIME type for the [source](source.md).`val mimeType: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| [source](source.md) | An unconsumed [BufferedSource](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.html) that will be decoded by a [Decoder](../../coil.decode/-decoder/index.md).`val source: `[`BufferedSource`](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.html) |
