[coil-base](../../index.md) / [coil.drawable](../index.md) / [CrossfadeDrawable](index.md) / [&lt;init&gt;](./-init-.md)

# &lt;init&gt;

`CrossfadeDrawable(start: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?, end: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?, scale: `[`Scale`](../../coil.size/-scale/index.md)` = Scale.FIT, durationMillis: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = DEFAULT_DURATION, fadeStart: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = true)``CrossfadeDrawable(start: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?, end: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?, scale: `[`Scale`](../../coil.size/-scale/index.md)` = Scale.FIT, durationMillis: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = DEFAULT_DURATION, fadeStart: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = true, preferExactIntrinsicSize: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false)`

A [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html) that crossfades from [start](start.md) to [end](#).

NOTE: The animation can only be executed once as the [start](start.md) drawable is dereferenced at the end of the transition.

### Parameters

`start` - The [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html) to crossfade from.

`end` - The [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html) to crossfade to.

`scale` - The scaling algorithm for [start](start.md) and [end](#).

`durationMillis` - The duration of the crossfade animation.

`fadeStart` - If false, the start drawable will not fade out while the end drawable fades in.

`preferExactIntrinsicSize` - If true, this drawable's intrinsic width/height will only be -1 if
[start](start.md) **and** [end](#) return -1 for that dimension. If false, the intrinsic width/height will be -1 if
[start](start.md) **or** [end](#) return -1 for that dimension. This is useful for views that require an exact intrinsic
size to scale the drawable.