[coil-base](../../index.md) / [coil.decode](../index.md) / [Decoder](index.md) / [handles](./handles.md)

# handles

`abstract fun handles(source: `[`BufferedSource`](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.html)`, mimeType: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)

Return true if this decoder supports decoding [source](handles.md#coil.decode.Decoder$handles(okio.BufferedSource, kotlin.String)/source).

Implementations **must not** consume the source, as this can cause subsequent calls to [handles](./handles.md) and [decode](decode.md) to fail.

Prefer using [BufferedSource.peek](https://square.github.io/okio/2.x/okio/okio/-buffered-source/peek.html), [BufferedSource.rangeEquals](https://square.github.io/okio/2.x/okio/okio/-buffered-source/range-equals.html), or other non-destructive methods to check
for the presence of header bytes or other markers. Implementations can also rely on [mimeType](handles.md#coil.decode.Decoder$handles(okio.BufferedSource, kotlin.String)/mimeType),
however it is not guaranteed to be accurate (e.g. a file that ends with .png, but is encoded as a .jpg).

### Parameters

`source` - The [BufferedSource](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.html) to read from.

`mimeType` - An optional MIME type for the [source](handles.md#coil.decode.Decoder$handles(okio.BufferedSource, kotlin.String)/source).