[coil-base](../../index.md) / [coil.bitmap](../index.md) / [BitmapPool](./index.md)

# BitmapPool

`interface BitmapPool`

An object pool that enables callers to reuse [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html) objects.

### Functions

| Name | Summary |
|---|---|
| [clear](clear.md) | Remove all [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html)s from this pool and free their memory.`abstract fun clear(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [get](get.md) | Return a [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html) of exactly the given width, height, and configuration, and containing only transparent pixels.`abstract fun get(width: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, height: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, config: `[`Config`](https://developer.android.com/reference/android/graphics/Bitmap/Config.html)`): `[`Bitmap`](https://developer.android.com/reference/android/graphics/Bitmap.html) |
| [getDirty](get-dirty.md) | Identical to [get](get.md) except that any returned [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html) may not have been erased and may contain random data.`abstract fun getDirty(width: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, height: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, config: `[`Config`](https://developer.android.com/reference/android/graphics/Bitmap/Config.html)`): `[`Bitmap`](https://developer.android.com/reference/android/graphics/Bitmap.html) |
| [getDirtyOrNull](get-dirty-or-null.md) | Identical to [getDirty](get-dirty.md) except that null will be returned if the pool does not contain a usable bitmap.`abstract fun getDirtyOrNull(width: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, height: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, config: `[`Config`](https://developer.android.com/reference/android/graphics/Bitmap/Config.html)`): `[`Bitmap`](https://developer.android.com/reference/android/graphics/Bitmap.html)`?` |
| [getOrNull](get-or-null.md) | Identical to [get](get.md) except that null will be returned if the pool does not contain a usable bitmap.`abstract fun getOrNull(width: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, height: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, config: `[`Config`](https://developer.android.com/reference/android/graphics/Bitmap/Config.html)`): `[`Bitmap`](https://developer.android.com/reference/android/graphics/Bitmap.html)`?` |
| [put](put.md) | Add the given [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html) to the pool if it is eligible to be re-used and the pool can fit it. Otherwise, this method calls [Bitmap.recycle](https://developer.android.com/reference/android/graphics/Bitmap.html#recycle()) on the bitmap and discards it.`abstract fun put(bitmap: `[`Bitmap`](https://developer.android.com/reference/android/graphics/Bitmap.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [trimMemory](trim-memory.md) | `abstract fun trimMemory(level: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [invoke](invoke.md) | Create a new [BitmapPool](./index.md).`operator fun invoke(maxSize: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`BitmapPool`](./index.md) |
