/*
 * Decompiled with CFR 0.152.
 */
package coil.compose;

import android.os.SystemClock;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.State;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.ColorFilter;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.painter.Painter;
import coil.decode.DecodeUtils;
import coil.size.Scale;
import kotlin.Metadata;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0003\u0018\u00002\u00020\u0001B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u001fH\u0014J\u0012\u0010*\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0014J%\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u0015H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b.\u0010/J\u0018\u00100\u001a\u00020\u0015H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b1\u0010\u0017J\u001e\u00102\u001a\u000203*\u0002042\b\u00105\u001a\u0004\u0018\u00010\u00012\u0006\u0010)\u001a\u00020\u001fH\u0002J\f\u00106\u001a\u000203*\u000204H\u0014R/\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R+\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00078B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u0013\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010 \u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\u001f8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b%\u0010\u0013\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00067"}, d2={"Lcoil/compose/CrossfadePainter;", "Landroidx/compose/ui/graphics/painter/Painter;", "start", "end", "scale", "Lcoil/size/Scale;", "durationMillis", "", "fadeStart", "", "(Landroidx/compose/ui/graphics/painter/Painter;Landroidx/compose/ui/graphics/painter/Painter;Lcoil/size/Scale;IZ)V", "<set-?>", "Landroidx/compose/ui/graphics/ColorFilter;", "colorFilter", "getColorFilter", "()Landroidx/compose/ui/graphics/ColorFilter;", "setColorFilter", "(Landroidx/compose/ui/graphics/ColorFilter;)V", "colorFilter$delegate", "Landroidx/compose/runtime/MutableState;", "intrinsicSize", "Landroidx/compose/ui/geometry/Size;", "getIntrinsicSize-NH-jbRc", "()J", "invalidateTick", "getInvalidateTick", "()I", "setInvalidateTick", "(I)V", "invalidateTick$delegate", "isDone", "", "maxAlpha", "getMaxAlpha", "()F", "setMaxAlpha", "(F)V", "maxAlpha$delegate", "startTimeMillis", "", "applyAlpha", "alpha", "applyColorFilter", "computeDrawSize", "srcSize", "dstSize", "computeDrawSize-x8L_9b0", "(JJ)J", "computeIntrinsicSize", "computeIntrinsicSize-NH-jbRc", "drawPainter", "", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "painter", "onDraw", "coil-compose-base_release"})
@Stable
final class CrossfadePainter
extends Painter {
    @Nullable
    private Painter start;
    @Nullable
    private final Painter end;
    @NotNull
    private final Scale scale;
    private final int durationMillis;
    private final boolean fadeStart;
    @NotNull
    private final MutableState invalidateTick$delegate;
    private long startTimeMillis;
    private boolean isDone;
    @NotNull
    private final MutableState maxAlpha$delegate;
    @NotNull
    private final MutableState colorFilter$delegate;

    public CrossfadePainter(@Nullable Painter start, @Nullable Painter end, @NotNull Scale scale, int durationMillis, boolean fadeStart) {
        this.start = start;
        this.end = end;
        this.scale = scale;
        this.durationMillis = durationMillis;
        this.fadeStart = fadeStart;
        this.invalidateTick$delegate = SnapshotStateKt.mutableStateOf$default((Object)0, null, (int)2, null);
        this.startTimeMillis = -1L;
        this.maxAlpha$delegate = SnapshotStateKt.mutableStateOf$default((Object)Float.valueOf(1.0f), null, (int)2, null);
        this.colorFilter$delegate = SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final int getInvalidateTick() {
        void $this$getValue$iv;
        State state = (State)this.invalidateTick$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setInvalidateTick(int n) {
        void $this$setValue$iv;
        MutableState mutableState = this.invalidateTick$delegate;
        Object var3_3 = null;
        Integer value$iv = n;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final float getMaxAlpha() {
        void $this$getValue$iv;
        State state = (State)this.maxAlpha$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).floatValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setMaxAlpha(float f) {
        void $this$setValue$iv;
        MutableState mutableState = this.maxAlpha$delegate;
        Object var3_3 = null;
        Float value$iv = Float.valueOf(f);
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final ColorFilter getColorFilter() {
        void $this$getValue$iv;
        State state = (State)this.colorFilter$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (ColorFilter)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setColorFilter(ColorFilter colorFilter) {
        void $this$setValue$iv;
        MutableState mutableState = this.colorFilter$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)colorFilter);
    }

    public long getIntrinsicSize-NH-jbRc() {
        return this.computeIntrinsicSize-NH-jbRc();
    }

    protected void onDraw(@NotNull DrawScope $this$onDraw) {
        if (this.isDone) {
            this.drawPainter($this$onDraw, this.end, this.getMaxAlpha());
            return;
        }
        long uptimeMillis = SystemClock.uptimeMillis();
        if (this.startTimeMillis == -1L) {
            this.startTimeMillis = uptimeMillis;
        }
        float percent = (float)(uptimeMillis - this.startTimeMillis) / (float)this.durationMillis;
        float endAlpha = RangesKt.coerceIn((float)percent, (float)0.0f, (float)1.0f) * this.getMaxAlpha();
        float startAlpha = this.fadeStart ? this.getMaxAlpha() - endAlpha : this.getMaxAlpha();
        this.isDone = (double)percent >= 1.0;
        this.drawPainter($this$onDraw, this.start, startAlpha);
        this.drawPainter($this$onDraw, this.end, endAlpha);
        if (this.isDone) {
            this.start = null;
        } else {
            CrossfadePainter crossfadePainter = this;
            int n = crossfadePainter.getInvalidateTick();
            crossfadePainter.setInvalidateTick(n + 1);
        }
    }

    protected boolean applyAlpha(float alpha) {
        this.setMaxAlpha(alpha);
        return true;
    }

    protected boolean applyColorFilter(@Nullable ColorFilter colorFilter) {
        this.setColorFilter(colorFilter);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final long computeIntrinsicSize-NH-jbRc() {
        long l;
        Painter painter = this.start;
        Size size = painter == null ? null : Size.box-impl((long)painter.getIntrinsicSize-NH-jbRc());
        long startSize = size == null ? Size.Companion.getZero-NH-jbRc() : size.unbox-impl();
        Painter painter2 = this.end;
        Size size2 = painter2 == null ? null : Size.box-impl((long)painter2.getIntrinsicSize-NH-jbRc());
        long endSize = size2 == null ? Size.Companion.getZero-NH-jbRc() : size2.unbox-impl();
        boolean bl = false;
        if (startSize != Size.Companion.getUnspecified-NH-jbRc()) {
            bl = false;
            if (endSize != Size.Companion.getUnspecified-NH-jbRc()) {
                float f = Size.getWidth-impl((long)startSize);
                float f2 = Size.getWidth-impl((long)endSize);
                boolean bl2 = false;
                float f3 = Math.max(f, f2);
                f = Size.getHeight-impl((long)startSize);
                f2 = Size.getHeight-impl((long)endSize);
                bl2 = false;
                l = SizeKt.Size((float)f3, (float)Math.max(f, f2));
                return l;
            }
        }
        l = Size.Companion.getUnspecified-NH-jbRc();
        return l;
    }

    /*
     * WARNING - void declaration
     */
    private final void drawPainter(DrawScope $this$drawPainter, Painter painter, float alpha) {
        if (painter == null || alpha <= 0.0f) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        Painter $this$drawPainter_u24lambda_u2d1 = painter;
        boolean bl3 = false;
        long size = $this$drawPainter.getSize-NH-jbRc();
        long drawSize = this.computeDrawSize-x8L_9b0($this$drawPainter_u24lambda_u2d1.getIntrinsicSize-NH-jbRc(), size);
        boolean bl42 = false;
        if (size == Size.Companion.getUnspecified-NH-jbRc() || Size.isEmpty-impl((long)size)) {
            $this$drawPainter_u24lambda_u2d1.draw-x_KDEd0($this$drawPainter, drawSize, alpha, this.getColorFilter());
        } else {
            void vertical$iv;
            void horizontal$iv;
            void $this$inset$iv;
            DrawScope bl42 = $this$drawPainter;
            float f = (Size.getWidth-impl((long)size) - Size.getWidth-impl((long)drawSize)) / (float)2;
            float f2 = (Size.getHeight-impl((long)size) - Size.getHeight-impl((long)drawSize)) / (float)2;
            boolean $i$f$inset = false;
            void $this$inset$iv$iv = $this$inset$iv;
            boolean $i$f$inset2 = false;
            $this$inset$iv$iv.getDrawContext().getTransform().inset((float)horizontal$iv, (float)vertical$iv, (float)horizontal$iv, (float)vertical$iv);
            void $this$drawPainter_u24lambda_u2d1_u24lambda_u2d0 = $this$inset$iv$iv;
            boolean bl5 = false;
            $this$drawPainter_u24lambda_u2d1.draw-x_KDEd0((DrawScope)$this$drawPainter_u24lambda_u2d1_u24lambda_u2d0, drawSize, alpha, this.getColorFilter());
            $this$inset$iv$iv.getDrawContext().getTransform().inset((float)(-horizontal$iv), (float)(-vertical$iv), (float)(-horizontal$iv), (float)(-vertical$iv));
        }
    }

    private final long computeDrawSize-x8L_9b0(long srcSize, long dstSize) {
        boolean bl = false;
        if (srcSize == Size.Companion.getUnspecified-NH-jbRc() || Size.isEmpty-impl((long)srcSize)) {
            return dstSize;
        }
        bl = false;
        if (dstSize == Size.Companion.getUnspecified-NH-jbRc() || Size.isEmpty-impl((long)dstSize)) {
            return dstSize;
        }
        float srcWidth = Size.getWidth-impl((long)srcSize);
        float srcHeight = Size.getHeight-impl((long)srcSize);
        float multiplier = DecodeUtils.computeSizeMultiplier((float)srcWidth, (float)srcHeight, (float)Size.getWidth-impl((long)dstSize), (float)Size.getHeight-impl((long)dstSize), (Scale)this.scale);
        return SizeKt.Size((float)(multiplier * srcWidth), (float)(multiplier * srcHeight));
    }
}

