/*
 * Decompiled with CFR 0.152.
 */
package coil.util;

import android.util.Log;
import coil.util.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0003H\u0002R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0005\u00a8\u0006\u0013"}, d2={"Lcoil/util/DebugLogger;", "Lcoil/util/Logger;", "level", "", "<init>", "(I)V", "value", "getLevel", "()I", "setLevel", "log", "", "tag", "", "priority", "message", "throwable", "", "assertValidLevel", "coil-base_release"})
@SourceDebugExtension(value={"SMAP\nDebugLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugLogger.kt\ncoil/util/DebugLogger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public final class DebugLogger
implements Logger {
    private int level;

    @JvmOverloads
    public DebugLogger(int level) {
        this.level = level;
        this.assertValidLevel(level);
    }

    public /* synthetic */ DebugLogger(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        this(n);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int value) {
        this.assertValidLevel(value);
        this.level = value;
    }

    @Override
    public void log(@NotNull String tag, int priority, @Nullable String message, @Nullable Throwable throwable) {
        if (message != null) {
            Log.println((int)priority, (String)tag, (String)message);
        }
        if (throwable != null) {
            StringWriter writer = new StringWriter();
            throwable.printStackTrace(new PrintWriter(writer));
            Log.println((int)priority, (String)tag, (String)writer.toString());
        }
    }

    private final void assertValidLevel(int value) {
        if (!(2 <= value ? value < 8 : false)) {
            boolean bl = false;
            String string = "Invalid log level: " + value;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @JvmOverloads
    public DebugLogger() {
        this(0, 1, null);
    }
}

