/*
 * Decompiled with CFR 0.152.
 */
package coil.target;

import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import coil.target.ViewTarget;
import coil.transition.TransitionTarget;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u00042\u00020\u0005B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\u0013\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u001a\u001a\u00020\u00112\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0004J\b\u0010\u001b\u001a\u00020\u0011H\u0004R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u0004\u0018\u00010\u000bX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcoil/target/GenericViewTarget;", "T", "Landroid/view/View;", "Lcoil/target/ViewTarget;", "Lcoil/transition/TransitionTarget;", "Landroidx/lifecycle/DefaultLifecycleObserver;", "<init>", "()V", "isStarted", "", "drawable", "Landroid/graphics/drawable/Drawable;", "getDrawable", "()Landroid/graphics/drawable/Drawable;", "setDrawable", "(Landroid/graphics/drawable/Drawable;)V", "onStart", "", "placeholder", "onError", "error", "onSuccess", "result", "owner", "Landroidx/lifecycle/LifecycleOwner;", "onStop", "updateDrawable", "updateAnimation", "coil-base_release"})
public abstract class GenericViewTarget<T extends View>
implements ViewTarget<T>,
TransitionTarget,
DefaultLifecycleObserver {
    private boolean isStarted;

    @Override
    @Nullable
    public abstract Drawable getDrawable();

    public abstract void setDrawable(@Nullable Drawable var1);

    @Override
    public void onStart(@Nullable Drawable placeholder) {
        this.updateDrawable(placeholder);
    }

    @Override
    public void onError(@Nullable Drawable error) {
        this.updateDrawable(error);
    }

    @Override
    public void onSuccess(@NotNull Drawable result2) {
        this.updateDrawable(result2);
    }

    public void onStart(@NotNull LifecycleOwner owner2) {
        this.isStarted = true;
        this.updateAnimation();
    }

    public void onStop(@NotNull LifecycleOwner owner2) {
        this.isStarted = false;
        this.updateAnimation();
    }

    protected final void updateDrawable(@Nullable Drawable drawable) {
        Drawable drawable2 = this.getDrawable();
        Animatable animatable = drawable2 instanceof Animatable ? (Animatable)drawable2 : null;
        if (animatable != null) {
            animatable.stop();
        }
        this.setDrawable(drawable);
        this.updateAnimation();
    }

    protected final void updateAnimation() {
        Drawable drawable = this.getDrawable();
        Animatable animatable = drawable instanceof Animatable ? (Animatable)drawable : null;
        if (animatable == null) {
            return;
        }
        Animatable animatable2 = animatable;
        if (this.isStarted) {
            animatable2.start();
        } else {
            animatable2.stop();
        }
    }
}

