/*
 * Decompiled with CFR 0.152.
 */
package coil.network;

import coil.util.-Utils;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Response;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$R\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u000f\u001a\u0004\u0018\u00010\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006%"}, d2={"Lcoil/network/CacheResponse;", "", "source", "Lokio/BufferedSource;", "<init>", "(Lokio/BufferedSource;)V", "response", "Lokhttp3/Response;", "(Lokhttp3/Response;)V", "cacheControl", "Lokhttp3/CacheControl;", "getCacheControl", "()Lokhttp3/CacheControl;", "cacheControl$delegate", "Lkotlin/Lazy;", "contentType", "Lokhttp3/MediaType;", "getContentType", "()Lokhttp3/MediaType;", "contentType$delegate", "sentRequestAtMillis", "", "getSentRequestAtMillis", "()J", "receivedResponseAtMillis", "getReceivedResponseAtMillis", "isTls", "", "()Z", "responseHeaders", "Lokhttp3/Headers;", "getResponseHeaders", "()Lokhttp3/Headers;", "writeTo", "", "sink", "Lokio/BufferedSink;", "coil-base_release"})
public final class CacheResponse {
    @NotNull
    private final Lazy cacheControl$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> CacheResponse.cacheControl_delegate$lambda$0(this));
    @NotNull
    private final Lazy contentType$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> CacheResponse.contentType_delegate$lambda$1(this));
    private final long sentRequestAtMillis;
    private final long receivedResponseAtMillis;
    private final boolean isTls;
    @NotNull
    private final Headers responseHeaders;

    @NotNull
    public final CacheControl getCacheControl() {
        Lazy lazy = this.cacheControl$delegate;
        return (CacheControl)lazy.getValue();
    }

    @Nullable
    public final MediaType getContentType() {
        Lazy lazy = this.contentType$delegate;
        return (MediaType)lazy.getValue();
    }

    public final long getSentRequestAtMillis() {
        return this.sentRequestAtMillis;
    }

    public final long getReceivedResponseAtMillis() {
        return this.receivedResponseAtMillis;
    }

    public final boolean isTls() {
        return this.isTls;
    }

    @NotNull
    public final Headers getResponseHeaders() {
        return this.responseHeaders;
    }

    public CacheResponse(@NotNull BufferedSource source) {
        this.sentRequestAtMillis = Long.parseLong(source.readUtf8LineStrict());
        this.receivedResponseAtMillis = Long.parseLong(source.readUtf8LineStrict());
        this.isTls = Integer.parseInt(source.readUtf8LineStrict()) > 0;
        int responseHeadersLineCount = Integer.parseInt(source.readUtf8LineStrict());
        Headers.Builder responseHeaders = new Headers.Builder();
        for (int i = 0; i < responseHeadersLineCount; ++i) {
            -Utils.addUnsafeNonAscii(responseHeaders, source.readUtf8LineStrict());
        }
        this.responseHeaders = responseHeaders.build();
    }

    public CacheResponse(@NotNull Response response) {
        this.sentRequestAtMillis = response.sentRequestAtMillis();
        this.receivedResponseAtMillis = response.receivedResponseAtMillis();
        this.isTls = response.handshake() != null;
        this.responseHeaders = response.headers();
    }

    public final void writeTo(@NotNull BufferedSink sink) {
        sink.writeDecimalLong(this.sentRequestAtMillis).writeByte(10);
        sink.writeDecimalLong(this.receivedResponseAtMillis).writeByte(10);
        sink.writeDecimalLong(this.isTls ? 1L : 0L).writeByte(10);
        sink.writeDecimalLong((long)this.responseHeaders.size()).writeByte(10);
        int n = this.responseHeaders.size();
        for (int i = 0; i < n; ++i) {
            sink.writeUtf8(this.responseHeaders.name(i)).writeUtf8(": ").writeUtf8(this.responseHeaders.value(i)).writeByte(10);
        }
    }

    private static final CacheControl cacheControl_delegate$lambda$0(CacheResponse this$0) {
        return CacheControl.Companion.parse(this$0.responseHeaders);
    }

    private static final MediaType contentType_delegate$lambda$1(CacheResponse this$0) {
        String string = this$0.responseHeaders.get("Content-Type");
        return string != null ? MediaType.Companion.parse(string) : null;
    }
}

