/*
 * Decompiled with CFR 0.152.
 */
package coil.fetch;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.TypedValue;
import android.webkit.MimeTypeMap;
import coil.ImageLoader;
import coil.decode.DataSource;
import coil.decode.ImageSource;
import coil.decode.ImageSources;
import coil.decode.ResourceMetadata;
import coil.fetch.DrawableResult;
import coil.fetch.FetchResult;
import coil.fetch.Fetcher;
import coil.fetch.SourceResult;
import coil.request.Options;
import coil.util.-Contexts;
import coil.util.-Utils;
import coil.util.DrawableUtils;
import java.io.InputStream;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0002\r\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcoil/fetch/ResourceUriFetcher;", "Lcoil/fetch/Fetcher;", "data", "Landroid/net/Uri;", "options", "Lcoil/request/Options;", "<init>", "(Landroid/net/Uri;Lcoil/request/Options;)V", "fetch", "Lcoil/fetch/FetchResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "throwInvalidUriException", "", "Factory", "Companion", "coil-base_release"})
@SourceDebugExtension(value={"SMAP\nResourceUriFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceUriFetcher.kt\ncoil/fetch/ResourceUriFetcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Bitmaps.kt\ncoil/util/-Bitmaps\n+ 4 BitmapDrawable.kt\nandroidx/core/graphics/drawable/BitmapDrawableKt\n*L\n1#1,100:1\n1#2:101\n50#3:102\n28#4:103\n*S KotlinDebug\n*F\n+ 1 ResourceUriFetcher.kt\ncoil/fetch/ResourceUriFetcher\n*L\n58#1:102\n58#1:103\n*E\n"})
public final class ResourceUriFetcher
implements Fetcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Uri data;
    @NotNull
    private final Options options;
    @NotNull
    private static final String MIME_TYPE_XML = "text/xml";

    public ResourceUriFetcher(@NotNull Uri data, @NotNull Options options) {
        this.data = data;
        this.options = options;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object fetch(@NotNull Continuation<? super FetchResult> $completion) {
        FetchResult fetchResult;
        String string;
        block9: {
            block8: {
                String string2;
                string = this.data.getAuthority();
                if (string == null) break block8;
                String it = string2 = string;
                boolean bl = false;
                string = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
                if (string != null) break block9;
            }
            this.throwInvalidUriException(this.data);
            throw new KotlinNothingValueException();
        }
        String packageName = string;
        Object object = (String)CollectionsKt.lastOrNull((List)this.data.getPathSegments());
        if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
            this.throwInvalidUriException(this.data);
            throw new KotlinNothingValueException();
        }
        int resId = (Integer)object;
        Context context = this.options.getContext();
        Resources resources = Intrinsics.areEqual((Object)packageName, (Object)context.getPackageName()) ? context.getResources() : context.getPackageManager().getResourcesForApplication(packageName);
        TypedValue bl = new TypedValue();
        Object $this$fetch_u24lambda_u241 = bl;
        int n = 0;
        resources.getValue(resId, (TypedValue)$this$fetch_u24lambda_u241, true);
        CharSequence path = bl.string;
        $this$fetch_u24lambda_u241 = path;
        n = StringsKt.lastIndexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null);
        int n2 = $this$fetch_u24lambda_u241.length();
        String entryName = ((Object)$this$fetch_u24lambda_u241.subSequence(n, n2)).toString();
        String mimeType = -Utils.getMimeTypeFromUrl(MimeTypeMap.getSingleton(), entryName);
        if (Intrinsics.areEqual((Object)mimeType, (Object)MIME_TYPE_XML)) {
            Drawable drawable;
            Drawable drawable2 = Intrinsics.areEqual((Object)packageName, (Object)context.getPackageName()) ? -Contexts.getDrawableCompat(context, resId) : -Contexts.getXmlDrawableCompat(context, resources, resId);
            boolean isVector = -Utils.isVector(drawable2);
            if (isVector) {
                void $this$toDrawable$iv$iv;
                void $this$toDrawable$iv;
                Bitmap bitmap = DrawableUtils.INSTANCE.convertToBitmap(drawable2, this.options.getConfig(), this.options.getSize(), this.options.getScale(), this.options.getAllowInexactSize());
                boolean $i$f$toDrawable = false;
                void var13_17 = $this$toDrawable$iv;
                Resources resources$iv$iv = context.getResources();
                boolean $i$f$toDrawable2 = false;
                drawable = (Drawable)new BitmapDrawable(resources$iv$iv, (Bitmap)$this$toDrawable$iv$iv);
            } else {
                drawable = drawable2;
            }
            fetchResult = new DrawableResult(drawable, isVector, DataSource.DISK);
        } else {
            TypedValue typedValue = new TypedValue();
            InputStream inputStream = resources.openRawResource(resId, typedValue);
            fetchResult = new SourceResult(ImageSources.create(Okio.buffer((Source)Okio.source((InputStream)inputStream)), context, (ImageSource.Metadata)new ResourceMetadata(packageName, resId, typedValue.density)), mimeType, DataSource.DISK);
        }
        return fetchResult;
    }

    private final Void throwInvalidUriException(Uri data) {
        throw new IllegalStateException("Invalid android.resource URI: " + data);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcoil/fetch/ResourceUriFetcher$Companion;", "", "<init>", "()V", "MIME_TYPE_XML", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a8\u0006\u000e"}, d2={"Lcoil/fetch/ResourceUriFetcher$Factory;", "Lcoil/fetch/Fetcher$Factory;", "Landroid/net/Uri;", "<init>", "()V", "create", "Lcoil/fetch/Fetcher;", "data", "options", "Lcoil/request/Options;", "imageLoader", "Lcoil/ImageLoader;", "isApplicable", "", "coil-base_release"})
    public static final class Factory
    implements Fetcher.Factory<Uri> {
        @Override
        @Nullable
        public Fetcher create(@NotNull Uri data, @NotNull Options options, @NotNull ImageLoader imageLoader) {
            if (!this.isApplicable(data)) {
                return null;
            }
            return new ResourceUriFetcher(data, options);
        }

        private final boolean isApplicable(Uri data) {
            return Intrinsics.areEqual((Object)data.getScheme(), (Object)"android.resource");
        }
    }
}

