/*
 * Decompiled with CFR 0.152.
 */
package coil;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import coil.ComponentRegistry;
import coil.EventListener;
import coil.RealImageLoader;
import coil.decode.ExifOrientationPolicy;
import coil.disk.DiskCache;
import coil.memory.MemoryCache;
import coil.request.CachePolicy;
import coil.request.DefaultRequestOptions;
import coil.request.Disposable;
import coil.request.ImageRequest;
import coil.request.ImageResult;
import coil.size.Precision;
import coil.transition.CrossfadeTransition;
import coil.transition.Transition;
import coil.util.-Contexts;
import coil.util.-Requests;
import coil.util.-Utils;
import coil.util.ImageLoaderOptions;
import coil.util.Logger;
import coil.util.SingletonDiskCache;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\u001dJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u00a6@\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH&J\b\u0010\u001b\u001a\u00020\u001cH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u0004\u0018\u00010\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001e\u00c0\u0006\u0001"}, d2={"Lcoil/ImageLoader;", "", "defaults", "Lcoil/request/DefaultRequestOptions;", "getDefaults", "()Lcoil/request/DefaultRequestOptions;", "components", "Lcoil/ComponentRegistry;", "getComponents", "()Lcoil/ComponentRegistry;", "memoryCache", "Lcoil/memory/MemoryCache;", "getMemoryCache", "()Lcoil/memory/MemoryCache;", "diskCache", "Lcoil/disk/DiskCache;", "getDiskCache", "()Lcoil/disk/DiskCache;", "enqueue", "Lcoil/request/Disposable;", "request", "Lcoil/request/ImageRequest;", "execute", "Lcoil/request/ImageResult;", "(Lcoil/request/ImageRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shutdown", "", "newBuilder", "Lcoil/ImageLoader$Builder;", "Builder", "coil-base_release"})
public interface ImageLoader {
    @NotNull
    public DefaultRequestOptions getDefaults();

    @NotNull
    public ComponentRegistry getComponents();

    @Nullable
    public MemoryCache getMemoryCache();

    @Nullable
    public DiskCache getDiskCache();

    @NotNull
    public Disposable enqueue(@NotNull ImageRequest var1);

    @Nullable
    public Object execute(@NotNull ImageRequest var1, @NotNull Continuation<? super ImageResult> var2);

    public void shutdown();

    @NotNull
    public Builder newBuilder();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u0014\u0010\u001b\u001a\u00020\u00002\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001eJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\u0011\u001a\u00020\u00002\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u001eJ\"\u0010\u001f\u001a\u00020\u00002\u0017\u0010 \u001a\u0013\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!\u00a2\u0006\u0002\b$H\u0086\bJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0016J\u0010\u0010\f\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u000eJ\u0016\u0010\f\u001a\u00020\u00002\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u001eJ\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0016\u0010\u000f\u001a\u00020\u00002\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u001eJ\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u000204J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u0014J\u000e\u00106\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'J\u000e\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020.J\u000e\u00108\u001a\u00020\u00002\u0006\u00105\u001a\u000209J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010:\u001a\u00020;J\u000e\u0010<\u001a\u00020\u00002\u0006\u0010<\u001a\u00020=J\u000e\u0010>\u001a\u00020\u00002\u0006\u0010>\u001a\u00020?J\u000e\u0010@\u001a\u00020\u00002\u0006\u0010>\u001a\u00020?J\u000e\u0010A\u001a\u00020\u00002\u0006\u0010>\u001a\u00020?J\u000e\u0010B\u001a\u00020\u00002\u0006\u0010>\u001a\u00020?J\u000e\u0010C\u001a\u00020\u00002\u0006\u0010>\u001a\u00020?J\u0010\u0010D\u001a\u00020\u00002\b\b\u0001\u0010E\u001a\u00020.J\u0010\u0010D\u001a\u00020\u00002\b\u0010F\u001a\u0004\u0018\u00010GJ\u0010\u0010H\u001a\u00020\u00002\b\b\u0001\u0010E\u001a\u00020.J\u0010\u0010H\u001a\u00020\u00002\b\u0010F\u001a\u0004\u0018\u00010GJ\u0010\u0010I\u001a\u00020\u00002\b\b\u0001\u0010E\u001a\u00020.J\u0010\u0010I\u001a\u00020\u00002\b\u0010F\u001a\u0004\u0018\u00010GJ\u000e\u0010J\u001a\u00020\u00002\u0006\u00100\u001a\u00020KJ\u000e\u0010L\u001a\u00020\u00002\u0006\u00100\u001a\u00020KJ\u000e\u0010M\u001a\u00020\u00002\u0006\u00100\u001a\u00020KJ\u0010\u0010\u0019\u001a\u00020\u00002\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0006\u0010N\u001a\u00020OJ\u0012\u0010P\u001a\u00020\u00002\b\b\u0001\u0010Q\u001a\u00020RH\u0007J\u0010\u0010S\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'H\u0007J\u0010\u0010T\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'H\u0007J!\u0010\u0015\u001a\u00020\u00002\u0017\u0010 \u001a\u0013\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!\u00a2\u0006\u0002\b$H\u0007J\u0010\u0010\u0015\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\u0016H\u0007J\u0010\u0010V\u001a\u00020\u00002\u0006\u0010V\u001a\u00020WH\u0007R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lcoil/ImageLoader$Builder;", "", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "imageLoader", "Lcoil/RealImageLoader;", "(Lcoil/RealImageLoader;)V", "applicationContext", "defaults", "Lcoil/request/DefaultRequestOptions;", "memoryCache", "Lkotlin/Lazy;", "Lcoil/memory/MemoryCache;", "diskCache", "Lcoil/disk/DiskCache;", "callFactory", "Lokhttp3/Call$Factory;", "eventListenerFactory", "Lcoil/EventListener$Factory;", "componentRegistry", "Lcoil/ComponentRegistry;", "options", "Lcoil/util/ImageLoaderOptions;", "logger", "Lcoil/util/Logger;", "okHttpClient", "Lokhttp3/OkHttpClient;", "initializer", "Lkotlin/Function0;", "components", "builder", "Lkotlin/Function1;", "Lcoil/ComponentRegistry$Builder;", "", "Lkotlin/ExtensionFunctionType;", "allowHardware", "enable", "", "allowRgb565", "addLastModifiedToFileCacheKey", "networkObserverEnabled", "respectCacheHeaders", "bitmapFactoryMaxParallelism", "maxParallelism", "", "bitmapFactoryExifOrientationPolicy", "policy", "Lcoil/decode/ExifOrientationPolicy;", "eventListener", "listener", "Lcoil/EventListener;", "factory", "crossfade", "durationMillis", "transitionFactory", "Lcoil/transition/Transition$Factory;", "precision", "Lcoil/size/Precision;", "bitmapConfig", "Landroid/graphics/Bitmap$Config;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "interceptorDispatcher", "fetcherDispatcher", "decoderDispatcher", "transformationDispatcher", "placeholder", "drawableResId", "drawable", "Landroid/graphics/drawable/Drawable;", "error", "fallback", "memoryCachePolicy", "Lcoil/request/CachePolicy;", "diskCachePolicy", "networkCachePolicy", "build", "Lcoil/ImageLoader;", "availableMemoryPercentage", "percent", "", "trackWeakReferences", "launchInterceptorChainOnMainThread", "registry", "transition", "Lcoil/transition/Transition;", "coil-base_release"})
    @SourceDebugExtension(value={"SMAP\nImageLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageLoader.kt\ncoil/ImageLoader$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,595:1\n1#2:596\n*E\n"})
    public static final class Builder {
        @NotNull
        private final Context applicationContext;
        @NotNull
        private DefaultRequestOptions defaults;
        @Nullable
        private Lazy<? extends MemoryCache> memoryCache;
        @Nullable
        private Lazy<? extends DiskCache> diskCache;
        @Nullable
        private Lazy<? extends Call.Factory> callFactory;
        @Nullable
        private EventListener.Factory eventListenerFactory;
        @Nullable
        private ComponentRegistry componentRegistry;
        @NotNull
        private ImageLoaderOptions options;
        @Nullable
        private Logger logger;

        public Builder(@NotNull Context context) {
            this.applicationContext = context.getApplicationContext();
            this.defaults = -Requests.getDEFAULT_REQUEST_OPTIONS();
            this.memoryCache = null;
            this.diskCache = null;
            this.callFactory = null;
            this.eventListenerFactory = null;
            this.componentRegistry = null;
            this.options = new ImageLoaderOptions(false, false, false, 0, null, 31, null);
            this.logger = null;
        }

        public Builder(@NotNull RealImageLoader imageLoader) {
            this.applicationContext = imageLoader.getContext().getApplicationContext();
            this.defaults = imageLoader.getDefaults();
            this.memoryCache = imageLoader.getMemoryCacheLazy();
            this.diskCache = imageLoader.getDiskCacheLazy();
            this.callFactory = imageLoader.getCallFactoryLazy();
            this.eventListenerFactory = imageLoader.getEventListenerFactory();
            this.componentRegistry = imageLoader.getComponentRegistry();
            this.options = imageLoader.getOptions();
            this.logger = imageLoader.getLogger();
        }

        @NotNull
        public final Builder okHttpClient(@NotNull OkHttpClient okHttpClient) {
            return this.callFactory((Call.Factory)okHttpClient);
        }

        @NotNull
        public final Builder okHttpClient(@NotNull Function0<? extends OkHttpClient> initializer) {
            return this.callFactory(initializer);
        }

        @NotNull
        public final Builder callFactory(@NotNull Call.Factory callFactory) {
            Builder builder;
            Builder $this$callFactory_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$callFactory_u24lambda_u240.callFactory = LazyKt.lazyOf((Object)callFactory);
            return builder;
        }

        @NotNull
        public final Builder callFactory(@NotNull Function0<? extends Call.Factory> initializer) {
            Builder builder;
            Builder $this$callFactory_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$callFactory_u24lambda_u241.callFactory = LazyKt.lazy(initializer);
            return builder;
        }

        public final /* synthetic */ Builder components(Function1<? super ComponentRegistry.Builder, Unit> builder) {
            boolean $i$f$components = false;
            ComponentRegistry.Builder builder2 = new ComponentRegistry.Builder();
            builder.invoke((Object)builder2);
            return this.components(builder2.build());
        }

        @NotNull
        public final Builder components(@NotNull ComponentRegistry components) {
            Builder builder;
            Builder $this$components_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$components_u24lambda_u242.componentRegistry = components;
            return builder;
        }

        @NotNull
        public final Builder memoryCache(@Nullable MemoryCache memoryCache) {
            Builder builder;
            Builder $this$memoryCache_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$memoryCache_u24lambda_u243.memoryCache = LazyKt.lazyOf((Object)memoryCache);
            return builder;
        }

        @NotNull
        public final Builder memoryCache(@NotNull Function0<? extends MemoryCache> initializer) {
            Builder builder;
            Builder $this$memoryCache_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$memoryCache_u24lambda_u244.memoryCache = LazyKt.lazy(initializer);
            return builder;
        }

        @NotNull
        public final Builder diskCache(@Nullable DiskCache diskCache) {
            Builder builder;
            Builder $this$diskCache_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$diskCache_u24lambda_u245.diskCache = LazyKt.lazyOf((Object)diskCache);
            return builder;
        }

        @NotNull
        public final Builder diskCache(@NotNull Function0<? extends DiskCache> initializer) {
            Builder builder;
            Builder $this$diskCache_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$diskCache_u24lambda_u246.diskCache = LazyKt.lazy(initializer);
            return builder;
        }

        @NotNull
        public final Builder allowHardware(boolean enable) {
            Builder builder;
            Builder $this$allowHardware_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$allowHardware_u24lambda_u247.defaults = DefaultRequestOptions.copy$default($this$allowHardware_u24lambda_u247.defaults, null, null, null, null, null, null, null, enable, false, null, null, null, null, null, null, 32639, null);
            return builder;
        }

        @NotNull
        public final Builder allowRgb565(boolean enable) {
            Builder builder;
            Builder $this$allowRgb565_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$allowRgb565_u24lambda_u248.defaults = DefaultRequestOptions.copy$default($this$allowRgb565_u24lambda_u248.defaults, null, null, null, null, null, null, null, false, enable, null, null, null, null, null, null, 32511, null);
            return builder;
        }

        @NotNull
        public final Builder addLastModifiedToFileCacheKey(boolean enable) {
            Builder builder;
            Builder $this$addLastModifiedToFileCacheKey_u24lambda_u249 = builder = this;
            boolean bl = false;
            $this$addLastModifiedToFileCacheKey_u24lambda_u249.options = ImageLoaderOptions.copy$default($this$addLastModifiedToFileCacheKey_u24lambda_u249.options, enable, false, false, 0, null, 30, null);
            return builder;
        }

        @NotNull
        public final Builder networkObserverEnabled(boolean enable) {
            Builder builder;
            Builder $this$networkObserverEnabled_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$networkObserverEnabled_u24lambda_u2410.options = ImageLoaderOptions.copy$default($this$networkObserverEnabled_u24lambda_u2410.options, false, enable, false, 0, null, 29, null);
            return builder;
        }

        @NotNull
        public final Builder respectCacheHeaders(boolean enable) {
            Builder builder;
            Builder $this$respectCacheHeaders_u24lambda_u2411 = builder = this;
            boolean bl = false;
            $this$respectCacheHeaders_u24lambda_u2411.options = ImageLoaderOptions.copy$default($this$respectCacheHeaders_u24lambda_u2411.options, false, false, enable, 0, null, 27, null);
            return builder;
        }

        @NotNull
        public final Builder bitmapFactoryMaxParallelism(int maxParallelism) {
            Builder builder;
            Builder $this$bitmapFactoryMaxParallelism_u24lambda_u2413 = builder = this;
            boolean bl = false;
            if (!(maxParallelism > 0)) {
                boolean bl2 = false;
                String string = "maxParallelism must be > 0.";
                throw new IllegalArgumentException(string.toString());
            }
            $this$bitmapFactoryMaxParallelism_u24lambda_u2413.options = ImageLoaderOptions.copy$default($this$bitmapFactoryMaxParallelism_u24lambda_u2413.options, false, false, false, maxParallelism, null, 23, null);
            return builder;
        }

        @NotNull
        public final Builder bitmapFactoryExifOrientationPolicy(@NotNull ExifOrientationPolicy policy) {
            Builder builder;
            Builder $this$bitmapFactoryExifOrientationPolicy_u24lambda_u2414 = builder = this;
            boolean bl = false;
            $this$bitmapFactoryExifOrientationPolicy_u24lambda_u2414.options = ImageLoaderOptions.copy$default($this$bitmapFactoryExifOrientationPolicy_u24lambda_u2414.options, false, false, false, 0, policy, 15, null);
            return builder;
        }

        @NotNull
        public final Builder eventListener(@NotNull EventListener listener2) {
            return this.eventListenerFactory(arg_0 -> Builder.eventListener$lambda$15(listener2, arg_0));
        }

        @NotNull
        public final Builder eventListenerFactory(@NotNull EventListener.Factory factory) {
            Builder builder;
            Builder $this$eventListenerFactory_u24lambda_u2416 = builder = this;
            boolean bl = false;
            $this$eventListenerFactory_u24lambda_u2416.eventListenerFactory = factory;
            return builder;
        }

        @NotNull
        public final Builder crossfade(boolean enable) {
            return this.crossfade(enable ? 100 : 0);
        }

        @NotNull
        public final Builder crossfade(int durationMillis) {
            Builder builder;
            Builder $this$crossfade_u24lambda_u2417 = builder = this;
            boolean bl = false;
            Transition.Factory factory = durationMillis > 0 ? (Transition.Factory)new CrossfadeTransition.Factory(durationMillis, false, 2, null) : Transition.Factory.NONE;
            $this$crossfade_u24lambda_u2417.transitionFactory(factory);
            return builder;
        }

        @NotNull
        public final Builder transitionFactory(@NotNull Transition.Factory factory) {
            Builder builder;
            Builder $this$transitionFactory_u24lambda_u2418 = builder = this;
            boolean bl = false;
            $this$transitionFactory_u24lambda_u2418.defaults = DefaultRequestOptions.copy$default($this$transitionFactory_u24lambda_u2418.defaults, null, null, null, null, factory, null, null, false, false, null, null, null, null, null, null, 32751, null);
            return builder;
        }

        @NotNull
        public final Builder precision(@NotNull Precision precision) {
            Builder builder;
            Builder $this$precision_u24lambda_u2419 = builder = this;
            boolean bl = false;
            $this$precision_u24lambda_u2419.defaults = DefaultRequestOptions.copy$default($this$precision_u24lambda_u2419.defaults, null, null, null, null, null, precision, null, false, false, null, null, null, null, null, null, 32735, null);
            return builder;
        }

        @NotNull
        public final Builder bitmapConfig(@NotNull Bitmap.Config bitmapConfig) {
            Builder builder;
            Builder $this$bitmapConfig_u24lambda_u2420 = builder = this;
            boolean bl = false;
            $this$bitmapConfig_u24lambda_u2420.defaults = DefaultRequestOptions.copy$default($this$bitmapConfig_u24lambda_u2420.defaults, null, null, null, null, null, null, bitmapConfig, false, false, null, null, null, null, null, null, 32703, null);
            return builder;
        }

        @NotNull
        public final Builder dispatcher(@NotNull CoroutineDispatcher dispatcher) {
            Builder builder;
            Builder $this$dispatcher_u24lambda_u2421 = builder = this;
            boolean bl = false;
            $this$dispatcher_u24lambda_u2421.defaults = DefaultRequestOptions.copy$default($this$dispatcher_u24lambda_u2421.defaults, null, dispatcher, dispatcher, dispatcher, null, null, null, false, false, null, null, null, null, null, null, 32753, null);
            return builder;
        }

        @NotNull
        public final Builder interceptorDispatcher(@NotNull CoroutineDispatcher dispatcher) {
            Builder builder;
            Builder $this$interceptorDispatcher_u24lambda_u2422 = builder = this;
            boolean bl = false;
            $this$interceptorDispatcher_u24lambda_u2422.defaults = DefaultRequestOptions.copy$default($this$interceptorDispatcher_u24lambda_u2422.defaults, dispatcher, null, null, null, null, null, null, false, false, null, null, null, null, null, null, 32766, null);
            return builder;
        }

        @NotNull
        public final Builder fetcherDispatcher(@NotNull CoroutineDispatcher dispatcher) {
            Builder builder;
            Builder $this$fetcherDispatcher_u24lambda_u2423 = builder = this;
            boolean bl = false;
            $this$fetcherDispatcher_u24lambda_u2423.defaults = DefaultRequestOptions.copy$default($this$fetcherDispatcher_u24lambda_u2423.defaults, null, dispatcher, null, null, null, null, null, false, false, null, null, null, null, null, null, 32765, null);
            return builder;
        }

        @NotNull
        public final Builder decoderDispatcher(@NotNull CoroutineDispatcher dispatcher) {
            Builder builder;
            Builder $this$decoderDispatcher_u24lambda_u2424 = builder = this;
            boolean bl = false;
            $this$decoderDispatcher_u24lambda_u2424.defaults = DefaultRequestOptions.copy$default($this$decoderDispatcher_u24lambda_u2424.defaults, null, null, dispatcher, null, null, null, null, false, false, null, null, null, null, null, null, 32763, null);
            return builder;
        }

        @NotNull
        public final Builder transformationDispatcher(@NotNull CoroutineDispatcher dispatcher) {
            Builder builder;
            Builder $this$transformationDispatcher_u24lambda_u2425 = builder = this;
            boolean bl = false;
            $this$transformationDispatcher_u24lambda_u2425.defaults = DefaultRequestOptions.copy$default($this$transformationDispatcher_u24lambda_u2425.defaults, null, null, null, dispatcher, null, null, null, false, false, null, null, null, null, null, null, 32759, null);
            return builder;
        }

        @NotNull
        public final Builder placeholder(@DrawableRes int drawableResId) {
            return this.placeholder(-Contexts.getDrawableCompat(this.applicationContext, drawableResId));
        }

        @NotNull
        public final Builder placeholder(@Nullable Drawable drawable) {
            Builder builder;
            Builder $this$placeholder_u24lambda_u2426 = builder = this;
            boolean bl = false;
            Drawable drawable2 = drawable;
            $this$placeholder_u24lambda_u2426.defaults = DefaultRequestOptions.copy$default($this$placeholder_u24lambda_u2426.defaults, null, null, null, null, null, null, null, false, false, (Drawable)(drawable2 != null ? drawable2.mutate() : null), null, null, null, null, null, 32255, null);
            return builder;
        }

        @NotNull
        public final Builder error(@DrawableRes int drawableResId) {
            return this.error(-Contexts.getDrawableCompat(this.applicationContext, drawableResId));
        }

        @NotNull
        public final Builder error(@Nullable Drawable drawable) {
            Builder builder;
            Builder $this$error_u24lambda_u2427 = builder = this;
            boolean bl = false;
            Drawable drawable2 = drawable;
            $this$error_u24lambda_u2427.defaults = DefaultRequestOptions.copy$default($this$error_u24lambda_u2427.defaults, null, null, null, null, null, null, null, false, false, null, (Drawable)(drawable2 != null ? drawable2.mutate() : null), null, null, null, null, 31743, null);
            return builder;
        }

        @NotNull
        public final Builder fallback(@DrawableRes int drawableResId) {
            return this.fallback(-Contexts.getDrawableCompat(this.applicationContext, drawableResId));
        }

        @NotNull
        public final Builder fallback(@Nullable Drawable drawable) {
            Builder builder;
            Builder $this$fallback_u24lambda_u2428 = builder = this;
            boolean bl = false;
            Drawable drawable2 = drawable;
            $this$fallback_u24lambda_u2428.defaults = DefaultRequestOptions.copy$default($this$fallback_u24lambda_u2428.defaults, null, null, null, null, null, null, null, false, false, null, null, (Drawable)(drawable2 != null ? drawable2.mutate() : null), null, null, null, 30719, null);
            return builder;
        }

        @NotNull
        public final Builder memoryCachePolicy(@NotNull CachePolicy policy) {
            Builder builder;
            Builder $this$memoryCachePolicy_u24lambda_u2429 = builder = this;
            boolean bl = false;
            $this$memoryCachePolicy_u24lambda_u2429.defaults = DefaultRequestOptions.copy$default($this$memoryCachePolicy_u24lambda_u2429.defaults, null, null, null, null, null, null, null, false, false, null, null, null, policy, null, null, 28671, null);
            return builder;
        }

        @NotNull
        public final Builder diskCachePolicy(@NotNull CachePolicy policy) {
            Builder builder;
            Builder $this$diskCachePolicy_u24lambda_u2430 = builder = this;
            boolean bl = false;
            $this$diskCachePolicy_u24lambda_u2430.defaults = DefaultRequestOptions.copy$default($this$diskCachePolicy_u24lambda_u2430.defaults, null, null, null, null, null, null, null, false, false, null, null, null, null, policy, null, 24575, null);
            return builder;
        }

        @NotNull
        public final Builder networkCachePolicy(@NotNull CachePolicy policy) {
            Builder builder;
            Builder $this$networkCachePolicy_u24lambda_u2431 = builder = this;
            boolean bl = false;
            $this$networkCachePolicy_u24lambda_u2431.defaults = DefaultRequestOptions.copy$default($this$networkCachePolicy_u24lambda_u2431.defaults, null, null, null, null, null, null, null, false, false, null, null, null, null, null, policy, 16383, null);
            return builder;
        }

        @NotNull
        public final Builder logger(@Nullable Logger logger) {
            Builder builder;
            Builder $this$logger_u24lambda_u2432 = builder = this;
            boolean bl = false;
            $this$logger_u24lambda_u2432.logger = logger;
            return builder;
        }

        @NotNull
        public final ImageLoader build() {
            ComponentRegistry componentRegistry;
            EventListener.Factory factory;
            Lazy lazy;
            Lazy lazy2;
            Lazy lazy3 = this.memoryCache;
            if (lazy3 == null) {
                lazy3 = LazyKt.lazy(() -> Builder.build$lambda$33(this));
            }
            if ((lazy2 = this.diskCache) == null) {
                lazy2 = LazyKt.lazy(() -> Builder.build$lambda$34(this));
            }
            if ((lazy = this.callFactory) == null) {
                lazy = LazyKt.lazy(Builder::build$lambda$35);
            }
            if ((factory = this.eventListenerFactory) == null) {
                factory = EventListener.Factory.NONE;
            }
            if ((componentRegistry = this.componentRegistry) == null) {
                componentRegistry = new ComponentRegistry();
            }
            return new RealImageLoader(this.applicationContext, this.defaults, (Lazy<? extends MemoryCache>)lazy3, (Lazy<? extends DiskCache>)lazy2, (Lazy<? extends Call.Factory>)lazy, factory, componentRegistry, this.options, this.logger);
        }

        @Deprecated(message="Migrate to 'memoryCache'.", replaceWith=@ReplaceWith(expression="memoryCache { MemoryCache.Builder(context).maxSizePercent(percent).build() }", imports={"coil.memory.MemoryCache"}), level=DeprecationLevel.ERROR)
        @NotNull
        public final Builder availableMemoryPercentage(@FloatRange(from=0.0, to=1.0) double percent) {
            -Utils.unsupported();
            throw new KotlinNothingValueException();
        }

        @Deprecated(message="Migrate to 'memoryCache'.", replaceWith=@ReplaceWith(expression="memoryCache { MemoryCache.Builder(context).weakReferencesEnabled(enable).build() }", imports={"coil.memory.MemoryCache"}), level=DeprecationLevel.ERROR)
        @NotNull
        public final Builder trackWeakReferences(boolean enable) {
            -Utils.unsupported();
            throw new KotlinNothingValueException();
        }

        @Deprecated(message="Migrate to 'interceptorDispatcher'.", replaceWith=@ReplaceWith(expression="interceptorDispatcher(if (enable) Dispatchers.Main.immediate else Dispatchers.IO)", imports={"kotlinx.coroutines.Dispatchers"}), level=DeprecationLevel.ERROR)
        @NotNull
        public final Builder launchInterceptorChainOnMainThread(boolean enable) {
            -Utils.unsupported();
            throw new KotlinNothingValueException();
        }

        @Deprecated(message="Replace with 'components'.", replaceWith=@ReplaceWith(expression="components(builder)", imports={}), level=DeprecationLevel.ERROR)
        public final /* synthetic */ Builder componentRegistry(Function1 builder) {
            -Utils.unsupported();
            throw new KotlinNothingValueException();
        }

        @Deprecated(message="Replace with 'components'.", replaceWith=@ReplaceWith(expression="components(registry)", imports={}), level=DeprecationLevel.ERROR)
        @NotNull
        public final Builder componentRegistry(@NotNull ComponentRegistry registry) {
            -Utils.unsupported();
            throw new KotlinNothingValueException();
        }

        @Deprecated(message="Migrate to 'transitionFactory'.", replaceWith=@ReplaceWith(expression="transitionFactory { _, _ -> transition }", imports={}), level=DeprecationLevel.ERROR)
        @NotNull
        public final Builder transition(@NotNull Transition transition) {
            -Utils.unsupported();
            throw new KotlinNothingValueException();
        }

        private static final EventListener eventListener$lambda$15(EventListener $listener, ImageRequest it) {
            return $listener;
        }

        private static final MemoryCache build$lambda$33(Builder this$0) {
            return new MemoryCache.Builder(this$0.applicationContext).build();
        }

        private static final DiskCache build$lambda$34(Builder this$0) {
            return SingletonDiskCache.INSTANCE.get(this$0.applicationContext);
        }

        private static final OkHttpClient build$lambda$35() {
            return new OkHttpClient();
        }
    }
}

