/*
 * Decompiled with CFR 0.152.
 */
package coil.network;

import coil.util.-Utils;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Response;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019\u00a8\u0006$"}, d2={"Lcoil/network/CacheResponse;", "", "source", "Lokio/BufferedSource;", "(Lokio/BufferedSource;)V", "response", "Lokhttp3/Response;", "(Lokhttp3/Response;)V", "cacheControl", "Lokhttp3/CacheControl;", "getCacheControl", "()Lokhttp3/CacheControl;", "cacheControl$delegate", "Lkotlin/Lazy;", "contentType", "Lokhttp3/MediaType;", "getContentType", "()Lokhttp3/MediaType;", "contentType$delegate", "isTls", "", "()Z", "receivedResponseAtMillis", "", "getReceivedResponseAtMillis", "()J", "responseHeaders", "Lokhttp3/Headers;", "getResponseHeaders", "()Lokhttp3/Headers;", "sentRequestAtMillis", "getSentRequestAtMillis", "writeTo", "", "sink", "Lokio/BufferedSink;", "coil-base_release"})
public final class CacheResponse {
    @NotNull
    private final Lazy cacheControl$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<CacheControl>(this){
        final /* synthetic */ CacheResponse this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final CacheControl invoke() {
            return CacheControl.Companion.parse(this.this$0.getResponseHeaders());
        }
    }));
    @NotNull
    private final Lazy contentType$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<MediaType>(this){
        final /* synthetic */ CacheResponse this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @Nullable
        public final MediaType invoke() {
            String string = this.this$0.getResponseHeaders().get("Content-Type");
            return string != null ? MediaType.Companion.parse(string) : null;
        }
    }));
    private final long sentRequestAtMillis;
    private final long receivedResponseAtMillis;
    private final boolean isTls;
    @NotNull
    private final Headers responseHeaders;

    @NotNull
    public final CacheControl getCacheControl() {
        Lazy lazy = this.cacheControl$delegate;
        return (CacheControl)lazy.getValue();
    }

    @Nullable
    public final MediaType getContentType() {
        Lazy lazy = this.contentType$delegate;
        return (MediaType)lazy.getValue();
    }

    public final long getSentRequestAtMillis() {
        return this.sentRequestAtMillis;
    }

    public final long getReceivedResponseAtMillis() {
        return this.receivedResponseAtMillis;
    }

    public final boolean isTls() {
        return this.isTls;
    }

    @NotNull
    public final Headers getResponseHeaders() {
        return this.responseHeaders;
    }

    public CacheResponse(@NotNull BufferedSource source) {
        this.sentRequestAtMillis = Long.parseLong(source.readUtf8LineStrict());
        this.receivedResponseAtMillis = Long.parseLong(source.readUtf8LineStrict());
        this.isTls = Integer.parseInt(source.readUtf8LineStrict()) > 0;
        int responseHeadersLineCount = Integer.parseInt(source.readUtf8LineStrict());
        Headers.Builder responseHeaders = new Headers.Builder();
        for (int i = 0; i < responseHeadersLineCount; ++i) {
            -Utils.addUnsafeNonAscii(responseHeaders, source.readUtf8LineStrict());
        }
        this.responseHeaders = responseHeaders.build();
    }

    public CacheResponse(@NotNull Response response) {
        this.sentRequestAtMillis = response.sentRequestAtMillis();
        this.receivedResponseAtMillis = response.receivedResponseAtMillis();
        this.isTls = response.handshake() != null;
        this.responseHeaders = response.headers();
    }

    public final void writeTo(@NotNull BufferedSink sink) {
        sink.writeDecimalLong(this.sentRequestAtMillis).writeByte(10);
        sink.writeDecimalLong(this.receivedResponseAtMillis).writeByte(10);
        sink.writeDecimalLong(this.isTls ? 1L : 0L).writeByte(10);
        sink.writeDecimalLong((long)this.responseHeaders.size()).writeByte(10);
        int n = this.responseHeaders.size();
        for (int i = 0; i < n; ++i) {
            sink.writeUtf8(this.responseHeaders.name(i)).writeUtf8(": ").writeUtf8(this.responseHeaders.value(i)).writeByte(10);
        }
    }
}

