/*
 * Decompiled with CFR 0.152.
 */
package coil.disk;

import coil.disk.DiskCache;
import coil.disk.DiskLruCache;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import okio.ByteString;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000  2\u00020\u0001:\u0003 !\"B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0096\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\f\u0010\u001f\u001a\u00020\u001a*\u00020\u001aH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006#"}, d2={"Lcoil/disk/RealDiskCache;", "Lcoil/disk/DiskCache;", "maxSize", "", "directory", "Lokio/Path;", "fileSystem", "Lokio/FileSystem;", "cleanupDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(JLokio/Path;Lokio/FileSystem;Lkotlinx/coroutines/CoroutineDispatcher;)V", "cache", "Lcoil/disk/DiskLruCache;", "getDirectory", "()Lokio/Path;", "getFileSystem", "()Lokio/FileSystem;", "getMaxSize", "()J", "size", "getSize", "clear", "", "edit", "Lcoil/disk/DiskCache$Editor;", "key", "", "get", "Lcoil/disk/DiskCache$Snapshot;", "remove", "", "hash", "Companion", "RealEditor", "RealSnapshot", "coil-base_release"})
@SourceDebugExtension(value={"SMAP\nRealDiskCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealDiskCache.kt\ncoil/disk/RealDiskCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class RealDiskCache
implements DiskCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long maxSize;
    @NotNull
    private final Path directory;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final DiskLruCache cache;
    private static final int ENTRY_METADATA = 0;
    private static final int ENTRY_DATA = 1;

    public RealDiskCache(long maxSize, @NotNull Path directory, @NotNull FileSystem fileSystem2, @NotNull CoroutineDispatcher cleanupDispatcher) {
        this.maxSize = maxSize;
        this.directory = directory;
        this.fileSystem = fileSystem2;
        this.cache = new DiskLruCache(this.getFileSystem(), this.getDirectory(), cleanupDispatcher, this.getMaxSize(), 1, 2);
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    @NotNull
    public Path getDirectory() {
        return this.directory;
    }

    @Override
    @NotNull
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public long getSize() {
        return this.cache.size();
    }

    @Override
    @Nullable
    public DiskCache.Snapshot get(@NotNull String key) {
        RealSnapshot realSnapshot;
        DiskLruCache.Snapshot snapshot = this.cache.get(this.hash(key));
        if (snapshot != null) {
            DiskLruCache.Snapshot p0 = snapshot;
            boolean bl = false;
            realSnapshot = new RealSnapshot(p0);
        } else {
            realSnapshot = null;
        }
        return realSnapshot;
    }

    @Override
    @Nullable
    public DiskCache.Editor edit(@NotNull String key) {
        RealEditor realEditor;
        DiskLruCache.Editor editor = this.cache.edit(this.hash(key));
        if (editor != null) {
            DiskLruCache.Editor p0 = editor;
            boolean bl = false;
            realEditor = new RealEditor(p0);
        } else {
            realEditor = null;
        }
        return realEditor;
    }

    @Override
    public boolean remove(@NotNull String key) {
        return this.cache.remove(this.hash(key));
    }

    @Override
    public void clear() {
        this.cache.evictAll();
    }

    private final String hash(String $this$hash) {
        return ByteString.Companion.encodeUtf8($this$hash).sha256().hex();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcoil/disk/RealDiskCache$Companion;", "", "()V", "ENTRY_DATA", "", "ENTRY_METADATA", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\u0002\u001a\u00060\u0003R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcoil/disk/RealDiskCache$RealEditor;", "Lcoil/disk/DiskCache$Editor;", "editor", "Lcoil/disk/DiskLruCache$Editor;", "Lcoil/disk/DiskLruCache;", "(Lcoil/disk/DiskLruCache$Editor;)V", "data", "Lokio/Path;", "getData", "()Lokio/Path;", "metadata", "getMetadata", "abort", "", "commit", "commitAndGet", "Lcoil/disk/RealDiskCache$RealSnapshot;", "coil-base_release"})
    @SourceDebugExtension(value={"SMAP\nRealDiskCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealDiskCache.kt\ncoil/disk/RealDiskCache$RealEditor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
    private static final class RealEditor
    implements DiskCache.Editor {
        @NotNull
        private final DiskLruCache.Editor editor;

        public RealEditor(@NotNull DiskLruCache.Editor editor) {
            this.editor = editor;
        }

        @Override
        @NotNull
        public Path getMetadata() {
            return this.editor.file(0);
        }

        @Override
        @NotNull
        public Path getData() {
            return this.editor.file(1);
        }

        @Override
        public void commit() {
            this.editor.commit();
        }

        @Override
        @Nullable
        public RealSnapshot commitAndGet() {
            RealSnapshot realSnapshot;
            DiskLruCache.Snapshot snapshot = this.editor.commitAndGet();
            if (snapshot != null) {
                DiskLruCache.Snapshot p0 = snapshot;
                boolean bl = false;
                realSnapshot = new RealSnapshot(p0);
            } else {
                realSnapshot = null;
            }
            return realSnapshot;
        }

        @Override
        public void abort() {
            this.editor.abort();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0012\u0010\u0002\u001a\u00060\u0003R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcoil/disk/RealDiskCache$RealSnapshot;", "Lcoil/disk/DiskCache$Snapshot;", "snapshot", "Lcoil/disk/DiskLruCache$Snapshot;", "Lcoil/disk/DiskLruCache;", "(Lcoil/disk/DiskLruCache$Snapshot;)V", "data", "Lokio/Path;", "getData", "()Lokio/Path;", "metadata", "getMetadata", "close", "", "closeAndEdit", "Lcoil/disk/RealDiskCache$RealEditor;", "coil-base_release"})
    @SourceDebugExtension(value={"SMAP\nRealDiskCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealDiskCache.kt\ncoil/disk/RealDiskCache$RealSnapshot\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
    private static final class RealSnapshot
    implements DiskCache.Snapshot {
        @NotNull
        private final DiskLruCache.Snapshot snapshot;

        public RealSnapshot(@NotNull DiskLruCache.Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        @Override
        @NotNull
        public Path getMetadata() {
            return this.snapshot.file(0);
        }

        @Override
        @NotNull
        public Path getData() {
            return this.snapshot.file(1);
        }

        @Override
        public void close() {
            this.snapshot.close();
        }

        @Override
        @Nullable
        public RealEditor closeAndEdit() {
            RealEditor realEditor;
            DiskLruCache.Editor editor = this.snapshot.closeAndEdit();
            if (editor != null) {
                DiskLruCache.Editor p0 = editor;
                boolean bl = false;
                realEditor = new RealEditor(p0);
            } else {
                realEditor = null;
            }
            return realEditor;
        }
    }
}

