/*
 * Decompiled with CFR 0.152.
 */
package coil.util;

import android.util.Log;
import coil.util.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0003H\u0002J,\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004\u00a8\u0006\u0012"}, d2={"Lcoil/util/DebugLogger;", "Lcoil/util/Logger;", "level", "", "(I)V", "value", "getLevel", "()I", "setLevel", "assertValidLevel", "", "log", "tag", "", "priority", "message", "throwable", "", "coil-base_release"})
public final class DebugLogger
implements Logger {
    private int level;

    @JvmOverloads
    public DebugLogger(int level) {
        this.level = level;
        this.assertValidLevel(level);
    }

    public /* synthetic */ DebugLogger(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        this(n);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int value) {
        this.assertValidLevel(value);
        this.level = value;
    }

    @Override
    public void log(@NotNull String tag, int priority, @Nullable String message, @Nullable Throwable throwable) {
        if (message != null) {
            Log.println((int)priority, (String)tag, (String)message);
        }
        if (throwable != null) {
            StringWriter writer = new StringWriter();
            throwable.printStackTrace(new PrintWriter(writer));
            Log.println((int)priority, (String)tag, (String)writer.toString());
        }
    }

    private final void assertValidLevel(int value) {
        if (!(2 <= value ? value < 8 : false)) {
            boolean bl = false;
            String string = "Invalid log level: " + value;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @JvmOverloads
    public DebugLogger() {
        this(0, 1, null);
    }
}

