/*
 * Decompiled with CFR 0.152.
 */
package coil.drawable;

import android.content.res.ColorStateList;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import coil.decode.DecodeUtils;
import coil.size.Scale;
import java.util.ArrayList;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 X2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001XBC\b\u0007\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\"\u001a\u00020#H\u0016J!\u0010$\u001a\u00020\t2\b\u0010%\u001a\u0004\u0018\u00010\t2\b\u0010&\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\tH\u0016J\n\u0010,\u001a\u0004\u0018\u00010-H\u0016J\b\u0010.\u001a\u00020\tH\u0016J\b\u0010/\u001a\u00020\tH\u0016J\b\u00100\u001a\u00020\tH\u0017J\u0010\u00101\u001a\u00020#2\u0006\u00102\u001a\u00020\u0001H\u0016J\b\u00103\u001a\u00020\u000bH\u0016J\b\u00104\u001a\u00020#H\u0002J\u0010\u00105\u001a\u00020#2\u0006\u00106\u001a\u000207H\u0014J\u0010\u00108\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\tH\u0014J\u0010\u0010:\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020;H\u0014J\u0010\u0010<\u001a\u00020#2\u0006\u0010=\u001a\u00020\u0010H\u0016J \u0010>\u001a\u00020#2\u0006\u00102\u001a\u00020\u00012\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020 H\u0016J\u0010\u0010B\u001a\u00020#2\u0006\u0010C\u001a\u00020\tH\u0016J\u0012\u0010D\u001a\u00020#2\b\u0010E\u001a\u0004\u0018\u00010-H\u0016J\u0010\u0010F\u001a\u00020#2\u0006\u0010G\u001a\u00020\tH\u0016J\u0012\u0010H\u001a\u00020#2\b\u0010I\u001a\u0004\u0018\u00010JH\u0017J\u0012\u0010K\u001a\u00020#2\b\u0010L\u001a\u0004\u0018\u00010MH\u0016J\u0012\u0010N\u001a\u00020#2\b\u0010O\u001a\u0004\u0018\u00010PH\u0016J\b\u0010\u0004\u001a\u00020#H\u0016J\b\u0010Q\u001a\u00020#H\u0016J\u0010\u0010R\u001a\u00020\u000b2\u0006\u0010=\u001a\u00020\u0010H\u0016J\u0018\u0010S\u001a\u00020#2\u0006\u00102\u001a\u00020\u00012\u0006\u0010?\u001a\u00020@H\u0016J\u001d\u0010T\u001a\u00020#2\u0006\u0010U\u001a\u00020\u00012\u0006\u0010V\u001a\u000207H\u0001\u00a2\u0006\u0002\bWR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\"\u0010\u0004\u001a\u0004\u0018\u00010\u00012\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0014R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lcoil/drawable/CrossfadeDrawable;", "Landroid/graphics/drawable/Drawable;", "Landroid/graphics/drawable/Drawable$Callback;", "Landroidx/vectordrawable/graphics/drawable/Animatable2Compat;", "start", "end", "scale", "Lcoil/size/Scale;", "durationMillis", "", "fadeStart", "", "preferExactIntrinsicSize", "(Landroid/graphics/drawable/Drawable;Landroid/graphics/drawable/Drawable;Lcoil/size/Scale;IZZ)V", "callbacks", "", "Landroidx/vectordrawable/graphics/drawable/Animatable2Compat$AnimationCallback;", "getDurationMillis", "()I", "getEnd", "()Landroid/graphics/drawable/Drawable;", "getFadeStart", "()Z", "intrinsicHeight", "intrinsicWidth", "maxAlpha", "getPreferExactIntrinsicSize", "getScale", "()Lcoil/size/Scale;", "<set-?>", "getStart", "startTimeMillis", "", "state", "clearAnimationCallbacks", "", "computeIntrinsicDimension", "startSize", "endSize", "(Ljava/lang/Integer;Ljava/lang/Integer;)I", "draw", "canvas", "Landroid/graphics/Canvas;", "getAlpha", "getColorFilter", "Landroid/graphics/ColorFilter;", "getIntrinsicHeight", "getIntrinsicWidth", "getOpacity", "invalidateDrawable", "who", "isRunning", "markDone", "onBoundsChange", "bounds", "Landroid/graphics/Rect;", "onLevelChange", "level", "onStateChange", "", "registerAnimationCallback", "callback", "scheduleDrawable", "what", "Ljava/lang/Runnable;", "when", "setAlpha", "alpha", "setColorFilter", "colorFilter", "setTint", "tintColor", "setTintBlendMode", "blendMode", "Landroid/graphics/BlendMode;", "setTintList", "tint", "Landroid/content/res/ColorStateList;", "setTintMode", "tintMode", "Landroid/graphics/PorterDuff$Mode;", "stop", "unregisterAnimationCallback", "unscheduleDrawable", "updateBounds", "drawable", "targetBounds", "updateBounds$coil_base_release", "Companion", "coil-base_release"})
public final class CrossfadeDrawable
extends Drawable
implements Drawable.Callback,
Animatable2Compat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Scale scale;
    private final int durationMillis;
    private final boolean fadeStart;
    private final boolean preferExactIntrinsicSize;
    @NotNull
    private final List<Animatable2Compat.AnimationCallback> callbacks;
    private final int intrinsicWidth;
    private final int intrinsicHeight;
    private long startTimeMillis;
    private int maxAlpha;
    private int state;
    @Nullable
    private Drawable start;
    @Nullable
    private final Drawable end;
    private static final int STATE_START = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_DONE = 2;
    public static final int DEFAULT_DURATION = 100;

    @JvmOverloads
    public CrossfadeDrawable(@Nullable Drawable start, @Nullable Drawable end, @NotNull Scale scale, int durationMillis, boolean fadeStart, boolean preferExactIntrinsicSize) {
        this.scale = scale;
        this.durationMillis = durationMillis;
        this.fadeStart = fadeStart;
        this.preferExactIntrinsicSize = preferExactIntrinsicSize;
        this.callbacks = new ArrayList();
        Drawable drawable = start;
        Drawable drawable2 = end;
        this.intrinsicWidth = this.computeIntrinsicDimension(drawable == null ? null : Integer.valueOf(drawable.getIntrinsicWidth()), drawable2 == null ? null : Integer.valueOf(drawable2.getIntrinsicWidth()));
        Drawable drawable3 = start;
        Drawable drawable4 = end;
        this.intrinsicHeight = this.computeIntrinsicDimension(drawable3 == null ? null : Integer.valueOf(drawable3.getIntrinsicHeight()), drawable4 == null ? null : Integer.valueOf(drawable4.getIntrinsicHeight()));
        this.maxAlpha = 255;
        Drawable drawable5 = start;
        this.start = drawable5 == null ? null : drawable5.mutate();
        Drawable drawable6 = end;
        this.end = drawable6 == null ? null : drawable6.mutate();
        if (!(this.durationMillis > 0)) {
            boolean bl = false;
            String string = "durationMillis must be > 0.";
            throw new IllegalArgumentException(string.toString());
        }
        Drawable drawable7 = this.start;
        if (drawable7 != null) {
            drawable7.setCallback((Drawable.Callback)this);
        }
        Drawable drawable8 = this.end;
        if (drawable8 != null) {
            drawable8.setCallback((Drawable.Callback)this);
        }
    }

    public /* synthetic */ CrossfadeDrawable(Drawable drawable, Drawable drawable2, Scale scale, int n, boolean bl, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            scale = Scale.FIT;
        }
        if ((n2 & 8) != 0) {
            n = 100;
        }
        if ((n2 & 0x10) != 0) {
            bl = true;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        this(drawable, drawable2, scale, n, bl, bl2);
    }

    @NotNull
    public final Scale getScale() {
        return this.scale;
    }

    public final int getDurationMillis() {
        return this.durationMillis;
    }

    public final boolean getFadeStart() {
        return this.fadeStart;
    }

    public final boolean getPreferExactIntrinsicSize() {
        return this.preferExactIntrinsicSize;
    }

    @Nullable
    public final Drawable getStart() {
        return this.start;
    }

    @Nullable
    public final Drawable getEnd() {
        return this.end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(@NotNull Canvas canvas) {
        int checkpoint$iv;
        boolean $i$f$withSave;
        Canvas $this$withSave$iv;
        Drawable drawable;
        boolean isDone;
        if (this.state == 0) {
            Drawable drawable2 = this.start;
            if (drawable2 != null) {
                Drawable drawable3;
                Drawable $this$draw_u24lambda_u2d2 = drawable3 = drawable2;
                boolean bl = false;
                $this$draw_u24lambda_u2d2.setAlpha(this.maxAlpha);
                Canvas $this$withSave$iv2 = canvas;
                boolean $i$f$withSave2 = false;
                int checkpoint$iv2 = $this$withSave$iv2.save();
                try {
                    Canvas $this$draw_u24lambda_u2d2_u24lambda_u2d1 = $this$withSave$iv2;
                    boolean bl2 = false;
                    $this$draw_u24lambda_u2d2.draw(canvas);
                }
                finally {
                    $this$withSave$iv2.restoreToCount(checkpoint$iv2);
                }
            }
            return;
        }
        if (this.state == 2) {
            Drawable drawable4 = this.end;
            if (drawable4 != null) {
                Drawable drawable5;
                Drawable $this$draw_u24lambda_u2d4 = drawable5 = drawable4;
                boolean bl = false;
                $this$draw_u24lambda_u2d4.setAlpha(this.maxAlpha);
                Canvas $this$withSave$iv3 = canvas;
                boolean $i$f$withSave3 = false;
                int checkpoint$iv3 = $this$withSave$iv3.save();
                try {
                    Canvas $this$draw_u24lambda_u2d4_u24lambda_u2d3 = $this$withSave$iv3;
                    boolean bl3 = false;
                    $this$draw_u24lambda_u2d4.draw(canvas);
                }
                finally {
                    $this$withSave$iv3.restoreToCount(checkpoint$iv3);
                }
            }
            return;
        }
        double percent = (double)(SystemClock.uptimeMillis() - this.startTimeMillis) / (double)this.durationMillis;
        int endAlpha = (int)(RangesKt.coerceIn((double)percent, (double)0.0, (double)1.0) * (double)this.maxAlpha);
        int startAlpha = this.fadeStart ? this.maxAlpha - endAlpha : this.maxAlpha;
        boolean bl = isDone = percent >= 1.0;
        if (!isDone) {
            Drawable drawable6 = this.start;
            if (drawable6 != null) {
                Drawable $this$draw_u24lambda_u2d6 = drawable = drawable6;
                boolean bl4 = false;
                $this$draw_u24lambda_u2d6.setAlpha(startAlpha);
                $this$withSave$iv = canvas;
                $i$f$withSave = false;
                checkpoint$iv = $this$withSave$iv.save();
                try {
                    Canvas $this$draw_u24lambda_u2d6_u24lambda_u2d5 = $this$withSave$iv;
                    boolean bl5 = false;
                    $this$draw_u24lambda_u2d6.draw(canvas);
                }
                finally {
                    $this$withSave$iv.restoreToCount(checkpoint$iv);
                }
            }
        }
        Drawable drawable7 = this.end;
        if (drawable7 != null) {
            Drawable $this$draw_u24lambda_u2d8 = drawable = drawable7;
            boolean bl6 = false;
            $this$draw_u24lambda_u2d8.setAlpha(endAlpha);
            $this$withSave$iv = canvas;
            $i$f$withSave = false;
            checkpoint$iv = $this$withSave$iv.save();
            try {
                Canvas $this$draw_u24lambda_u2d8_u24lambda_u2d7 = $this$withSave$iv;
                boolean bl7 = false;
                $this$draw_u24lambda_u2d8.draw(canvas);
            }
            finally {
                $this$withSave$iv.restoreToCount(checkpoint$iv);
            }
        }
        if (isDone) {
            this.markDone();
        } else {
            this.invalidateSelf();
        }
    }

    public int getAlpha() {
        return this.maxAlpha;
    }

    public void setAlpha(int alpha) {
        if (!(0 <= alpha ? alpha < 256 : false)) {
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"Invalid alpha: ", (Object)alpha);
            throw new IllegalArgumentException(string.toString());
        }
        this.maxAlpha = alpha;
    }

    @Deprecated(message="Deprecated in Java")
    public int getOpacity() {
        Drawable start = this.start;
        Drawable end = this.end;
        if (this.state == 0) {
            int n;
            Drawable drawable = start;
            return drawable == null ? -2 : (n = drawable.getOpacity());
        }
        if (this.state == 2) {
            int n;
            Drawable drawable = end;
            return drawable == null ? -2 : (n = drawable.getOpacity());
        }
        return start != null && end != null ? Drawable.resolveOpacity((int)start.getOpacity(), (int)end.getOpacity()) : (start != null ? start.getOpacity() : (end != null ? end.getOpacity() : -2));
    }

    @Nullable
    public ColorFilter getColorFilter() {
        Object object;
        switch (this.state) {
            case 0: {
                Drawable drawable = this.start;
                if (drawable == null) {
                    object = null;
                    break;
                }
                object = drawable.getColorFilter();
                break;
            }
            case 1: {
                Drawable drawable = this.end;
                object = drawable == null ? null : drawable.getColorFilter();
                if (object != null) break;
                Drawable drawable2 = this.start;
                if (drawable2 == null) {
                    object = null;
                    break;
                }
                object = drawable2.getColorFilter();
                break;
            }
            case 2: {
                Drawable drawable = this.end;
                if (drawable == null) {
                    object = null;
                    break;
                }
                object = drawable.getColorFilter();
                break;
            }
            default: {
                object = null;
            }
        }
        return object;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        Drawable drawable = this.start;
        if (drawable != null) {
            drawable.setColorFilter(colorFilter);
        }
        Drawable drawable2 = this.end;
        if (drawable2 != null) {
            drawable2.setColorFilter(colorFilter);
        }
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        Drawable it;
        Drawable drawable = this.start;
        if (drawable != null) {
            it = drawable;
            boolean bl = false;
            this.updateBounds$coil_base_release(it, bounds);
        }
        Drawable drawable2 = this.end;
        if (drawable2 != null) {
            it = drawable2;
            boolean bl = false;
            this.updateBounds$coil_base_release(it, bounds);
        }
    }

    protected boolean onLevelChange(int level) {
        boolean bl;
        boolean bl2;
        Drawable drawable = this.start;
        boolean startChanged = drawable == null ? false : (bl2 = drawable.setLevel(level));
        Drawable drawable2 = this.end;
        boolean endChanged = drawable2 == null ? false : (bl = drawable2.setLevel(level));
        return startChanged || endChanged;
    }

    protected boolean onStateChange(@NotNull int[] state) {
        boolean bl;
        boolean bl2;
        Drawable drawable = this.start;
        boolean startChanged = drawable == null ? false : (bl2 = drawable.setState(state));
        Drawable drawable2 = this.end;
        boolean endChanged = drawable2 == null ? false : (bl = drawable2.setState(state));
        return startChanged || endChanged;
    }

    public int getIntrinsicWidth() {
        return this.intrinsicWidth;
    }

    public int getIntrinsicHeight() {
        return this.intrinsicHeight;
    }

    public void unscheduleDrawable(@NotNull Drawable who, @NotNull Runnable what) {
        this.unscheduleSelf(what);
    }

    public void invalidateDrawable(@NotNull Drawable who) {
        this.invalidateSelf();
    }

    public void scheduleDrawable(@NotNull Drawable who, @NotNull Runnable what, long when) {
        this.scheduleSelf(what, when);
    }

    public void setTint(int tintColor) {
        Drawable drawable = this.start;
        if (drawable != null) {
            drawable.setTint(tintColor);
        }
        Drawable drawable2 = this.end;
        if (drawable2 != null) {
            drawable2.setTint(tintColor);
        }
    }

    public void setTintList(@Nullable ColorStateList tint) {
        Drawable drawable = this.start;
        if (drawable != null) {
            drawable.setTintList(tint);
        }
        Drawable drawable2 = this.end;
        if (drawable2 != null) {
            drawable2.setTintList(tint);
        }
    }

    public void setTintMode(@Nullable PorterDuff.Mode tintMode) {
        Drawable drawable = this.start;
        if (drawable != null) {
            drawable.setTintMode(tintMode);
        }
        Drawable drawable2 = this.end;
        if (drawable2 != null) {
            drawable2.setTintMode(tintMode);
        }
    }

    @RequiresApi(value=29)
    public void setTintBlendMode(@Nullable BlendMode blendMode) {
        Drawable drawable = this.start;
        if (drawable != null) {
            drawable.setTintBlendMode(blendMode);
        }
        Drawable drawable2 = this.end;
        if (drawable2 != null) {
            drawable2.setTintBlendMode(blendMode);
        }
    }

    public boolean isRunning() {
        return this.state == 1;
    }

    public void start() {
        Drawable drawable = this.start;
        Animatable animatable = drawable instanceof Animatable ? (Animatable)drawable : null;
        if (animatable != null) {
            animatable.start();
        }
        drawable = this.end;
        Animatable animatable2 = drawable instanceof Animatable ? (Animatable)drawable : null;
        if (animatable2 != null) {
            animatable2.start();
        }
        if (this.state != 0) {
            return;
        }
        this.state = 1;
        this.startTimeMillis = SystemClock.uptimeMillis();
        List<Animatable2Compat.AnimationCallback> $this$forEachIndices$iv = this.callbacks;
        boolean $i$f$forEachIndices = false;
        int n = 0;
        int n2 = $this$forEachIndices$iv.size();
        while (n < n2) {
            int i$iv = n++;
            Animatable2Compat.AnimationCallback it = $this$forEachIndices$iv.get(i$iv);
            boolean bl = false;
            it.onAnimationStart((Drawable)this);
        }
        this.invalidateSelf();
    }

    public void stop() {
        Drawable drawable = this.start;
        Animatable animatable = drawable instanceof Animatable ? (Animatable)drawable : null;
        if (animatable != null) {
            animatable.stop();
        }
        drawable = this.end;
        Animatable animatable2 = drawable instanceof Animatable ? (Animatable)drawable : null;
        if (animatable2 != null) {
            animatable2.stop();
        }
        if (this.state != 2) {
            this.markDone();
        }
    }

    public void registerAnimationCallback(@NotNull Animatable2Compat.AnimationCallback callback) {
        this.callbacks.add(callback);
    }

    public boolean unregisterAnimationCallback(@NotNull Animatable2Compat.AnimationCallback callback) {
        return this.callbacks.remove(callback);
    }

    public void clearAnimationCallbacks() {
        this.callbacks.clear();
    }

    @VisibleForTesting
    public final void updateBounds$coil_base_release(@NotNull Drawable drawable, @NotNull Rect targetBounds) {
        int width = drawable.getIntrinsicWidth();
        int height = drawable.getIntrinsicHeight();
        if (width <= 0 || height <= 0) {
            drawable.setBounds(targetBounds);
            return;
        }
        int targetWidth = targetBounds.width();
        int targetHeight = targetBounds.height();
        double multiplier = DecodeUtils.computeSizeMultiplier(width, height, targetWidth, targetHeight, this.scale);
        int dx = MathKt.roundToInt((double)(((double)targetWidth - multiplier * (double)width) / (double)2));
        int dy = MathKt.roundToInt((double)(((double)targetHeight - multiplier * (double)height) / (double)2));
        int left = targetBounds.left + dx;
        int top = targetBounds.top + dy;
        int right = targetBounds.right - dx;
        int bottom = targetBounds.bottom - dy;
        drawable.setBounds(left, top, right, bottom);
    }

    private final int computeIntrinsicDimension(Integer startSize, Integer endSize) {
        block2: {
            block3: {
                if (this.preferExactIntrinsicSize) break block2;
                Integer n = startSize;
                int n2 = -1;
                if (n != null && n == n2) break block3;
                Integer n3 = endSize;
                n2 = -1;
                if (n3 == null || n3 != n2) break block2;
            }
            return -1;
        }
        Integer n = startSize;
        Integer n4 = endSize;
        return Math.max(n == null ? -1 : n, n4 == null ? -1 : n4);
    }

    private final void markDone() {
        this.state = 2;
        this.start = null;
        List<Animatable2Compat.AnimationCallback> $this$forEachIndices$iv = this.callbacks;
        boolean $i$f$forEachIndices = false;
        int n = 0;
        int n2 = $this$forEachIndices$iv.size();
        while (n < n2) {
            int i$iv = n++;
            Animatable2Compat.AnimationCallback it = $this$forEachIndices$iv.get(i$iv);
            boolean bl = false;
            it.onAnimationEnd((Drawable)this);
        }
    }

    @JvmOverloads
    public CrossfadeDrawable(@Nullable Drawable start, @Nullable Drawable end, @NotNull Scale scale, int durationMillis, boolean fadeStart) {
        this(start, end, scale, durationMillis, fadeStart, false, 32, null);
    }

    @JvmOverloads
    public CrossfadeDrawable(@Nullable Drawable start, @Nullable Drawable end, @NotNull Scale scale, int durationMillis) {
        this(start, end, scale, durationMillis, false, false, 48, null);
    }

    @JvmOverloads
    public CrossfadeDrawable(@Nullable Drawable start, @Nullable Drawable end, @NotNull Scale scale) {
        this(start, end, scale, 0, false, false, 56, null);
    }

    @JvmOverloads
    public CrossfadeDrawable(@Nullable Drawable start, @Nullable Drawable end) {
        this(start, end, null, 0, false, false, 60, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcoil/drawable/CrossfadeDrawable$Companion;", "", "()V", "DEFAULT_DURATION", "", "STATE_DONE", "STATE_RUNNING", "STATE_START", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

