/*
 * Decompiled with CFR 0.152.
 */
package coil.fetch;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.TypedValue;
import android.webkit.MimeTypeMap;
import coil.ImageLoader;
import coil.decode.DataSource;
import coil.decode.ImageSource;
import coil.decode.ImageSources;
import coil.decode.ResourceMetadata;
import coil.fetch.DrawableResult;
import coil.fetch.FetchResult;
import coil.fetch.Fetcher;
import coil.fetch.SourceResult;
import coil.request.Options;
import coil.util.-Contexts;
import coil.util.-Utils;
import coil.util.DrawableUtils;
import java.io.InputStream;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0002\f\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000e"}, d2={"Lcoil/fetch/ResourceUriFetcher;", "Lcoil/fetch/Fetcher;", "data", "Landroid/net/Uri;", "options", "Lcoil/request/Options;", "(Landroid/net/Uri;Lcoil/request/Options;)V", "fetch", "Lcoil/fetch/FetchResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "throwInvalidUriException", "", "Companion", "Factory", "coil-base_release"})
public final class ResourceUriFetcher
implements Fetcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Uri data;
    @NotNull
    private final Options options;
    @NotNull
    private static final String MIME_TYPE_XML = "text/xml";

    public ResourceUriFetcher(@NotNull Uri data, @NotNull Options options) {
        this.data = data;
        this.options = options;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object fetch(@NotNull Continuation<? super FetchResult> $completion) {
        FetchResult fetchResult;
        String string;
        String string2 = this.data.getAuthority();
        if (string2 == null) {
            string = null;
        } else {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            string = !StringsKt.isBlank((CharSequence)it) ? string3 : null;
        }
        if (string == null) {
            this.throwInvalidUriException(this.data);
            throw new KotlinNothingValueException();
        }
        String packageName = string;
        String string4 = (String)CollectionsKt.lastOrNull((List)this.data.getPathSegments());
        Integer n = string4 == null ? null : StringsKt.toIntOrNull((String)string4);
        if (n == null) {
            this.throwInvalidUriException(this.data);
            throw new KotlinNothingValueException();
        }
        int resId = n;
        Context context = this.options.getContext();
        Resources resources = Intrinsics.areEqual((Object)packageName, (Object)context.getPackageName()) ? context.getResources() : context.getPackageManager().getResourcesForApplication(packageName);
        TypedValue bl = new TypedValue();
        Object $this$fetch_u24lambda_u2d1 = bl;
        int n2 = 0;
        resources.getValue(resId, (TypedValue)$this$fetch_u24lambda_u2d1, true);
        CharSequence path = bl.string;
        $this$fetch_u24lambda_u2d1 = path;
        n2 = StringsKt.lastIndexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null);
        int n3 = $this$fetch_u24lambda_u2d1.length();
        String entryName = ((Object)$this$fetch_u24lambda_u2d1.subSequence(n2, n3)).toString();
        String mimeType = -Utils.getMimeTypeFromUrl(MimeTypeMap.getSingleton(), entryName);
        if (Intrinsics.areEqual((Object)mimeType, (Object)MIME_TYPE_XML)) {
            Drawable drawable;
            Drawable drawable2 = Intrinsics.areEqual((Object)packageName, (Object)context.getPackageName()) ? -Contexts.getDrawableCompat(context, resId) : -Contexts.getXmlDrawableCompat(context, resources, resId);
            boolean isVector = -Utils.isVector(drawable2);
            if (isVector) {
                void $this$toDrawable$iv$iv;
                void $this$toDrawable$iv;
                Bitmap bitmap = DrawableUtils.INSTANCE.convertToBitmap(drawable2, this.options.getConfig(), this.options.getSize(), this.options.getScale(), this.options.getAllowInexactSize());
                boolean $i$f$toDrawable = false;
                void var13_17 = $this$toDrawable$iv;
                Resources resources$iv$iv = context.getResources();
                boolean $i$f$toDrawable2 = false;
                drawable = (Drawable)new BitmapDrawable(resources$iv$iv, (Bitmap)$this$toDrawable$iv$iv);
            } else {
                drawable = drawable2;
            }
            fetchResult = new DrawableResult(drawable, isVector, DataSource.DISK);
        } else {
            TypedValue typedValue = new TypedValue();
            InputStream inputStream = resources.openRawResource(resId, typedValue);
            fetchResult = new SourceResult(ImageSources.create(Okio.buffer((Source)Okio.source((InputStream)inputStream)), context, (ImageSource.Metadata)new ResourceMetadata(packageName, resId, typedValue.density)), mimeType, DataSource.DISK);
        }
        return fetchResult;
    }

    private final Void throwInvalidUriException(Uri data) {
        throw new IllegalStateException(Intrinsics.stringPlus((String)"Invalid android.resource URI: ", (Object)data));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a8\u0006\r"}, d2={"Lcoil/fetch/ResourceUriFetcher$Factory;", "Lcoil/fetch/Fetcher$Factory;", "Landroid/net/Uri;", "()V", "create", "Lcoil/fetch/Fetcher;", "data", "options", "Lcoil/request/Options;", "imageLoader", "Lcoil/ImageLoader;", "isApplicable", "", "coil-base_release"})
    public static final class Factory
    implements Fetcher.Factory<Uri> {
        @Override
        @Nullable
        public Fetcher create(@NotNull Uri data, @NotNull Options options, @NotNull ImageLoader imageLoader) {
            if (!this.isApplicable(data)) {
                return null;
            }
            return new ResourceUriFetcher(data, options);
        }

        private final boolean isApplicable(Uri data) {
            return Intrinsics.areEqual((Object)data.getScheme(), (Object)"android.resource");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcoil/fetch/ResourceUriFetcher$Companion;", "", "()V", "MIME_TYPE_XML", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

