/*
 * Decompiled with CFR 0.152.
 */
package coil.fetch;

import android.net.Uri;
import android.os.NetworkOnMainThreadException;
import android.webkit.MimeTypeMap;
import androidx.annotation.VisibleForTesting;
import coil.ImageLoader;
import coil.decode.DataSource;
import coil.decode.ImageSource;
import coil.decode.ImageSources;
import coil.disk.DiskCache;
import coil.fetch.FetchResult;
import coil.fetch.Fetcher;
import coil.fetch.HttpUriFetcher;
import coil.fetch.SourceResult;
import coil.network.CacheResponse;
import coil.network.CacheStrategy;
import coil.network.HttpException;
import coil.request.Options;
import coil.util.-Calls;
import coil.util.-Utils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 *2\u00020\u0001:\u0002*+B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0019\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0011\u0010\u0016\u001a\u00020\u0017H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J!\u0010\u0019\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0001\u00a2\u0006\u0002\b\u001cJ\u0018\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\b\u0010\u001f\u001a\u00020\u0014H\u0002J\n\u0010 \u001a\u0004\u0018\u00010!H\u0002J.\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010#\u001a\u0004\u0018\u00010!2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00122\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u000e\u0010&\u001a\u0004\u0018\u00010%*\u00020!H\u0002J\f\u0010'\u001a\u00020(*\u00020!H\u0002J\f\u0010'\u001a\u00020(*\u00020)H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006,"}, d2={"Lcoil/fetch/HttpUriFetcher;", "Lcoil/fetch/Fetcher;", "url", "", "options", "Lcoil/request/Options;", "callFactory", "Lkotlin/Lazy;", "Lokhttp3/Call$Factory;", "diskCache", "Lcoil/disk/DiskCache;", "respectCacheHeaders", "", "(Ljava/lang/String;Lcoil/request/Options;Lkotlin/Lazy;Lkotlin/Lazy;Z)V", "diskCacheKey", "getDiskCacheKey", "()Ljava/lang/String;", "executeNetworkRequest", "Lokhttp3/Response;", "request", "Lokhttp3/Request;", "(Lokhttp3/Request;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetch", "Lcoil/fetch/FetchResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMimeType", "contentType", "Lokhttp3/MediaType;", "getMimeType$coil_base_release", "isCacheable", "response", "newRequest", "readFromDiskCache", "Lcoil/disk/DiskCache$Snapshot;", "writeToDiskCache", "snapshot", "cacheResponse", "Lcoil/network/CacheResponse;", "toCacheResponse", "toImageSource", "Lcoil/decode/ImageSource;", "Lokhttp3/ResponseBody;", "Companion", "Factory", "coil-base_release"})
public final class HttpUriFetcher
implements Fetcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private final Options options;
    @NotNull
    private final Lazy<Call.Factory> callFactory;
    @NotNull
    private final Lazy<DiskCache> diskCache;
    private final boolean respectCacheHeaders;
    @NotNull
    private static final String MIME_TYPE_TEXT_PLAIN = "text/plain";
    @NotNull
    private static final CacheControl CACHE_CONTROL_FORCE_NETWORK_NO_CACHE = new CacheControl.Builder().noCache().noStore().build();
    @NotNull
    private static final CacheControl CACHE_CONTROL_NO_NETWORK_NO_CACHE = new CacheControl.Builder().noCache().onlyIfCached().build();

    public HttpUriFetcher(@NotNull String url, @NotNull Options options, @NotNull Lazy<? extends Call.Factory> callFactory, @NotNull Lazy<? extends DiskCache> diskCache, boolean respectCacheHeaders) {
        this.url = url;
        this.options = options;
        this.callFactory = callFactory;
        this.diskCache = diskCache;
        this.respectCacheHeaders = respectCacheHeaders;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object fetch(@NotNull Continuation<? super FetchResult> var1_1) {
        if (!(var1_1 instanceof fetch.1)) ** GOTO lbl-1000
        var10_2 = var1_1;
        if ((var10_2.label & -2147483648) != 0) {
            var10_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ HttpUriFetcher this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.fetch((Continuation<? super FetchResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                snapshot = this.readFromDiskCache();
                if (snapshot == null) ** GOTO lbl25
                if (snapshot.getMetadata().length() == 0L) {
                    return new SourceResult(this.toImageSource(snapshot), this.getMimeType$coil_base_release(this.url, null), DataSource.DISK);
                }
                if (this.respectCacheHeaders) {
                    cacheStrategy = new CacheStrategy.Factory(this.newRequest(), this.toCacheResponse(snapshot)).compute();
                    if (cacheStrategy.getNetworkRequest() == null && cacheStrategy.getCacheResponse() != null) {
                        return new SourceResult(this.toImageSource(snapshot), this.getMimeType$coil_base_release(this.url, cacheStrategy.getCacheResponse().getContentType()), DataSource.DISK);
                    }
                } else {
                    v0 = this.toCacheResponse(snapshot);
                    return new SourceResult(this.toImageSource(snapshot), this.getMimeType$coil_base_release(this.url, (MediaType)(v0 == null ? null : v0.getContentType())), DataSource.DISK);
lbl25:
                    // 1 sources

                    cacheStrategy = new CacheStrategy.Factory(this.newRequest(), null).compute();
                }
                if ((v1 = cacheStrategy.getNetworkRequest()) == null) {
                    v1 = this.newRequest();
                }
                request = v1;
                $continuation.L$0 = this;
                $continuation.L$1 = snapshot;
                $continuation.L$2 = cacheStrategy;
                $continuation.L$3 = request;
                $continuation.label = 1;
                v2 = this.executeNetworkRequest(request, (Continuation<? super Response>)$continuation);
                ** if (v2 != var11_4) goto lbl37
lbl36:
                // 1 sources

                return var11_4;
lbl37:
                // 1 sources

                ** GOTO lbl47
            }
            case 1: {
                request = (Request)$continuation.L$3;
                cacheStrategy = (CacheStrategy)$continuation.L$2;
                snapshot = (DiskCache.Snapshot)$continuation.L$1;
                this = (HttpUriFetcher)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl47:
                    // 2 sources

                    response = (Response)v2;
                    v3 = response.body();
                    if (v3 == null) {
                        $i$a$-checkNotNull-HttpUriFetcher$fetch$responseBody$1 = false;
                        var8_11 = "response body == null";
                        throw new IllegalStateException(var8_11.toString());
                    }
                    responseBody = v3;
                    try {
                        snapshot = this.writeToDiskCache(snapshot, request, response, cacheStrategy.getCacheResponse());
                        if (snapshot != null) {
                            v4 = this.toCacheResponse(snapshot);
                            return new SourceResult(this.toImageSource(snapshot), this.getMimeType$coil_base_release(this.url, (MediaType)(v4 == null ? null : v4.getContentType())), DataSource.NETWORK);
                        }
                        return new SourceResult(this.toImageSource(responseBody), this.getMimeType$coil_base_release(this.url, responseBody.contentType()), response.networkResponse() != null ? DataSource.NETWORK : DataSource.DISK);
                    }
                    catch (Exception e) {
                        -Utils.closeQuietly((Closeable)responseBody);
                        throw e;
                    }
                }
                catch (Exception e) {
                    v5 = var2_5;
                    if (v5 != null) {
                        -Utils.closeQuietly((Closeable)v5);
                    }
                    throw e;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final DiskCache.Snapshot readFromDiskCache() {
        DiskCache.Snapshot snapshot;
        if (this.options.getDiskCachePolicy().getReadEnabled()) {
            DiskCache diskCache = (DiskCache)this.diskCache.getValue();
            snapshot = diskCache == null ? null : diskCache.get(this.getDiskCacheKey());
        } else {
            snapshot = null;
        }
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DiskCache.Snapshot writeToDiskCache(DiskCache.Snapshot snapshot, Request request, Response response, CacheResponse cacheResponse) {
        DiskCache.Editor editor;
        DiskCache.Editor editor2;
        if (!this.isCacheable(request, response)) {
            DiskCache.Snapshot snapshot2 = snapshot;
            if (snapshot2 != null) {
                -Utils.closeQuietly(snapshot2);
            }
            return null;
        }
        if (snapshot != null) {
            editor2 = snapshot.closeAndEdit();
        } else {
            DiskCache diskCache = (DiskCache)this.diskCache.getValue();
            editor2 = editor = diskCache == null ? null : diskCache.edit(this.getDiskCacheKey());
        }
        if (editor == null) {
            return null;
        }
        DiskCache.Editor editor3 = editor;
        try {
            Closeable combinedResponse;
            if (response.code() == 304 && cacheResponse != null) {
                combinedResponse = response.newBuilder().headers(CacheStrategy.Companion.combineHeaders(new CacheResponse(response).getResponseHeaders(), response.headers())).build();
                Closeable closeable = (Closeable)Okio.buffer((Sink)Okio.sink$default((File)editor3.getMetadata(), (boolean)false, (int)1, null));
                Throwable throwable = null;
                try {
                    BufferedSink it = (BufferedSink)closeable;
                    boolean bl = false;
                    new CacheResponse((Response)combinedResponse).writeTo(it);
                    it = Unit.INSTANCE;
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                ResponseBody responseBody = response.body();
                Intrinsics.checkNotNull((Object)responseBody);
                -Utils.closeQuietly((Closeable)responseBody);
            } else {
                BufferedSink it2;
                combinedResponse = (Closeable)Okio.buffer((Sink)Okio.sink$default((File)editor3.getMetadata(), (boolean)false, (int)1, null));
                Throwable throwable = null;
                try {
                    it2 = (BufferedSink)combinedResponse;
                    boolean bl = false;
                    new CacheResponse(response).writeTo(it2);
                    it2 = Unit.INSTANCE;
                }
                catch (Throwable it2) {
                    throwable = it2;
                    throw it2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)combinedResponse, (Throwable)throwable);
                }
                ResponseBody responseBody = response.body();
                Intrinsics.checkNotNull((Object)responseBody);
                combinedResponse = (Closeable)responseBody.source();
                throwable = null;
                try {
                    long l;
                    it2 = (BufferedSource)combinedResponse;
                    boolean bl = false;
                    Closeable closeable = (Closeable)Okio.sink$default((File)editor3.getData(), (boolean)false, (int)1, null);
                    Throwable throwable2 = null;
                    try {
                        Sink p0 = (Sink)closeable;
                        boolean bl2 = false;
                        l = it2.readAll(p0);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                    }
                    long l2 = l;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)combinedResponse, (Throwable)throwable);
                }
            }
            return editor3.commitAndGet();
        }
        catch (Exception e) {
            -Utils.abortQuietly(editor3);
            throw e;
        }
    }

    private final Request newRequest() {
        Request.Builder request = new Request.Builder().url(this.url).headers(this.options.getHeaders());
        Map<Class<?>, Object> $this$forEach$iv = this.options.getTags().asMap();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Class<?>, Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Class<?>, Object> element$iv;
            Map.Entry<Class<?>, Object> it = element$iv = iterator.next();
            boolean bl = false;
            request.tag(it.getKey(), it.getValue());
        }
        boolean diskRead = this.options.getDiskCachePolicy().getReadEnabled();
        boolean networkRead = this.options.getNetworkCachePolicy().getReadEnabled();
        if (!networkRead && diskRead) {
            request.cacheControl(CacheControl.FORCE_CACHE);
        } else if (networkRead && !diskRead) {
            if (this.options.getDiskCachePolicy().getWriteEnabled()) {
                request.cacheControl(CacheControl.FORCE_NETWORK);
            } else {
                request.cacheControl(CACHE_CONTROL_FORCE_NETWORK_NO_CACHE);
            }
        } else if (!networkRead && !diskRead) {
            request.cacheControl(CACHE_CONTROL_NO_NETWORK_NO_CACHE);
        }
        return request.build();
    }

    /*
     * Unable to fully structure code
     */
    private final Object executeNetworkRequest(Request var1_1, Continuation<? super Response> var2_2) {
        if (!(var2_2 instanceof executeNetworkRequest.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ HttpUriFetcher this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HttpUriFetcher.access$executeNetworkRequest(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!-Utils.isMainThread()) ** GOTO lbl17
                if (this.options.getNetworkCachePolicy().getReadEnabled()) {
                    throw new NetworkOnMainThreadException();
                }
                v0 = ((Call.Factory)this.callFactory.getValue()).newCall((Request)request).execute();
                ** GOTO lbl26
lbl17:
                // 1 sources

                $continuation.label = 1;
                v1 = -Calls.await(((Call.Factory)this.callFactory.getValue()).newCall((Request)request), (Continuation<? super Response>)$continuation);
                if (v1 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl25
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl25:
                // 2 sources

                v0 = response = (Response)v1;
lbl26:
                // 2 sources

                if (!response.isSuccessful() && response.code() != 304) {
                    v2 = response.body();
                    if (v2 != null) {
                        -Utils.closeQuietly((Closeable)v2);
                    }
                    throw new HttpException(response);
                }
                return response;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @VisibleForTesting
    @Nullable
    public final String getMimeType$coil_base_release(@NotNull String url, @Nullable MediaType contentType2) {
        String rawContentType;
        MediaType mediaType = contentType2;
        String string = rawContentType = mediaType == null ? null : mediaType.toString();
        if (rawContentType == null || StringsKt.startsWith$default((String)rawContentType, (String)MIME_TYPE_TEXT_PLAIN, (boolean)false, (int)2, null)) {
            String string2 = -Utils.getMimeTypeFromUrl(MimeTypeMap.getSingleton(), url);
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                return it;
            }
        }
        String string3 = rawContentType;
        return string3 == null ? null : StringsKt.substringBefore$default((String)string3, (char)';', null, (int)2, null);
    }

    private final boolean isCacheable(Request request, Response response) {
        return this.options.getDiskCachePolicy().getWriteEnabled() && (!this.respectCacheHeaders || CacheStrategy.Companion.isCacheable(request, response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CacheResponse toCacheResponse(DiskCache.Snapshot $this$toCacheResponse) {
        try {
            CacheResponse cacheResponse;
            Closeable closeable = (Closeable)Okio.buffer((Source)Okio.source((File)$this$toCacheResponse.getMetadata()));
            Throwable throwable = null;
            try {
                BufferedSource p0 = (BufferedSource)closeable;
                boolean bl = false;
                cacheResponse = new CacheResponse(p0);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return cacheResponse;
        }
        catch (IOException _) {
            return null;
        }
    }

    private final ImageSource toImageSource(DiskCache.Snapshot $this$toImageSource) {
        return ImageSources.create($this$toImageSource.getData(), this.getDiskCacheKey(), $this$toImageSource);
    }

    private final ImageSource toImageSource(ResponseBody $this$toImageSource) {
        return ImageSources.create($this$toImageSource.source(), this.options.getContext());
    }

    private final String getDiskCacheKey() {
        String string = this.options.getDiskCacheKey();
        if (string == null) {
            string = this.url;
        }
        return string;
    }

    public static final /* synthetic */ Object access$executeNetworkRequest(HttpUriFetcher $this, Request request, Continuation $completion) {
        return $this.executeNetworkRequest(request, (Continuation<? super Response>)$completion);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0002H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcoil/fetch/HttpUriFetcher$Factory;", "Lcoil/fetch/Fetcher$Factory;", "Landroid/net/Uri;", "callFactory", "Lkotlin/Lazy;", "Lokhttp3/Call$Factory;", "diskCache", "Lcoil/disk/DiskCache;", "respectCacheHeaders", "", "(Lkotlin/Lazy;Lkotlin/Lazy;Z)V", "create", "Lcoil/fetch/Fetcher;", "data", "options", "Lcoil/request/Options;", "imageLoader", "Lcoil/ImageLoader;", "isApplicable", "coil-base_release"})
    public static final class Factory
    implements Fetcher.Factory<Uri> {
        @NotNull
        private final Lazy<Call.Factory> callFactory;
        @NotNull
        private final Lazy<DiskCache> diskCache;
        private final boolean respectCacheHeaders;

        public Factory(@NotNull Lazy<? extends Call.Factory> callFactory, @NotNull Lazy<? extends DiskCache> diskCache, boolean respectCacheHeaders) {
            this.callFactory = callFactory;
            this.diskCache = diskCache;
            this.respectCacheHeaders = respectCacheHeaders;
        }

        @Override
        @Nullable
        public Fetcher create(@NotNull Uri data, @NotNull Options options, @NotNull ImageLoader imageLoader) {
            if (!this.isApplicable(data)) {
                return null;
            }
            return new HttpUriFetcher(data.toString(), options, this.callFactory, this.diskCache, this.respectCacheHeaders);
        }

        private final boolean isApplicable(Uri data) {
            return Intrinsics.areEqual((Object)data.getScheme(), (Object)"http") || Intrinsics.areEqual((Object)data.getScheme(), (Object)"https");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcoil/fetch/HttpUriFetcher$Companion;", "", "()V", "CACHE_CONTROL_FORCE_NETWORK_NO_CACHE", "Lokhttp3/CacheControl;", "CACHE_CONTROL_NO_NETWORK_NO_CACHE", "MIME_TYPE_TEXT_PLAIN", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

