/*
 * Decompiled with CFR 0.152.
 */
package coil.fetch;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.graphics.Point;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.VisibleForTesting;
import coil.ImageLoader;
import coil.decode.DataSource;
import coil.decode.ImageSources;
import coil.fetch.FetchResult;
import coil.fetch.Fetcher;
import coil.fetch.SourceResult;
import coil.request.Options;
import coil.size.PixelSize;
import coil.size.Size;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0001\u00a2\u0006\u0002\b\fJ\u0015\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0001\u00a2\u0006\u0002\b\u000eJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lcoil/fetch/ContentUriFetcher;", "Lcoil/fetch/Fetcher;", "data", "Landroid/net/Uri;", "options", "Lcoil/request/Options;", "(Landroid/net/Uri;Lcoil/request/Options;)V", "fetch", "Lcoil/fetch/FetchResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isContactPhotoUri", "", "isContactPhotoUri$coil_base_release", "isMusicThumbnailUri", "isMusicThumbnailUri$coil_base_release", "newMusicThumbnailSizeOptions", "Landroid/os/Bundle;", "Factory", "coil-base_release"})
public final class ContentUriFetcher
implements Fetcher {
    @NotNull
    private final Uri data;
    @NotNull
    private final Options options;

    public ContentUriFetcher(@NotNull Uri data, @NotNull Options options) {
        this.data = data;
        this.options = options;
    }

    @Override
    @Nullable
    public Object fetch(@NotNull Continuation<? super FetchResult> $completion) {
        InputStream inputStream;
        boolean bl;
        InputStream stream;
        ContentResolver contentResolver = this.options.getContext().getContentResolver();
        if (this.isContactPhotoUri$coil_base_release(this.data)) {
            AssetFileDescriptor assetFileDescriptor = contentResolver.openAssetFileDescriptor(this.data, "r");
            stream = assetFileDescriptor == null ? null : assetFileDescriptor.createInputStream();
            boolean bl2 = false;
            bl = false;
            if (stream == null) {
                boolean bl32 = false;
                String string = "Unable to find a contact photo associated with '" + this.data + "'.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            inputStream = stream;
        } else if (Build.VERSION.SDK_INT >= 29 && this.isMusicThumbnailUri$coil_base_release(this.data)) {
            Bundle bundle = this.newMusicThumbnailSizeOptions();
            AssetFileDescriptor assetFileDescriptor = contentResolver.openTypedAssetFile(this.data, "image/*", bundle, null);
            FileInputStream stream2 = assetFileDescriptor == null ? null : assetFileDescriptor.createInputStream();
            bl = false;
            boolean bl32 = false;
            if (stream2 == null) {
                boolean bl4 = false;
                String bl32 = "Unable to find a music thumbnail associated with '" + this.data + "'.";
                throw (Throwable)new IllegalStateException(bl32.toString());
            }
            inputStream = stream2;
        } else {
            stream = contentResolver.openInputStream(this.data);
            boolean bl5 = false;
            bl = false;
            if (stream == null) {
                boolean bl6 = false;
                String string = "Unable to open '" + this.data + "'.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            inputStream = stream;
        }
        InputStream inputStream2 = inputStream;
        return new SourceResult(ImageSources.create(Okio.buffer((Source)Okio.source((InputStream)inputStream2)), this.options.getContext()), contentResolver.getType(this.data), DataSource.DISK);
    }

    @VisibleForTesting
    public final boolean isContactPhotoUri$coil_base_release(@NotNull Uri data) {
        return Intrinsics.areEqual((Object)data.getAuthority(), (Object)"com.android.contacts") && Intrinsics.areEqual((Object)data.getLastPathSegment(), (Object)"display_photo");
    }

    @VisibleForTesting
    public final boolean isMusicThumbnailUri$coil_base_release(@NotNull Uri data) {
        if (!Intrinsics.areEqual((Object)data.getAuthority(), (Object)"media")) {
            return false;
        }
        List segments = data.getPathSegments();
        int size2 = segments.size();
        return size2 >= 3 && Intrinsics.areEqual(segments.get(size2 - 3), (Object)"audio") && Intrinsics.areEqual(segments.get(size2 - 2), (Object)"albums");
    }

    private final Bundle newMusicThumbnailSizeOptions() {
        PixelSize pixelSize;
        Size size2 = this.options.getSize();
        PixelSize pixelSize2 = pixelSize = size2 instanceof PixelSize ? (PixelSize)size2 : null;
        if (pixelSize == null) {
            return null;
        }
        PixelSize pixelSize3 = pixelSize;
        int width = pixelSize3.component1();
        int height = pixelSize3.component2();
        Bundle bundle = new Bundle(1);
        boolean bl = false;
        boolean bl2 = false;
        Bundle $this$newMusicThumbnailSizeOptions_u24lambda_u2d3 = bundle;
        boolean bl3 = false;
        $this$newMusicThumbnailSizeOptions_u24lambda_u2d3.putParcelable("android.content.extra.SIZE", (Parcelable)new Point(width, height));
        return bundle;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a8\u0006\r"}, d2={"Lcoil/fetch/ContentUriFetcher$Factory;", "Lcoil/fetch/Fetcher$Factory;", "Landroid/net/Uri;", "()V", "create", "Lcoil/fetch/Fetcher;", "data", "options", "Lcoil/request/Options;", "imageLoader", "Lcoil/ImageLoader;", "isApplicable", "", "coil-base_release"})
    public static final class Factory
    implements Fetcher.Factory<Uri> {
        @Override
        @Nullable
        public Fetcher create(@NotNull Uri data, @NotNull Options options, @NotNull ImageLoader imageLoader) {
            if (!this.isApplicable(data)) {
                return null;
            }
            return new ContentUriFetcher(data, options);
        }

        private final boolean isApplicable(Uri data) {
            return Intrinsics.areEqual((Object)data.getScheme(), (Object)"content");
        }
    }
}

