/*
 * Decompiled with CFR 0.152.
 */
package coil.disk;

import android.content.Context;
import android.os.StatFs;
import androidx.annotation.FloatRange;
import coil.annotation.ExperimentalCoilApi;
import coil.disk.RealDiskCache;
import java.io.Closeable;
import java.io.File;
import kotlin.Metadata;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\bg\u0018\u00002\u00020\u0001:\u0003\u0016\u0017\u0018J\b\u0010\f\u001a\u00020\rH&J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u00a6\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0019\u00c0\u0006\u0001"}, d2={"Lcoil/disk/DiskCache;", "", "directory", "Ljava/io/File;", "getDirectory", "()Ljava/io/File;", "maxSize", "", "getMaxSize", "()J", "size", "getSize", "clear", "", "edit", "Lcoil/disk/DiskCache$Editor;", "key", "", "get", "Lcoil/disk/DiskCache$Snapshot;", "remove", "", "Builder", "Editor", "Snapshot", "coil-base_release"})
@ExperimentalCoilApi
public interface DiskCache {
    public long getSize();

    public long getMaxSize();

    @NotNull
    public File getDirectory();

    @Nullable
    public Snapshot get(@NotNull String var1);

    @Nullable
    public Editor edit(@NotNull String var1);

    public boolean remove(@NotNull String var1);

    public void clear();

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\b\u001a\u00020\tH&J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcoil/disk/DiskCache$Snapshot;", "Ljava/io/Closeable;", "data", "Ljava/io/File;", "getData", "()Ljava/io/File;", "metadata", "getMetadata", "close", "", "closeAndEdit", "Lcoil/disk/DiskCache$Editor;", "coil-base_release"})
    public static interface Snapshot
    extends Closeable {
        @NotNull
        public File getMetadata();

        @NotNull
        public File getData();

        @Override
        public void close();

        @Nullable
        public Editor closeAndEdit();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\b\u001a\u00020\tH&J\b\u0010\n\u001a\u00020\tH&J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lcoil/disk/DiskCache$Editor;", "", "data", "Ljava/io/File;", "getData", "()Ljava/io/File;", "metadata", "getMetadata", "abort", "", "commit", "commitAndGet", "Lcoil/disk/DiskCache$Snapshot;", "coil-base_release"})
    public static interface Editor {
        @NotNull
        public File getMetadata();

        @NotNull
        public File getData();

        public void commit();

        @Nullable
        public Snapshot commitAndGet();

        public void abort();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00002\b\b\u0001\u0010\u0013\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcoil/disk/DiskCache$Builder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "cleanupDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "directory", "Ljava/io/File;", "maxSizeBytes", "", "maxSizePercent", "", "maximumMaxSizeBytes", "minimumMaxSizeBytes", "build", "Lcoil/disk/DiskCache;", "dispatcher", "size", "percent", "coil-base_release"})
    public static final class Builder {
        @NotNull
        private final Context context;
        @Nullable
        private File directory;
        private double maxSizePercent;
        private long minimumMaxSizeBytes;
        private long maximumMaxSizeBytes;
        private long maxSizeBytes;
        @NotNull
        private CoroutineDispatcher cleanupDispatcher;

        public Builder(@NotNull Context context) {
            this.context = context;
            this.maxSizePercent = 0.02;
            this.minimumMaxSizeBytes = 0xA00000L;
            this.maximumMaxSizeBytes = 0xFA00000L;
            this.cleanupDispatcher = Dispatchers.getIO();
        }

        @NotNull
        public final Builder directory(@NotNull File directory) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$directory_u24lambda_u2d0 = builder;
            boolean bl3 = false;
            $this$directory_u24lambda_u2d0.directory = directory;
            return builder;
        }

        @NotNull
        public final Builder maxSizePercent(@FloatRange(from=0.0, to=1.0) double percent) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$maxSizePercent_u24lambda_u2d2 = builder;
            boolean bl3 = false;
            boolean bl4 = 0.0 <= percent ? percent <= 1.0 : false;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "size must be in the range [0.0, 1.0].";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            $this$maxSizePercent_u24lambda_u2d2.maxSizeBytes = 0L;
            $this$maxSizePercent_u24lambda_u2d2.maxSizePercent = percent;
            return builder;
        }

        @NotNull
        public final Builder minimumMaxSizeBytes(long size2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$minimumMaxSizeBytes_u24lambda_u2d4 = builder;
            boolean bl3 = false;
            boolean bl4 = size2 > 0L;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "size must be > 0.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            $this$minimumMaxSizeBytes_u24lambda_u2d4.minimumMaxSizeBytes = size2;
            return builder;
        }

        @NotNull
        public final Builder maximumMaxSizeBytes(long size2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$maximumMaxSizeBytes_u24lambda_u2d6 = builder;
            boolean bl3 = false;
            boolean bl4 = size2 > 0L;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "size must be > 0.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            $this$maximumMaxSizeBytes_u24lambda_u2d6.maximumMaxSizeBytes = size2;
            return builder;
        }

        @NotNull
        public final Builder maxSizeBytes(long size2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$maxSizeBytes_u24lambda_u2d8 = builder;
            boolean bl3 = false;
            boolean bl4 = size2 > 0L;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "size must be > 0.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            $this$maxSizeBytes_u24lambda_u2d8.maxSizePercent = 0.0;
            $this$maxSizeBytes_u24lambda_u2d8.maxSizeBytes = size2;
            return builder;
        }

        @NotNull
        public final Builder cleanupDispatcher(@NotNull CoroutineDispatcher dispatcher) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$cleanupDispatcher_u24lambda_u2d9 = builder;
            boolean bl3 = false;
            $this$cleanupDispatcher_u24lambda_u2d9.cleanupDispatcher = dispatcher;
            return builder;
        }

        @NotNull
        public final DiskCache build() {
            long l;
            File file = this.directory;
            boolean bl = false;
            boolean bl2 = false;
            if (file == null) {
                boolean bl3 = false;
                String string = "directory == null";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            File directory = file;
            if (this.maxSizePercent > 0.0) {
                long l2;
                try {
                    StatFs stats = new StatFs(directory.getAbsolutePath());
                    double size2 = this.maxSizePercent * (double)stats.getBlockCountLong() * (double)stats.getBlockSizeLong();
                    l2 = RangesKt.coerceIn((long)((long)size2), (long)this.minimumMaxSizeBytes, (long)this.maximumMaxSizeBytes);
                }
                catch (Exception _) {
                    l2 = this.minimumMaxSizeBytes;
                }
                l = l2;
            } else {
                l = this.maxSizeBytes;
            }
            long maxSize = l;
            return new RealDiskCache(maxSize, directory, this.cleanupDispatcher);
        }
    }
}

