/*
 * Decompiled with CFR 0.152.
 */
package coil.fetch;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import androidx.annotation.VisibleForTesting;
import coil.ImageLoader;
import coil.decode.DataSource;
import coil.decode.ImageSources;
import coil.fetch.FetchResult;
import coil.fetch.Fetcher;
import coil.fetch.SourceResult;
import coil.request.Options;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0001\u00a2\u0006\u0002\b\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000e"}, d2={"Lcoil/fetch/ContentUriFetcher;", "Lcoil/fetch/Fetcher;", "data", "Landroid/net/Uri;", "options", "Lcoil/request/Options;", "(Landroid/net/Uri;Lcoil/request/Options;)V", "fetch", "Lcoil/fetch/FetchResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isContactPhotoUri", "", "isContactPhotoUri$coil_base_release", "Factory", "coil-base_release"})
public final class ContentUriFetcher
implements Fetcher {
    @NotNull
    private final Uri data;
    @NotNull
    private final Options options;

    public ContentUriFetcher(@NotNull Uri data, @NotNull Options options) {
        this.data = data;
        this.options = options;
    }

    @Override
    @Nullable
    public Object fetch(@NotNull Continuation<? super FetchResult> $completion) {
        InputStream inputStream;
        boolean bl;
        boolean bl2;
        InputStream stream;
        Context context = this.options.getContext();
        if (this.isContactPhotoUri$coil_base_release(this.data)) {
            AssetFileDescriptor assetFileDescriptor = context.getContentResolver().openAssetFileDescriptor(this.data, "r");
            stream = assetFileDescriptor == null ? null : assetFileDescriptor.createInputStream();
            bl2 = false;
            bl = false;
            if (stream == null) {
                boolean bl3 = false;
                String string = "Unable to find a contact photo associated with '" + this.data + "'.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            inputStream = stream;
        } else {
            stream = context.getContentResolver().openInputStream(this.data);
            bl2 = false;
            bl = false;
            if (stream == null) {
                boolean bl4 = false;
                String string = "Unable to open '" + this.data + "'.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            inputStream = stream;
        }
        InputStream inputStream2 = inputStream;
        return new SourceResult(ImageSources.create(Okio.buffer((Source)Okio.source((InputStream)inputStream2)), context), context.getContentResolver().getType(this.data), DataSource.DISK);
    }

    @VisibleForTesting
    public final boolean isContactPhotoUri$coil_base_release(@NotNull Uri data) {
        return Intrinsics.areEqual((Object)data.getAuthority(), (Object)"com.android.contacts") && Intrinsics.areEqual((Object)data.getLastPathSegment(), (Object)"display_photo");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a8\u0006\r"}, d2={"Lcoil/fetch/ContentUriFetcher$Factory;", "Lcoil/fetch/Fetcher$Factory;", "Landroid/net/Uri;", "()V", "create", "Lcoil/fetch/Fetcher;", "data", "options", "Lcoil/request/Options;", "imageLoader", "Lcoil/ImageLoader;", "isApplicable", "", "coil-base_release"})
    public static final class Factory
    implements Fetcher.Factory<Uri> {
        @Override
        @Nullable
        public Fetcher create(@NotNull Uri data, @NotNull Options options, @NotNull ImageLoader imageLoader) {
            if (!this.isApplicable(data)) {
                return null;
            }
            return new ContentUriFetcher(data, options);
        }

        private final boolean isApplicable(Uri data) {
            return Intrinsics.areEqual((Object)data.getScheme(), (Object)"content");
        }
    }
}

