/*
 * Decompiled with CFR 0.152.
 */
package coil.fetch;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.TypedValue;
import android.webkit.MimeTypeMap;
import coil.bitmap.BitmapPool;
import coil.decode.DataSource;
import coil.decode.DrawableDecoderService;
import coil.decode.Options;
import coil.fetch.DrawableResult;
import coil.fetch.FetchResult;
import coil.fetch.Fetcher;
import coil.fetch.SourceResult;
import coil.size.Size;
import coil.util.-Contexts;
import coil.util.-Extensions;
import java.io.InputStream;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J1\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lcoil/fetch/ResourceUriFetcher;", "Lcoil/fetch/Fetcher;", "Landroid/net/Uri;", "context", "Landroid/content/Context;", "drawableDecoder", "Lcoil/decode/DrawableDecoderService;", "(Landroid/content/Context;Lcoil/decode/DrawableDecoderService;)V", "fetch", "Lcoil/fetch/FetchResult;", "pool", "Lcoil/bitmap/BitmapPool;", "data", "size", "Lcoil/size/Size;", "options", "Lcoil/decode/Options;", "(Lcoil/bitmap/BitmapPool;Landroid/net/Uri;Lcoil/size/Size;Lcoil/decode/Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handles", "", "key", "", "throwInvalidUriException", "", "Companion", "coil-base_release"})
public final class ResourceUriFetcher
implements Fetcher<Uri> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final DrawableDecoderService drawableDecoder;
    @NotNull
    private static final String MIME_TYPE_XML = "text/xml";

    public ResourceUriFetcher(@NotNull Context context, @NotNull DrawableDecoderService drawableDecoder) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)drawableDecoder, (String)"drawableDecoder");
        this.context = context;
        this.drawableDecoder = drawableDecoder;
    }

    @Override
    public boolean handles(@NotNull Uri data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return Intrinsics.areEqual((Object)data.getScheme(), (Object)"android.resource");
    }

    @Override
    @NotNull
    public String key(@NotNull Uri data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        StringBuilder stringBuilder = new StringBuilder().append(data).append('-');
        Configuration configuration = this.context.getResources().getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"context.resources.configuration");
        return stringBuilder.append(-Extensions.getNightMode(configuration)).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object fetch(@NotNull BitmapPool pool, @NotNull Uri data, @NotNull Size size2, @NotNull Options options, @NotNull Continuation<? super FetchResult> $completion) {
        FetchResult fetchResult;
        Object object;
        Object object2;
        boolean bl;
        Object object3;
        Object object4;
        String string = data.getAuthority();
        if (string == null) {
            object4 = null;
        } else {
            object3 = string;
            boolean bl2 = false;
            bl = false;
            String it22 = object3;
            boolean bl3 = false;
            CharSequence charSequence = it22;
            boolean bl4 = false;
            object4 = object2 = !StringsKt.isBlank((CharSequence)charSequence) ? object3 : null;
        }
        if (object2 == null) {
            this.throwInvalidUriException(data);
            throw new KotlinNothingValueException();
        }
        Object packageName = object = object2;
        object3 = data.getPathSegments();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"data.pathSegments");
        string = (String)CollectionsKt.lastOrNull((List)object3);
        Object object5 = object2 = string == null ? null : StringsKt.toIntOrNull((String)string);
        if (object2 == null) {
            this.throwInvalidUriException(data);
            throw new KotlinNothingValueException();
        }
        int resId = (Integer)object2;
        Context context = options.getContext();
        object3 = context.getPackageManager().getResourcesForApplication((String)packageName);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"context.packageManager.g\u2026rApplication(packageName)");
        Object resources = object3;
        TypedValue typedValue = new TypedValue();
        bl = false;
        int it22 = 0;
        TypedValue $this$fetch_u24lambda_u2d22 = typedValue;
        boolean bl52 = false;
        resources.getValue(resId, $this$fetch_u24lambda_u2d22, true);
        CharSequence path = typedValue.string;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        CharSequence charSequence = path;
        it22 = StringsKt.lastIndexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null);
        int $this$fetch_u24lambda_u2d22 = charSequence.length();
        bl52 = false;
        String entryName = ((Object)charSequence.subSequence(it22, $this$fetch_u24lambda_u2d22)).toString();
        MimeTypeMap it22 = MimeTypeMap.getSingleton();
        Intrinsics.checkNotNullExpressionValue((Object)it22, (String)"getSingleton()");
        String mimeType = -Extensions.getMimeTypeFromUrl(it22, entryName);
        if (Intrinsics.areEqual((Object)mimeType, (Object)MIME_TYPE_XML)) {
            Drawable drawable;
            Drawable drawable2 = Intrinsics.areEqual((Object)packageName, (Object)context.getPackageName()) ? -Contexts.getDrawableCompat(context, resId) : -Contexts.getXmlDrawableCompat(context, (Resources)resources, resId);
            boolean isVector = -Extensions.isVector(drawable2);
            if (isVector) {
                void $this$toDrawable$iv$iv;
                void $this$toDrawable$iv;
                Bitmap bl52 = this.drawableDecoder.convert(drawable2, options.getConfig(), size2, options.getScale(), options.getAllowInexactSize());
                boolean $i$f$toDrawable = false;
                void var17_26 = $this$toDrawable$iv;
                Resources resources2 = context.getResources();
                Intrinsics.checkNotNullExpressionValue((Object)resources2, (String)"context.resources");
                Resources resources$iv$iv = resources2;
                boolean $i$f$toDrawable2 = false;
                drawable = (Drawable)new BitmapDrawable(resources$iv$iv, (Bitmap)$this$toDrawable$iv$iv);
            } else {
                drawable = drawable2;
            }
            fetchResult = new DrawableResult(drawable, isVector, DataSource.DISK);
        } else {
            InputStream inputStream = resources.openRawResource(resId);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"resources.openRawResource(resId)");
            fetchResult = new SourceResult(Okio.buffer((Source)Okio.source((InputStream)inputStream)), mimeType, DataSource.DISK);
        }
        return fetchResult;
    }

    private final Void throwInvalidUriException(Uri data) {
        throw new IllegalStateException(Intrinsics.stringPlus((String)"Invalid android.resource URI: ", (Object)data));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcoil/fetch/ResourceUriFetcher$Companion;", "", "()V", "MIME_TYPE_XML", "", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

