/*
 * Decompiled with CFR 0.152.
 */
package coil.decode;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import androidx.exifinterface.media.ExifInterface;
import coil.bitmap.BitmapPool;
import coil.decode.DecodeResult;
import coil.decode.DecodeUtils;
import coil.decode.Decoder;
import coil.decode.InterruptibleSource;
import coil.decode.Options;
import coil.size.PixelSize;
import coil.size.Size;
import coil.util.-Bitmaps;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 #2\u00020\u0001:\u0003#$%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J1\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ(\u0010\u001b\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0012\u0010 \u001a\u00020\u000f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J$\u0010!\u001a\u00020\r*\u00020\"2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006&"}, d2={"Lcoil/decode/BitmapFactoryDecoder;", "Lcoil/decode/Decoder;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "paint", "Landroid/graphics/Paint;", "applyExifTransformations", "Landroid/graphics/Bitmap;", "pool", "Lcoil/bitmap/BitmapPool;", "inBitmap", "config", "Landroid/graphics/Bitmap$Config;", "isFlipped", "", "rotationDegrees", "", "decode", "Lcoil/decode/DecodeResult;", "source", "Lokio/BufferedSource;", "size", "Lcoil/size/Size;", "options", "Lcoil/decode/Options;", "(Lcoil/bitmap/BitmapPool;Lokio/BufferedSource;Lcoil/size/Size;Lcoil/decode/Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "decodeInterruptible", "Lokio/Source;", "handles", "mimeType", "", "shouldReadExifData", "computeConfig", "Landroid/graphics/BitmapFactory$Options;", "Companion", "ExceptionCatchingSource", "ExifInterfaceInputStream", "coil-base_release"})
public final class BitmapFactoryDecoder
implements Decoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Paint paint;
    @NotNull
    private static final String MIME_TYPE_JPEG = "image/jpeg";
    @NotNull
    private static final String MIME_TYPE_WEBP = "image/webp";
    @NotNull
    private static final String MIME_TYPE_HEIC = "image/heic";
    @NotNull
    private static final String MIME_TYPE_HEIF = "image/heif";
    private static final int GIGABYTE_IN_BYTES = 0x40000000;
    @NotNull
    private static final String[] SUPPORTED_EXIF_MIME_TYPES;

    public BitmapFactoryDecoder(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.paint = new Paint(3);
    }

    @Override
    public boolean handles(@NotNull BufferedSource source, @Nullable String mimeType) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object decode(@NotNull BitmapPool pool, @NotNull BufferedSource source, @NotNull Size size2, @NotNull Options options, @NotNull Continuation<? super DecodeResult> $completion) {
        boolean $i$f$withInterruptibleSource = false;
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super DecodeResult> uCont$iv$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv$iv), 1);
        cancellable$iv$iv.initCancellability();
        CancellableContinuation continuation$iv = (CancellableContinuation)cancellable$iv$iv;
        boolean bl2 = false;
        try {
            InterruptibleSource interruptibleSource$iv = new InterruptibleSource(continuation$iv, (Source)source);
            try {
                Continuation continuation = (Continuation)continuation$iv;
                Source interruptibleSource = (Source)interruptibleSource$iv;
                boolean bl3 = false;
                DecodeResult decodeResult = this.decodeInterruptible(pool, interruptibleSource, size2, options);
                boolean bl4 = false;
                Result.Companion companion = Result.Companion;
                boolean bl5 = false;
                continuation.resumeWith(Result.constructor-impl((Object)decodeResult));
            }
            finally {
                interruptibleSource$iv.clearInterrupt();
            }
        }
        catch (Exception exception$iv) {
            if (exception$iv instanceof InterruptedException || exception$iv instanceof InterruptedIOException) {
                Throwable throwable = new CancellationException("Blocking call was interrupted due to parent cancellation.").initCause(exception$iv);
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"CancellationException(\"Blocking call was interrupted due to parent cancellation.\").initCause(exception)");
                throw throwable;
            }
            throw exception$iv;
        }
        Object object = cancellable$iv$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final DecodeResult decodeInterruptible(BitmapPool pool, Source source, Size size2, Options options) {
        void $this$toDrawable$iv$iv;
        void $this$toDrawable$iv;
        Bitmap p0;
        boolean bl8;
        Size size32;
        BitmapFactory.Options options2 = new BitmapFactory.Options();
        boolean bl2 = false;
        boolean bl3 = false;
        BitmapFactory.Options $this$decodeInterruptible_u24lambda_u2d7 = options2;
        boolean bl4 = false;
        ExceptionCatchingSource safeSource = new ExceptionCatchingSource(source);
        BufferedSource safeBufferedSource = Okio.buffer((Source)((Source)safeSource));
        $this$decodeInterruptible_u24lambda_u2d7.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)safeBufferedSource.peek().inputStream(), null, (BitmapFactory.Options)$this$decodeInterruptible_u24lambda_u2d7);
        Exception exception = safeSource.getException();
        if (exception != null) {
            Exception exception2 = exception;
            boolean bl5 = false;
            boolean bl6 = false;
            Exception it = exception2;
            boolean size32 = false;
            throw it;
        }
        $this$decodeInterruptible_u24lambda_u2d7.inJustDecodeBounds = false;
        boolean isFlipped = false;
        int rotationDegrees = 0;
        if (this.shouldReadExifData($this$decodeInterruptible_u24lambda_u2d7.outMimeType)) {
            ExifInterface exifInterface = new ExifInterface((InputStream)new ExifInterfaceInputStream(safeBufferedSource.peek().inputStream()));
            Exception exception3 = safeSource.getException();
            if (exception3 != null) {
                Exception it = exception3;
                boolean size32 = false;
                boolean bl7 = false;
                Exception it2 = it;
                boolean bl8 = false;
                throw it2;
            }
            isFlipped = exifInterface.isFlipped();
            rotationDegrees = exifInterface.getRotationDegrees();
        } else {
            isFlipped = false;
            rotationDegrees = 0;
        }
        boolean isSwapped = rotationDegrees == 90 || rotationDegrees == 270;
        int srcWidth = isSwapped ? $this$decodeInterruptible_u24lambda_u2d7.outHeight : $this$decodeInterruptible_u24lambda_u2d7.outWidth;
        int srcHeight = isSwapped ? $this$decodeInterruptible_u24lambda_u2d7.outWidth : $this$decodeInterruptible_u24lambda_u2d7.outHeight;
        $this$decodeInterruptible_u24lambda_u2d7.inPreferredConfig = this.computeConfig($this$decodeInterruptible_u24lambda_u2d7, options, isFlipped, rotationDegrees);
        if (Build.VERSION.SDK_INT >= 26 && options.getColorSpace() != null) {
            $this$decodeInterruptible_u24lambda_u2d7.inPreferredColorSpace = options.getColorSpace();
        }
        if (Build.VERSION.SDK_INT >= 19) {
            $this$decodeInterruptible_u24lambda_u2d7.inPremultiplied = options.getPremultipliedAlpha();
        }
        $this$decodeInterruptible_u24lambda_u2d7.inMutable = Build.VERSION.SDK_INT < 24;
        $this$decodeInterruptible_u24lambda_u2d7.inScaled = false;
        if ($this$decodeInterruptible_u24lambda_u2d7.outWidth <= 0 || $this$decodeInterruptible_u24lambda_u2d7.outHeight <= 0) {
            $this$decodeInterruptible_u24lambda_u2d7.inSampleSize = 1;
            $this$decodeInterruptible_u24lambda_u2d7.inScaled = false;
            $this$decodeInterruptible_u24lambda_u2d7.inBitmap = null;
        } else if (!(size2 instanceof PixelSize)) {
            $this$decodeInterruptible_u24lambda_u2d7.inSampleSize = 1;
            $this$decodeInterruptible_u24lambda_u2d7.inScaled = false;
            if ($this$decodeInterruptible_u24lambda_u2d7.inMutable) {
                int n = $this$decodeInterruptible_u24lambda_u2d7.outWidth;
                int n2 = $this$decodeInterruptible_u24lambda_u2d7.outHeight;
                size32 = $this$decodeInterruptible_u24lambda_u2d7.inPreferredConfig;
                Intrinsics.checkNotNullExpressionValue((Object)size32, (String)"inPreferredConfig");
                $this$decodeInterruptible_u24lambda_u2d7.inBitmap = pool.getDirty(n, n2, (Bitmap.Config)size32);
            }
        } else {
            size32 = size2;
            int width = ((PixelSize)size32).component1();
            int height = ((PixelSize)size32).component2();
            $this$decodeInterruptible_u24lambda_u2d7.inSampleSize = DecodeUtils.calculateInSampleSize(srcWidth, srcHeight, width, height, options.getScale());
            double rawScale = DecodeUtils.computeSizeMultiplier((double)srcWidth / (double)$this$decodeInterruptible_u24lambda_u2d7.inSampleSize, (double)srcHeight / (double)$this$decodeInterruptible_u24lambda_u2d7.inSampleSize, (double)width, (double)height, options.getScale());
            double scale = options.getAllowInexactSize() ? RangesKt.coerceAtMost((double)rawScale, (double)1.0) : rawScale;
            boolean bl9 = $this$decodeInterruptible_u24lambda_u2d7.inScaled = !(scale == 1.0);
            if ($this$decodeInterruptible_u24lambda_u2d7.inScaled) {
                if (scale > 1.0) {
                    $this$decodeInterruptible_u24lambda_u2d7.inDensity = MathKt.roundToInt((double)((double)Integer.MAX_VALUE / scale));
                    $this$decodeInterruptible_u24lambda_u2d7.inTargetDensity = Integer.MAX_VALUE;
                } else {
                    $this$decodeInterruptible_u24lambda_u2d7.inDensity = Integer.MAX_VALUE;
                    $this$decodeInterruptible_u24lambda_u2d7.inTargetDensity = MathKt.roundToInt((double)((double)Integer.MAX_VALUE * scale));
                }
            }
            if ($this$decodeInterruptible_u24lambda_u2d7.inMutable) {
                Bitmap bitmap;
                if ($this$decodeInterruptible_u24lambda_u2d7.inSampleSize == 1 && !$this$decodeInterruptible_u24lambda_u2d7.inScaled) {
                    int n = $this$decodeInterruptible_u24lambda_u2d7.outWidth;
                    int n3 = $this$decodeInterruptible_u24lambda_u2d7.outHeight;
                    Bitmap.Config config = $this$decodeInterruptible_u24lambda_u2d7.inPreferredConfig;
                    Intrinsics.checkNotNullExpressionValue((Object)config, (String)"inPreferredConfig");
                    bitmap = pool.getDirty(n, n3, config);
                } else if (Build.VERSION.SDK_INT >= 19) {
                    double sampledOutWidth = (double)$this$decodeInterruptible_u24lambda_u2d7.outWidth / (double)$this$decodeInterruptible_u24lambda_u2d7.inSampleSize;
                    double sampledOutHeight = (double)$this$decodeInterruptible_u24lambda_u2d7.outHeight / (double)$this$decodeInterruptible_u24lambda_u2d7.inSampleSize;
                    double d = scale * sampledOutWidth + 0.5;
                    boolean bl10 = false;
                    int n = (int)Math.ceil(d);
                    d = scale * sampledOutHeight + 0.5;
                    bl10 = false;
                    int n4 = (int)Math.ceil(d);
                    Bitmap.Config config = $this$decodeInterruptible_u24lambda_u2d7.inPreferredConfig;
                    Intrinsics.checkNotNullExpressionValue((Object)config, (String)"inPreferredConfig");
                    bitmap = pool.getDirty(n, n4, config);
                } else {
                    bitmap = null;
                }
                $this$decodeInterruptible_u24lambda_u2d7.inBitmap = bitmap;
            }
        }
        Bitmap inBitmap = $this$decodeInterruptible_u24lambda_u2d7.inBitmap;
        BufferedSource outBitmap = null;
        try {
            Object height = (Closeable)safeBufferedSource;
            bl8 = false;
            boolean bl11 = false;
            Throwable throwable = null;
            try {
                Bitmap bitmap;
                BufferedSource it = (BufferedSource)height;
                boolean bl12 = false;
                if (Build.VERSION.SDK_INT < 19 && $this$decodeInterruptible_u24lambda_u2d7.outMimeType == null) {
                    byte[] bytes = it.readByteArray();
                    bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)$this$decodeInterruptible_u24lambda_u2d7);
                } else {
                    bitmap = BitmapFactory.decodeStream((InputStream)it.inputStream(), null, (BitmapFactory.Options)$this$decodeInterruptible_u24lambda_u2d7);
                }
                it = bitmap;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)height, (Throwable)throwable);
            }
            outBitmap = it;
            height = safeSource.getException();
            if (height != null) {
                Object bl8 = height;
                boolean bl13 = false;
                boolean it = false;
                Object it3 = bl8;
                boolean bl14 = false;
                throw it3;
            }
        }
        catch (Throwable throwable) {
            boolean it3;
            boolean it;
            Bitmap bitmap;
            Bitmap bl8 = inBitmap;
            if (bl8 != null) {
                bitmap = bl8;
                it = false;
                it3 = false;
                p0 = bitmap;
                boolean bl15 = false;
                pool.put(p0);
            }
            if (outBitmap != inBitmap && (bl8 = outBitmap) != null) {
                bitmap = bl8;
                it = false;
                it3 = false;
                p0 = bitmap;
                boolean bl16 = false;
                pool.put(p0);
            }
            throw throwable;
        }
        boolean throwable = false;
        bl8 = false;
        if (outBitmap == null) {
            boolean bl17 = false;
            String bl8 = "BitmapFactory returned a null bitmap. Often this means BitmapFactory could not decode the image data read from the input source (e.g. network, disk, or memory) as it's not encoded as a valid image format.";
            throw (Throwable)new IllegalStateException(bl8.toString());
        }
        outBitmap.setDensity(options.getContext().getResources().getDisplayMetrics().densityDpi);
        Bitmap.Config bl8 = $this$decodeInterruptible_u24lambda_u2d7.inPreferredConfig;
        Intrinsics.checkNotNullExpressionValue((Object)bl8, (String)"inPreferredConfig");
        Bitmap bitmap = this.applyExifTransformations(pool, (Bitmap)outBitmap, bl8, isFlipped, rotationDegrees);
        bl8 = bitmap;
        Context context$iv = this.context;
        boolean $i$f$toDrawable = false;
        void it3 = $this$toDrawable$iv;
        p0 = context$iv.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)p0, (String)"context.resources");
        Bitmap resources$iv$iv = p0;
        boolean $i$f$toDrawable2 = false;
        return new DecodeResult((Drawable)new BitmapDrawable((Resources)resources$iv$iv, (Bitmap)$this$toDrawable$iv$iv), $this$decodeInterruptible_u24lambda_u2d7.inSampleSize > 1 || $this$decodeInterruptible_u24lambda_u2d7.inScaled);
    }

    private final boolean shouldReadExifData(String mimeType) {
        return mimeType != null && ArraysKt.contains((Object[])SUPPORTED_EXIF_MIME_TYPES, (Object)mimeType);
    }

    private final Bitmap.Config computeConfig(BitmapFactory.Options $this$computeConfig, Options options, boolean isFlipped, int rotationDegrees) {
        Bitmap.Config config = options.getConfig();
        if (isFlipped || rotationDegrees > 0) {
            config = -Bitmaps.toSoftware(config);
        }
        if (options.getAllowRgb565() && config == Bitmap.Config.ARGB_8888 && Intrinsics.areEqual((Object)$this$computeConfig.outMimeType, (Object)MIME_TYPE_JPEG)) {
            config = Bitmap.Config.RGB_565;
        }
        if (Build.VERSION.SDK_INT >= 26 && $this$computeConfig.outConfig == Bitmap.Config.RGBA_F16 && config != Bitmap.Config.HARDWARE) {
            config = Bitmap.Config.RGBA_F16;
        }
        return config;
    }

    private final Bitmap applyExifTransformations(BitmapPool pool, Bitmap inBitmap, Bitmap.Config config, boolean isFlipped, int rotationDegrees) {
        Canvas c$iv;
        Bitmap outBitmap;
        Bitmap bitmap;
        boolean isRotated;
        boolean bl = isRotated = rotationDegrees > 0;
        if (!isFlipped && !isRotated) {
            return inBitmap;
        }
        Matrix matrix = new Matrix();
        float centerX = (float)inBitmap.getWidth() / 2.0f;
        float centerY = (float)inBitmap.getHeight() / 2.0f;
        if (isFlipped) {
            matrix.postScale(-1.0f, 1.0f, centerX, centerY);
        }
        if (isRotated) {
            matrix.postRotate((float)rotationDegrees, centerX, centerY);
        }
        RectF rect = new RectF(0.0f, 0.0f, (float)inBitmap.getWidth(), (float)inBitmap.getHeight());
        matrix.mapRect(rect);
        if (!(rect.left == 0.0f) || !(rect.top == 0.0f)) {
            matrix.postTranslate(-rect.left, -rect.top);
        }
        switch (rotationDegrees) {
            case 90: 
            case 270: {
                bitmap = pool.get(inBitmap.getHeight(), inBitmap.getWidth(), config);
                break;
            }
            default: {
                bitmap = pool.get(inBitmap.getWidth(), inBitmap.getHeight(), config);
            }
        }
        Bitmap $this$applyCanvas$iv = outBitmap = bitmap;
        boolean $i$f$applyCanvas = false;
        Canvas $this$applyExifTransformations_u24lambda_u2d8 = c$iv = new Canvas($this$applyCanvas$iv);
        boolean bl2 = false;
        $this$applyExifTransformations_u24lambda_u2d8.drawBitmap(inBitmap, matrix, this.paint);
        pool.put(inBitmap);
        return outBitmap;
    }

    static {
        String[] stringArray = new String[]{MIME_TYPE_JPEG, MIME_TYPE_WEBP, MIME_TYPE_HEIC, MIME_TYPE_HEIF};
        SUPPORTED_EXIF_MIME_TYPES = stringArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016R.\u0010\b\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u00072\u000e\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcoil/decode/BitmapFactoryDecoder$ExceptionCatchingSource;", "Lokio/ForwardingSource;", "delegate", "Lokio/Source;", "(Lokio/Source;)V", "<set-?>", "Ljava/lang/Exception;", "Lkotlin/Exception;", "exception", "getException", "()Ljava/lang/Exception;", "read", "", "sink", "Lokio/Buffer;", "byteCount", "coil-base_release"})
    private static final class ExceptionCatchingSource
    extends ForwardingSource {
        @Nullable
        private Exception exception;

        public ExceptionCatchingSource(@NotNull Source delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            super(delegate);
        }

        @Nullable
        public final Exception getException() {
            return this.exception;
        }

        public long read(@NotNull Buffer sink, long byteCount) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            try {
                return super.read(sink, byteCount);
            }
            catch (Exception e) {
                this.exception = e;
                throw e;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcoil/decode/BitmapFactoryDecoder$ExifInterfaceInputStream;", "Ljava/io/InputStream;", "delegate", "(Ljava/io/InputStream;)V", "availableBytes", "", "available", "close", "", "interceptBytesRead", "bytesRead", "read", "b", "", "off", "len", "skip", "", "n", "coil-base_release"})
    private static final class ExifInterfaceInputStream
    extends InputStream {
        @NotNull
        private final InputStream delegate;
        private volatile int availableBytes;

        public ExifInterfaceInputStream(@NotNull InputStream delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.delegate = delegate;
            this.availableBytes = 0x40000000;
        }

        @Override
        public int read() {
            return this.interceptBytesRead(this.delegate.read());
        }

        @Override
        public int read(@NotNull byte[] b) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return this.interceptBytesRead(this.delegate.read(b));
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return this.interceptBytesRead(this.delegate.read(b, off, len));
        }

        @Override
        public long skip(long n) {
            return this.delegate.skip(n);
        }

        @Override
        public int available() {
            return this.availableBytes;
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        private final int interceptBytesRead(int bytesRead) {
            if (bytesRead == -1) {
                this.availableBytes = 0;
            }
            return bytesRead;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcoil/decode/BitmapFactoryDecoder$Companion;", "", "()V", "GIGABYTE_IN_BYTES", "", "MIME_TYPE_HEIC", "", "MIME_TYPE_HEIF", "MIME_TYPE_JPEG", "MIME_TYPE_WEBP", "SUPPORTED_EXIF_MIME_TYPES", "", "[Ljava/lang/String;", "coil-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

