/*
 * Decompiled with CFR 0.152.
 */
package coil.memory;

import android.graphics.Bitmap;
import android.view.View;
import androidx.annotation.AnyThread;
import androidx.annotation.MainThread;
import androidx.collection.SimpleArrayMap;
import coil.memory.ViewTargetRequestDelegate;
import coil.request.ImageResult;
import coil.util.-Extensions;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0007J\b\u0010\u001e\u001a\u00020\nH\u0003J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!H\u0017J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!H\u0017J\u001c\u0010#\u001a\u0004\u0018\u00010\u00062\u0006\u0010$\u001a\u00020\u00052\b\u0010%\u001a\u0004\u0018\u00010\u0006H\u0007J\u0012\u0010&\u001a\u00020\u001d2\b\u0010'\u001a\u0004\u0018\u00010\bH\u0007J\u0010\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u000eH\u0007R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\"\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcoil/memory/ViewTargetRequestManager;", "Landroid/view/View$OnAttachStateChangeListener;", "()V", "bitmaps", "Landroidx/collection/SimpleArrayMap;", "", "Landroid/graphics/Bitmap;", "currentRequest", "Lcoil/memory/ViewTargetRequestDelegate;", "<set-?>", "Ljava/util/UUID;", "currentRequestId", "getCurrentRequestId", "()Ljava/util/UUID;", "Lkotlinx/coroutines/Job;", "currentRequestJob", "getCurrentRequestJob", "()Lkotlinx/coroutines/Job;", "isRestart", "", "metadata", "Lcoil/request/ImageResult$Metadata;", "getMetadata", "()Lcoil/request/ImageResult$Metadata;", "setMetadata", "(Lcoil/request/ImageResult$Metadata;)V", "pendingClear", "skipAttach", "clearCurrentRequest", "", "newRequestId", "onViewAttachedToWindow", "v", "Landroid/view/View;", "onViewDetachedFromWindow", "put", "tag", "bitmap", "setCurrentRequest", "request", "setCurrentRequestJob", "job", "coil-base_release"})
public final class ViewTargetRequestManager
implements View.OnAttachStateChangeListener {
    @Nullable
    private ViewTargetRequestDelegate currentRequest;
    @Nullable
    private volatile UUID currentRequestId;
    @Nullable
    private volatile Job currentRequestJob;
    @Nullable
    private volatile ImageResult.Metadata metadata;
    @Nullable
    private volatile Job pendingClear;
    private boolean isRestart;
    private boolean skipAttach = true;
    @NotNull
    private final SimpleArrayMap<Object, Bitmap> bitmaps = new SimpleArrayMap();

    @Nullable
    public final UUID getCurrentRequestId() {
        return this.currentRequestId;
    }

    @Nullable
    public final Job getCurrentRequestJob() {
        return this.currentRequestJob;
    }

    @Nullable
    public final ImageResult.Metadata getMetadata() {
        return this.metadata;
    }

    public final void setMetadata(@Nullable ImageResult.Metadata metadata) {
        this.metadata = metadata;
    }

    @MainThread
    @Nullable
    public final Bitmap put(@NotNull Object tag, @Nullable Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return bitmap != null ? (Bitmap)this.bitmaps.put(tag, (Object)bitmap) : (Bitmap)this.bitmaps.remove(tag);
    }

    @MainThread
    public final void setCurrentRequest(@Nullable ViewTargetRequestDelegate request) {
        Object object;
        if (this.isRestart) {
            this.isRestart = false;
        } else {
            object = this.pendingClear;
            if (object != null) {
                Job.DefaultImpls.cancel$default((Job)object, null, (int)1, null);
            }
            this.pendingClear = null;
        }
        object = this.currentRequest;
        if (object != null) {
            ((ViewTargetRequestDelegate)object).dispose();
        }
        this.currentRequest = request;
        this.skipAttach = true;
    }

    @AnyThread
    @NotNull
    public final UUID setCurrentRequestJob(@NotNull Job job2) {
        UUID requestId;
        Intrinsics.checkNotNullParameter((Object)job2, (String)"job");
        this.currentRequestId = requestId = this.newRequestId();
        this.currentRequestJob = job2;
        return requestId;
    }

    @AnyThread
    public final void clearCurrentRequest() {
        this.currentRequestId = null;
        this.currentRequestJob = null;
        Job job2 = this.pendingClear;
        if (job2 != null) {
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
        this.pendingClear = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.INSTANCE.getMain().getImmediate())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ViewTargetRequestManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.setCurrentRequest(null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @MainThread
    public void onViewAttachedToWindow(@NotNull View v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        if (this.skipAttach) {
            this.skipAttach = false;
            return;
        }
        ViewTargetRequestDelegate viewTargetRequestDelegate = this.currentRequest;
        if (viewTargetRequestDelegate != null) {
            ViewTargetRequestDelegate viewTargetRequestDelegate2 = viewTargetRequestDelegate;
            boolean bl = false;
            boolean bl2 = false;
            ViewTargetRequestDelegate request = viewTargetRequestDelegate2;
            boolean bl3 = false;
            this.isRestart = true;
            request.restart();
        }
    }

    @MainThread
    public void onViewDetachedFromWindow(@NotNull View v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.skipAttach = false;
        ViewTargetRequestDelegate viewTargetRequestDelegate = this.currentRequest;
        if (viewTargetRequestDelegate != null) {
            viewTargetRequestDelegate.dispose();
        }
    }

    @AnyThread
    private final UUID newRequestId() {
        UUID requestId = this.currentRequestId;
        if (requestId != null && this.isRestart && -Extensions.isMainThread()) {
            return requestId;
        }
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID()");
        return uUID;
    }
}

